/*
 * Decompiled with CFR 0.152.
 */
package plugins.kernel.roi.roi2d;

import icy.math.ArrayMath;
import icy.resource.ResourceUtil;
import icy.sequence.Sequence;
import icy.type.point.Point5D;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.Collection;
import plugins.kernel.roi.roi2d.ROI2DRectShape;

public class ROI2DEllipse
extends ROI2DRectShape {
    @Deprecated
    public ROI2DEllipse(Point2D topLeft, Point2D bottomRight, boolean cm) {
        this(topLeft, bottomRight);
    }

    public ROI2DEllipse(Point2D topLeft, Point2D bottomRight) {
        super(new Ellipse2D.Double(), topLeft, bottomRight);
        this.setIcon(ResourceUtil.ICON_ROI_OVAL);
    }

    public ROI2DEllipse(double xmin, double ymin, double xmax, double ymax) {
        this((Point2D)new Point2D.Double(xmin, ymin), new Point2D.Double(xmax, ymax));
    }

    @Deprecated
    public ROI2DEllipse(Rectangle2D rectangle, boolean cm) {
        this(rectangle);
    }

    public ROI2DEllipse(Rectangle2D rectangle) {
        this(rectangle.getMinX(), rectangle.getMinY(), rectangle.getMaxX(), rectangle.getMaxY());
    }

    public ROI2DEllipse(Ellipse2D ellipse) {
        this(ellipse.getBounds2D());
    }

    @Deprecated
    public ROI2DEllipse(Point2D pt, boolean cm) {
        this(pt);
    }

    public ROI2DEllipse(Point2D pt) {
        this((Point2D)new Point2D.Double(pt.getX(), pt.getY()), pt);
    }

    public ROI2DEllipse(Point5D pt) {
        this(pt.toPoint2D());
    }

    public ROI2DEllipse() {
        this((Point2D)new Point2D.Double(), new Point2D.Double());
    }

    @Override
    public String getDefaultName() {
        return "Ellipse2D";
    }

    public Ellipse2D getEllipse() {
        return (Ellipse2D)this.shape;
    }

    public void setEllipse(Ellipse2D ellipse) {
        this.setBounds2D(ellipse.getBounds2D());
    }

    @Override
    public double getLength(Sequence sequence) throws UnsupportedOperationException {
        Ellipse2D ellipse = this.getEllipse();
        return ROI2DEllipse.computeEllipsePerimeter(ellipse.getWidth() * 0.5 * sequence.getPixelSizeX(), ellipse.getHeight() * 0.5 * sequence.getPixelSizeY());
    }

    @Override
    public double computeNumberOfContourPoints() {
        Ellipse2D ellipse = this.getEllipse();
        return ROI2DEllipse.computeEllipsePerimeter(ellipse.getWidth() * 0.5, ellipse.getHeight() * 0.5);
    }

    public static double computeEllipsePerimeter(double w, double h) {
        double result = (w - h) / (w + h);
        result *= result;
        return Math.PI * (w + h) * (1.0 + result / 4.0 + result * result / 64.0 + result * result * result / 256.0);
    }

    @Override
    public double computeNumberOfPoints() {
        Ellipse2D ellipse = this.getEllipse();
        return Math.PI * ellipse.getWidth() * ellipse.getHeight() / 4.0;
    }

    public void setToFitCircle(Collection<? extends Point2D> points) {
        int nbPoints = points.size();
        double[] xCoords = new double[nbPoints];
        double[] yCoords = new double[nbPoints];
        for (Point2D point2D : points) {
            xCoords[--nbPoints] = point2D.getX();
            yCoords[nbPoints] = point2D.getY();
        }
        this.setToFitCircle(xCoords, yCoords);
    }

    private void setToFitCircle(double[] xCoords, double[] yCoords) {
        int n = xCoords.length;
        if (n != yCoords.length) {
            throw new IllegalArgumentException("Coordinate arrays must have the same size");
        }
        Point2D.Double centroid = new Point2D.Double(ArrayMath.mean(xCoords), ArrayMath.mean(yCoords));
        double[] buffer = new double[n];
        double[] X = ArrayMath.subtract(xCoords, ((Point2D)centroid).getX());
        double[] Y = ArrayMath.subtract(yCoords, ((Point2D)centroid).getY());
        double[] XX = ArrayMath.multiply(X, X);
        double[] YY = ArrayMath.multiply(Y, Y);
        double[] Z = ArrayMath.add(XX, YY);
        double Mxx = ArrayMath.sum(XX) / (double)n;
        double Mxy = ArrayMath.sum(ArrayMath.multiply(X, Y, buffer)) / (double)n;
        double Myy = ArrayMath.sum(YY) / (double)n;
        double Mxz = ArrayMath.sum(ArrayMath.multiply(X, Z, buffer)) / (double)n;
        double Myz = ArrayMath.sum(ArrayMath.multiply(Y, Z, buffer)) / (double)n;
        double Mzz = ArrayMath.sum(ArrayMath.multiply(Z, Z, buffer)) / (double)n;
        double Mz = Mxx + Myy;
        double Cov_xy = Mxx * Myy - Mxy * Mxy;
        double A3 = 4.0 * Mz;
        double A2 = -3.0 * Mz * Mz - Mzz;
        double A1 = Mzz * Mz + 4.0 * Cov_xy * Mz - Mxz * Mxz - Myz * Myz - Mz * Mz * Mz;
        double A0 = Mxz * Mxz * Myy + Myz * Myz * Mxx - Mzz * Cov_xy - 2.0 * Mxz * Myz * Mxy + Mz * Mz * Cov_xy;
        double A22 = A2 + A2;
        double A33 = A3 + A3 + A3;
        double xnew = 0.0;
        double ynew = 1.0E20;
        double epsilon = 1.0E-12;
        int IterMax = 20;
        int iter = 0;
        while (iter < IterMax) {
            double yold = ynew;
            ynew = A0 + xnew * (A1 + xnew * (A2 + xnew * A3));
            if (Math.abs(ynew) > Math.abs(yold)) {
                System.err.println("Circle fitting error: Newton-Taubin goes wrong direction: |ynew| > |yold|");
                xnew = 0.0;
                break;
            }
            double xold = xnew;
            double Dy = A1 + xnew * (A22 + xnew * A33);
            if (Math.abs(((xnew = xold - ynew / Dy) - xold) / xnew) < epsilon) break;
            if (iter >= IterMax) {
                System.err.println("Circle fitting error: Newton-Taubin will not converge");
                xnew = 0.0;
            }
            if (xnew < 0.0) {
                System.out.println("Newton-Taubin negative root: x=" + xnew);
                xnew = 0.0;
            }
            ++iter;
        }
        double DET = xnew * xnew - xnew * Mz + Cov_xy;
        double xCenter = (Mxz * (Myy - xnew) - Myz * Mxy) / DET / 2.0;
        double yCenter = (Myz * (Mxx - xnew) - Mxz * Mxy) / DET / 2.0;
        double radius = Math.sqrt(xCenter * xCenter + yCenter * yCenter + Mz);
        this.setEllipse(new Ellipse2D.Double((xCenter += ((Point2D)centroid).getX()) - radius, (yCenter += ((Point2D)centroid).getY()) - radius, 2.0 * radius, 2.0 * radius));
    }
}

