/*
 * Decompiled with CFR 0.152.
 */
package icy.gui.dialog;

import icy.gui.util.ComponentUtil;
import icy.main.Icy;
import icy.resource.ResourceUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JPanel;

public class ActionDialog
extends JDialog
implements ActionListener {
    private static final long serialVersionUID = -8071873763517931268L;
    protected static final String OK_CMD = "ok";
    protected static final String CANCEL_CMD = "cancel";
    protected JPanel mainPanel;
    protected JPanel buttonPanel;
    JButton okBtn;
    JButton cancelBtn;
    private ActionListener okAction;
    private boolean closeAfterAction;
    boolean opened;
    boolean canceled;
    boolean closed;

    public ActionDialog(String title, JComponent component, Frame owner) {
        super(owner, title, true);
        this.initialize(component);
        this.okBtn.setActionCommand(OK_CMD);
        this.cancelBtn.setActionCommand(CANCEL_CMD);
        this.okBtn.addActionListener(this);
        this.cancelBtn.addActionListener(this);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowOpened(WindowEvent e) {
                ActionDialog.this.opened = true;
            }

            @Override
            public void windowClosed(WindowEvent e) {
                ActionDialog.this.closed = true;
                ActionDialog.this.onClosed();
            }
        });
        this.okAction = null;
        this.closeAfterAction = true;
        this.opened = false;
        this.canceled = true;
        this.closed = false;
    }

    public ActionDialog(String title, JComponent component) {
        this(title, component, (Frame)((Object)Icy.getMainInterface().getMainFrame()));
    }

    public ActionDialog(String title) {
        this(title, null, (Frame)((Object)Icy.getMainInterface().getMainFrame()));
    }

    @Deprecated
    public ActionDialog(Frame owner, String title) {
        this(title, null, owner);
    }

    private void initialize(JComponent component) {
        this.setIconImages(ResourceUtil.getIcyIconImages());
        this.setDefaultCloseOperation(2);
        if (component instanceof JPanel) {
            this.mainPanel = (JPanel)component;
        } else {
            this.mainPanel = new JPanel();
            this.mainPanel.setLayout(new BorderLayout());
            if (component != null) {
                this.mainPanel.add((Component)component, "Center");
            }
        }
        this.buttonPanel = new JPanel();
        this.buttonPanel.setBorder(BorderFactory.createEmptyBorder(8, 8, 8, 8));
        GridBagLayout gbl_buttonPanel = new GridBagLayout();
        int[] nArray = new int[7];
        nArray[2] = 45;
        nArray[3] = 65;
        gbl_buttonPanel.columnWidths = nArray;
        int[] nArray2 = new int[2];
        nArray2[0] = 23;
        gbl_buttonPanel.rowHeights = nArray2;
        gbl_buttonPanel.columnWeights = new double[]{0.0, 0.0, 1.0, 1.0, 0.0, 0.0, Double.MIN_VALUE};
        gbl_buttonPanel.rowWeights = new double[]{0.0, Double.MIN_VALUE};
        this.buttonPanel.setLayout(gbl_buttonPanel);
        this.okBtn = new JButton("Ok");
        GridBagConstraints gbc_okBtn = new GridBagConstraints();
        gbc_okBtn.anchor = 13;
        gbc_okBtn.insets = new Insets(0, 0, 0, 5);
        gbc_okBtn.gridx = 2;
        gbc_okBtn.gridy = 0;
        this.buttonPanel.add((Component)this.okBtn, gbc_okBtn);
        this.cancelBtn = new JButton("Cancel");
        GridBagConstraints gbc_cancelBtn = new GridBagConstraints();
        gbc_cancelBtn.insets = new Insets(0, 0, 0, 5);
        gbc_cancelBtn.anchor = 17;
        gbc_cancelBtn.gridx = 3;
        gbc_cancelBtn.gridy = 0;
        this.buttonPanel.add((Component)this.cancelBtn, gbc_cancelBtn);
        this.getContentPane().add((Component)this.mainPanel, "Center");
        this.getContentPane().add((Component)this.buttonPanel, "South");
    }

    protected void onClosed() {
    }

    public boolean isClosed() {
        return this.closed;
    }

    public boolean isCanceled() {
        return this.opened && this.canceled;
    }

    public boolean isCloseAfterAction() {
        return this.closeAfterAction;
    }

    public void setCloseAfterAction(boolean closeAfterAction) {
        this.closeAfterAction = closeAfterAction;
    }

    public ActionListener getOkAction() {
        return this.okAction;
    }

    public void setOkAction(ActionListener okAction) {
        this.okAction = okAction;
    }

    public JPanel getMainPanel() {
        return this.mainPanel;
    }

    public JPanel getButtonPanel() {
        return this.buttonPanel;
    }

    public JButton getOkBtn() {
        return this.okBtn;
    }

    public JButton getCancelBtn() {
        return this.cancelBtn;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        String cmd = e.getActionCommand();
        if (CANCEL_CMD.equals(cmd)) {
            this.dispose();
        } else if (OK_CMD.equals(cmd)) {
            this.canceled = false;
            if (this.okAction != null) {
                this.okAction.actionPerformed(e);
            }
            if (this.closeAfterAction) {
                this.dispose();
            }
        }
    }

    @Override
    public void reshape(int x, int y, int width, int height) {
        Rectangle r = new Rectangle(x, y, width, height);
        ComponentUtil.fixPosition(this, r);
        super.reshape(r.x, r.y, r.width, r.height);
    }
}

