/*
 * Decompiled with CFR 0.152.
 */
package icy.gui.dialog;

import icy.gui.component.NumberTextField;
import icy.math.MathUtil;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class SaverOptionPanel
extends JPanel {
    private JLabel overwriteMetaLabel;
    private JLabel fpsLabel;
    private JLabel multipleFilesLabel;
    private JCheckBox overwriteMetaCheckbox;
    private NumberTextField fpsField;
    private JCheckBox multipleFilesCheckbox;
    private NumberTextField msField;
    private JLabel msLabel;
    private boolean synching;

    public SaverOptionPanel() {
        this.initialize();
        this.fpsField.addValueListener(new NumberTextField.ValueChangeListener(){

            @Override
            public void valueChanged(double newValue, boolean validate) {
                if (validate) {
                    SaverOptionPanel.this.syncTime(true);
                }
            }
        });
        this.msField.addValueListener(new NumberTextField.ValueChangeListener(){

            @Override
            public void valueChanged(double newValue, boolean validate) {
                if (validate) {
                    SaverOptionPanel.this.syncTime(false);
                }
            }
        });
        this.synching = false;
    }

    private void initialize() {
        GridBagLayout gridBagLayout = new GridBagLayout();
        int[] nArray = new int[3];
        nArray[1] = 50;
        gridBagLayout.columnWidths = nArray;
        gridBagLayout.rowHeights = new int[5];
        gridBagLayout.columnWeights = new double[]{1.0, 0.0, Double.MIN_VALUE};
        gridBagLayout.rowWeights = new double[]{0.0, 0.0, 0.0, 0.0, Double.MIN_VALUE};
        this.setLayout(gridBagLayout);
        this.multipleFilesLabel = new JLabel(" Save as multiple files");
        this.multipleFilesLabel.setToolTipText("Save each slice/frame in a separate file");
        GridBagConstraints gbc_lblNewLabel = new GridBagConstraints();
        gbc_lblNewLabel.anchor = 17;
        gbc_lblNewLabel.insets = new Insets(0, 0, 5, 5);
        gbc_lblNewLabel.gridx = 0;
        gbc_lblNewLabel.gridy = 0;
        this.add((Component)this.multipleFilesLabel, gbc_lblNewLabel);
        this.multipleFilesCheckbox = new JCheckBox("");
        this.multipleFilesCheckbox.setToolTipText("Save each slice/frame in a separate file");
        GridBagConstraints gbc_multipleFilesCheckbox = new GridBagConstraints();
        gbc_multipleFilesCheckbox.anchor = 13;
        gbc_multipleFilesCheckbox.insets = new Insets(0, 0, 5, 0);
        gbc_multipleFilesCheckbox.gridx = 1;
        gbc_multipleFilesCheckbox.gridy = 0;
        this.add((Component)this.multipleFilesCheckbox, gbc_multipleFilesCheckbox);
        this.fpsLabel = new JLabel(" Frame per second");
        this.fpsLabel.setToolTipText("Number of frame per second");
        GridBagConstraints gbc_lblNewLabel_1 = new GridBagConstraints();
        gbc_lblNewLabel_1.anchor = 17;
        gbc_lblNewLabel_1.insets = new Insets(0, 0, 5, 5);
        gbc_lblNewLabel_1.gridx = 0;
        gbc_lblNewLabel_1.gridy = 1;
        this.add((Component)this.fpsLabel, gbc_lblNewLabel_1);
        this.fpsField = new NumberTextField();
        this.fpsField.setInteger(true);
        this.fpsField.setHorizontalAlignment(4);
        this.fpsField.setNumericValue(20.0);
        this.fpsField.setToolTipText("Number of frame per second");
        GridBagConstraints gbc_fpsField = new GridBagConstraints();
        gbc_fpsField.fill = 2;
        gbc_fpsField.insets = new Insets(0, 0, 5, 0);
        gbc_fpsField.gridx = 1;
        gbc_fpsField.gridy = 1;
        this.add((Component)this.fpsField, gbc_fpsField);
        this.msLabel = new JLabel(" Time interval (ms)");
        this.msLabel.setToolTipText("Time interval between 2 frames (ms)");
        GridBagConstraints gbc_msLabel = new GridBagConstraints();
        gbc_msLabel.anchor = 17;
        gbc_msLabel.insets = new Insets(0, 0, 5, 5);
        gbc_msLabel.gridx = 0;
        gbc_msLabel.gridy = 2;
        this.add((Component)this.msLabel, gbc_msLabel);
        this.msField = new NumberTextField();
        this.msField.setHorizontalAlignment(4);
        this.msField.setToolTipText("Time interval between 2 frames (ms)");
        GridBagConstraints gbc_msField = new GridBagConstraints();
        gbc_msField.fill = 2;
        gbc_msField.insets = new Insets(0, 0, 5, 0);
        gbc_msField.gridx = 1;
        gbc_msField.gridy = 2;
        this.add((Component)this.msField, gbc_msField);
        this.overwriteMetaLabel = new JLabel(" Overwrite metadata name");
        this.overwriteMetaLabel.setToolTipText("Overwrite metadata name with filename");
        GridBagConstraints gbc_lblNewLabel_2 = new GridBagConstraints();
        gbc_lblNewLabel_2.anchor = 17;
        gbc_lblNewLabel_2.insets = new Insets(0, 0, 0, 5);
        gbc_lblNewLabel_2.gridx = 0;
        gbc_lblNewLabel_2.gridy = 3;
        this.add((Component)this.overwriteMetaLabel, gbc_lblNewLabel_2);
        this.overwriteMetaCheckbox = new JCheckBox("");
        this.overwriteMetaCheckbox.setToolTipText("Overwrite metadata name with filename");
        GridBagConstraints gbc_overwriteMetaCheckbox = new GridBagConstraints();
        gbc_overwriteMetaCheckbox.anchor = 12;
        gbc_overwriteMetaCheckbox.gridx = 1;
        gbc_overwriteMetaCheckbox.gridy = 3;
        this.add((Component)this.overwriteMetaCheckbox, gbc_overwriteMetaCheckbox);
    }

    void syncTime(boolean fromFPS) {
        if (this.synching) {
            return;
        }
        this.synching = true;
        try {
            if (fromFPS) {
                double v = this.fpsField.getNumericValue();
                if (v > 0.0) {
                    this.msField.setNumericValue(MathUtil.roundSignificant(1000.0 / v, 5, true));
                }
            } else {
                double v = this.msField.getNumericValue();
                if (v > 0.0) {
                    this.fpsField.setNumericValue(MathUtil.roundSignificant(1000.0 / v, 5, true));
                }
            }
        }
        finally {
            this.synching = false;
        }
    }

    public boolean isFramePerSecondVisible() {
        return this.fpsField.isVisible();
    }

    public void setFramePerSecondVisible(boolean value) {
        this.fpsLabel.setVisible(value);
        this.fpsField.setVisible(value);
        this.msLabel.setVisible(value);
        this.msField.setVisible(value);
    }

    public boolean isMultipleFilesVisible() {
        return this.multipleFilesCheckbox.isVisible();
    }

    public void setMultipleFilesVisible(boolean value) {
        this.multipleFilesLabel.setVisible(value);
        this.multipleFilesCheckbox.setVisible(value);
    }

    public void setForcedMultipleFilesOn() {
        this.multipleFilesCheckbox.setEnabled(false);
        this.multipleFilesCheckbox.setSelected(true);
    }

    public void setForcedMultipleFilesOff() {
        this.multipleFilesCheckbox.setEnabled(false);
        this.multipleFilesCheckbox.setSelected(false);
    }

    public void removeForcedMultipleFiles() {
        this.multipleFilesCheckbox.setEnabled(true);
        this.multipleFilesCheckbox.setSelected(false);
    }

    public boolean isOverwriteMetadataVisible() {
        return this.overwriteMetaCheckbox.isVisible();
    }

    public void setOverwriteMetadataVisible(boolean value) {
        this.overwriteMetaLabel.setVisible(value);
        this.overwriteMetaCheckbox.setVisible(value);
    }

    public int getFramePerSecond() {
        return (int)this.fpsField.getNumericValue();
    }

    public void setFramePerSecond(int value) {
        this.fpsField.setNumericValue(value);
    }

    public double getTimeInterval() {
        return this.msField.getNumericValue();
    }

    public void setTimeInterval(double value) {
        this.msField.setNumericValue(value);
    }

    public boolean getMultipleFiles() {
        return this.multipleFilesCheckbox.isSelected();
    }

    public void setMultipleFiles(boolean value) {
        this.multipleFilesCheckbox.setSelected(value);
    }

    public boolean getOverwriteMetadata() {
        return this.overwriteMetaCheckbox.isSelected();
    }

    public void setOverwriteMetadata(boolean value) {
        this.overwriteMetaCheckbox.setSelected(value);
    }
}

