/*
 * Decompiled with CFR 0.152.
 */
package icy.gui.frame.progress;

import icy.gui.frame.IcyFrame;
import icy.gui.frame.progress.TaskFrame;
import icy.gui.util.GuiUtil;
import icy.network.NetworkUtil;
import icy.preferences.GeneralPreferences;
import icy.system.thread.ThreadUtil;
import icy.util.StringUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Timer;
import java.util.TimerTask;
import javax.swing.Box;
import javax.swing.JCheckBox;
import javax.swing.JEditorPane;
import javax.swing.UIManager;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import javax.swing.text.html.HTMLDocument;

public class ToolTipFrame
extends TaskFrame {
    Timer timer;
    JEditorPane editorPane;
    JCheckBox doNotDisplayCheckbox;
    final int liveTime;
    final String id;

    public ToolTipFrame(final String message, int liveTime, String id) {
        this.liveTime = liveTime;
        this.id = id;
        if (this.headless) {
            return;
        }
        if (!(StringUtil.isEmpty(id) || GeneralPreferences.getPreferencesToolTips().getBoolean(id, true) && !this.alreadyExist(id))) {
            this.close();
            return;
        }
        if (liveTime != 0) {
            this.timer = new Timer("ToolTip timer");
            this.timer.schedule(new TimerTask(){

                @Override
                public void run() {
                    ToolTipFrame.this.doClose();
                }
            }, liveTime * 1000);
        }
        ThreadUtil.invokeLater(new Runnable(){

            @Override
            public void run() {
                ToolTipFrame.this.editorPane = new JEditorPane("text/html", message);
                ToolTipFrame.this.editorPane.setMinimumSize(new Dimension(240, 60));
                ToolTipFrame.this.editorPane.setEditable(false);
                ToolTipFrame.this.editorPane.setToolTipText("Click to close the tool tip");
                Font font = UIManager.getFont("Label.font");
                String bodyRule = "body { font-family: " + font.getFamily() + "; " + "font-size: " + font.getSize() + "pt; }";
                ((HTMLDocument)ToolTipFrame.this.editorPane.getDocument()).getStyleSheet().addRule(bodyRule);
                ToolTipFrame.this.editorPane.addMouseListener(new MouseAdapter(){

                    @Override
                    public void mouseClicked(MouseEvent e) {
                        ToolTipFrame.this.doClose();
                    }
                });
                ToolTipFrame.this.editorPane.addHyperlinkListener(new HyperlinkListener(){

                    @Override
                    public void hyperlinkUpdate(HyperlinkEvent e) {
                        if (e.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
                            NetworkUtil.openBrowser(e.getURL());
                        }
                    }
                });
                ToolTipFrame.this.doNotDisplayCheckbox = new JCheckBox("Do not display again", false);
                ToolTipFrame.this.doNotDisplayCheckbox.setToolTipText("Do not display this tooltip the next time");
                ToolTipFrame.this.mainPanel.setLayout(new BorderLayout());
                ToolTipFrame.this.mainPanel.add((Component)ToolTipFrame.this.editorPane, "Center");
                if (!StringUtil.isEmpty(ToolTipFrame.this.id)) {
                    ToolTipFrame.this.mainPanel.add((Component)GuiUtil.createLineBoxPanel(ToolTipFrame.this.doNotDisplayCheckbox, Box.createHorizontalGlue()), "South");
                }
                ToolTipFrame.this.pack();
            }
        });
    }

    public ToolTipFrame(String message, String id) {
        this(message, 0, id);
    }

    public ToolTipFrame(String message, int liveTime) {
        this(message, liveTime, "");
    }

    public ToolTipFrame(String message) {
        this(message, 0, "");
    }

    private boolean alreadyExist(String id) {
        ArrayList<IcyFrame> frames = IcyFrame.getAllFrames(ToolTipFrame.class);
        for (IcyFrame f : frames) {
            if (f == this || !((ToolTipFrame)f).id.equals(id)) continue;
            return true;
        }
        return false;
    }

    void doClose() {
        if (!StringUtil.isEmpty(this.id) && this.doNotDisplayCheckbox.isSelected()) {
            GeneralPreferences.getPreferencesToolTips().putBoolean(this.id, false);
        }
        this.close();
    }

    public void setText(final String text) {
        if (this.headless) {
            return;
        }
        ThreadUtil.invokeLater(new Runnable(){

            @Override
            public void run() {
                ToolTipFrame.this.editorPane.setText(text);
                ToolTipFrame.this.pack();
            }
        });
    }

    @Override
    public void internalClose() {
        if (this.headless) {
            return;
        }
        if (this.timer != null) {
            this.timer.cancel();
        }
        super.internalClose();
    }
}

