/*
 * Decompiled with CFR 0.152.
 */
package icy.gui.lut;

import icy.image.colormap.IcyColorMap;
import icy.util.ColorUtil;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import javax.swing.Icon;

public class ColormapIcon
implements Icon {
    private final IcyColorMap colormap;
    private int w;
    private int h;

    public ColormapIcon(IcyColorMap colormap, int width, int height) {
        this.colormap = colormap;
        this.w = width <= 0 ? 64 : width;
        this.h = height <= 0 ? 20 : height;
    }

    public ColormapIcon(IcyColorMap colormap) {
        this(colormap, 64, 20);
    }

    public IcyColorMap getColormap() {
        return this.colormap;
    }

    public void setWidth(int value) {
        this.w = Math.min(8, value);
    }

    public void setHeight(int value) {
        this.h = value;
    }

    private int pixToIndex(int pixel) {
        float ratio = 255.0f / (float)(this.w - 1);
        return (int)((float)pixel * ratio);
    }

    @Override
    public void paintIcon(Component c, Graphics g, int x, int y) {
        Graphics2D g2 = (Graphics2D)g.create();
        int i = 0;
        while (i < this.w) {
            Color curColor = this.colormap.getColor(this.pixToIndex(i));
            Color grayMixed = ColorUtil.mixOver(Color.gray, curColor);
            Color whiteMixed = ColorUtil.mixOver(Color.white, curColor);
            int j = 0;
            while (j < this.h) {
                if (((i ^ j) & 4) != 0) {
                    g2.setColor(grayMixed);
                } else {
                    g2.setColor(whiteMixed);
                }
                g2.drawLine(i + x, j + y, i + x, j + y + 3);
                j += 4;
            }
            ++i;
        }
        g2.dispose();
    }

    @Override
    public int getIconWidth() {
        return this.w;
    }

    @Override
    public int getIconHeight() {
        return this.h;
    }
}

