/*
 * Decompiled with CFR 0.152.
 */
package icy.gui.lut;

import icy.gui.component.NumberTextField;
import icy.gui.dialog.ActionDialog;
import icy.gui.dialog.MessageDialog;
import icy.image.lut.LUT;
import icy.main.Icy;
import icy.sequence.Sequence;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JLabel;

public class ScalerBoundsSettingDialog
extends ActionDialog {
    final LUT.LUTChannel lutChannel;
    NumberTextField rangeMinField;
    NumberTextField rangeMaxField;
    NumberTextField lowBoundField;
    NumberTextField highBoundField;
    private JButton defaultBtn;
    private JLabel lblMinimum;
    private JLabel lblMaximum;

    public ScalerBoundsSettingDialog(LUT.LUTChannel lutChannel) {
        super("Histogram range");
        this.lutChannel = lutChannel;
        this.initialize();
        this.rangeMinField.setNumericValue(lutChannel.getMinBound());
        this.rangeMaxField.setNumericValue(lutChannel.getMaxBound());
        this.lowBoundField.setNumericValue(lutChannel.getMin());
        this.highBoundField.setNumericValue(lutChannel.getMax());
        this.defaultBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                int ch;
                LUT.LUTChannel lc = ScalerBoundsSettingDialog.this.lutChannel;
                Sequence sequence = Icy.getMainInterface().getActiveSequence();
                if (sequence != null && (ch = lc.getChannel()) < sequence.getSizeC()) {
                    ScalerBoundsSettingDialog.this.rangeMinField.setNumericValue(sequence.getChannelTypeMin(ch));
                    ScalerBoundsSettingDialog.this.rangeMaxField.setNumericValue(sequence.getChannelTypeMax(ch));
                    ScalerBoundsSettingDialog.this.lowBoundField.setNumericValue(sequence.getChannelMin(ch));
                    ScalerBoundsSettingDialog.this.highBoundField.setNumericValue(sequence.getChannelMax(ch));
                }
            }
        });
        this.setOkAction(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                double rangeMin = ScalerBoundsSettingDialog.this.rangeMinField.getNumericValue();
                double rangeMax = ScalerBoundsSettingDialog.this.rangeMaxField.getNumericValue();
                double lowBound = ScalerBoundsSettingDialog.this.lowBoundField.getNumericValue();
                double highBound = ScalerBoundsSettingDialog.this.highBoundField.getNumericValue();
                if (rangeMin >= rangeMax || lowBound >= highBound) {
                    MessageDialog.showDialog("Invalids settings", "The maximum range value should be above the minimum range value", 0);
                    return;
                }
                if (lowBound < rangeMin || highBound > rangeMax) {
                    MessageDialog.showDialog("Invalids settings", "The view range should be inside the full range", 0);
                    return;
                }
                LUT.LUTChannel lc = ScalerBoundsSettingDialog.this.lutChannel;
                lc.setMinBound(rangeMin);
                lc.setMaxBound(rangeMax);
                lc.setMin(lowBound);
                lc.setMax(highBound);
                ScalerBoundsSettingDialog.this.dispose();
            }
        });
        this.setCloseAfterAction(false);
    }

    private void initialize() {
        GridBagLayout gridBagLayout = new GridBagLayout();
        int[] nArray = new int[5];
        nArray[0] = 60;
        nArray[3] = 10;
        gridBagLayout.columnWidths = nArray;
        int[] nArray2 = new int[4];
        nArray2[1] = 23;
        gridBagLayout.rowHeights = nArray2;
        gridBagLayout.columnWeights = new double[]{0.0, 1.0, 1.0, 0.0, Double.MIN_VALUE};
        gridBagLayout.rowWeights = new double[]{0.0, 0.0, 0.0, Double.MIN_VALUE};
        this.mainPanel.setLayout(gridBagLayout);
        this.lblMinimum = new JLabel("Minimum");
        GridBagConstraints gbc_lblMinimum = new GridBagConstraints();
        gbc_lblMinimum.insets = new Insets(0, 0, 5, 5);
        gbc_lblMinimum.gridx = 1;
        gbc_lblMinimum.gridy = 0;
        this.mainPanel.add((Component)this.lblMinimum, gbc_lblMinimum);
        this.lblMaximum = new JLabel("Maximum");
        GridBagConstraints gbc_lblMaximum = new GridBagConstraints();
        gbc_lblMaximum.insets = new Insets(0, 0, 5, 5);
        gbc_lblMaximum.gridx = 2;
        gbc_lblMaximum.gridy = 0;
        this.mainPanel.add((Component)this.lblMaximum, gbc_lblMaximum);
        JLabel lblRangeMin = new JLabel("Full range");
        GridBagConstraints gbc_lblRangeMin = new GridBagConstraints();
        gbc_lblRangeMin.anchor = 13;
        gbc_lblRangeMin.insets = new Insets(0, 0, 5, 5);
        gbc_lblRangeMin.gridx = 0;
        gbc_lblRangeMin.gridy = 1;
        this.mainPanel.add((Component)lblRangeMin, gbc_lblRangeMin);
        this.rangeMinField = new NumberTextField();
        GridBagConstraints gbc_rangeMinField = new GridBagConstraints();
        gbc_rangeMinField.insets = new Insets(0, 0, 5, 5);
        gbc_rangeMinField.fill = 2;
        gbc_rangeMinField.gridx = 1;
        gbc_rangeMinField.gridy = 1;
        this.mainPanel.add((Component)this.rangeMinField, gbc_rangeMinField);
        this.rangeMinField.setColumns(10);
        this.rangeMaxField = new NumberTextField();
        GridBagConstraints gbc_rangeMaxField = new GridBagConstraints();
        gbc_rangeMaxField.insets = new Insets(0, 0, 5, 5);
        gbc_rangeMaxField.fill = 2;
        gbc_rangeMaxField.gridx = 2;
        gbc_rangeMaxField.gridy = 1;
        this.mainPanel.add((Component)this.rangeMaxField, gbc_rangeMaxField);
        this.rangeMaxField.setColumns(10);
        JLabel lblBoundMin = new JLabel("View range");
        GridBagConstraints gbc_lblBoundMin = new GridBagConstraints();
        gbc_lblBoundMin.anchor = 13;
        gbc_lblBoundMin.insets = new Insets(0, 0, 0, 5);
        gbc_lblBoundMin.gridx = 0;
        gbc_lblBoundMin.gridy = 2;
        this.mainPanel.add((Component)lblBoundMin, gbc_lblBoundMin);
        this.lowBoundField = new NumberTextField();
        GridBagConstraints gbc_lowBoundField = new GridBagConstraints();
        gbc_lowBoundField.insets = new Insets(0, 0, 0, 5);
        gbc_lowBoundField.fill = 2;
        gbc_lowBoundField.gridx = 1;
        gbc_lowBoundField.gridy = 2;
        this.mainPanel.add((Component)this.lowBoundField, gbc_lowBoundField);
        this.lowBoundField.setColumns(10);
        this.highBoundField = new NumberTextField();
        GridBagConstraints gbc_highBoundField = new GridBagConstraints();
        gbc_highBoundField.insets = new Insets(0, 0, 0, 5);
        gbc_highBoundField.fill = 2;
        gbc_highBoundField.gridx = 2;
        gbc_highBoundField.gridy = 2;
        this.mainPanel.add((Component)this.highBoundField, gbc_highBoundField);
        this.highBoundField.setColumns(10);
        this.defaultBtn = new JButton("Default");
        GridBagConstraints gbc_defaultBtn = new GridBagConstraints();
        gbc_defaultBtn.anchor = 13;
        gbc_defaultBtn.insets = new Insets(0, 0, 0, 5);
        gbc_defaultBtn.gridx = 1;
        gbc_defaultBtn.gridy = 0;
        this.buttonPanel.add((Component)this.defaultBtn, gbc_defaultBtn);
    }
}

