/*
 * Decompiled with CFR 0.152.
 */
package icy.gui.sequence.tools;

import icy.gui.dialog.ActionDialog;
import icy.gui.dialog.IdConfirmDialog;
import icy.gui.frame.progress.ProgressFrame;
import icy.gui.sequence.tools.SequenceDimensionConvertPanel;
import icy.gui.util.ComponentUtil;
import icy.sequence.Sequence;
import icy.sequence.SequenceUtil;
import icy.system.thread.ThreadUtil;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;

public class SequenceDimensionConvertFrame
extends ActionDialog {
    private static final long serialVersionUID = -6541431462734831647L;
    final SequenceDimensionConvertPanel convertPanel;

    public SequenceDimensionConvertFrame(Sequence sequence) {
        super("Z / T dimension conversion");
        this.convertPanel = new SequenceDimensionConvertPanel(sequence);
        this.convertPanel.setBorder(BorderFactory.createEmptyBorder(4, 4, 0, 4));
        this.mainPanel.add((Component)this.convertPanel, "Center");
        this.validate();
        this.setOkAction(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ThreadUtil.bgRun(new Runnable(){

                    @Override
                    public void run() {
                        ProgressFrame pf = new ProgressFrame("Converting Z / T dimension...");
                        Sequence sequence = (this).SequenceDimensionConvertFrame.this.convertPanel.getSequence();
                        boolean canUndo = sequence.createUndoDataPoint("Sequence dimension change");
                        if (!canUndo && !IdConfirmDialog.confirm("Not enough memory to undo the operation, do you want to continue ?", "ZTDimensionChangeNoUndoConfirm")) {
                            return;
                        }
                        SequenceUtil.adjustZT((this).SequenceDimensionConvertFrame.this.convertPanel.getSequence(), (this).SequenceDimensionConvertFrame.this.convertPanel.getNewSizeZ(), (this).SequenceDimensionConvertFrame.this.convertPanel.getNewSizeT(), (this).SequenceDimensionConvertFrame.this.convertPanel.isOrderReversed());
                        if (!canUndo) {
                            sequence.clearUndoManager();
                        }
                        pf.close();
                    }
                });
            }
        });
        this.setSize(340, 400);
        ComponentUtil.center(this);
        this.setVisible(true);
    }
}

