/*
 * Decompiled with CFR 0.152.
 */
package icy.gui.sequence.tools;

import icy.gui.dialog.ActionDialog;
import icy.gui.dialog.IdConfirmDialog;
import icy.gui.frame.progress.ProgressFrame;
import icy.gui.sequence.tools.SequenceDimensionExtendPanel;
import icy.gui.util.ComponentUtil;
import icy.image.IcyBufferedImage;
import icy.sequence.AbstractSequenceModel;
import icy.sequence.DimensionId;
import icy.sequence.Sequence;
import icy.sequence.SequenceUtil;
import icy.system.thread.ThreadUtil;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.image.BufferedImage;
import javax.swing.BorderFactory;

public class SequenceDimensionExtendFrame
extends ActionDialog {
    private static final long serialVersionUID = -1999644069532236365L;
    final SequenceDimensionExtendPanel extendPanel;
    final Sequence sequence;

    public SequenceDimensionExtendFrame(Sequence sequence, DimensionId dim) {
        super(String.valueOf(dim.toString()) + " Dimension extend");
        this.sequence = sequence;
        this.extendPanel = new SequenceDimensionExtendPanel(dim);
        this.extendPanel.setBorder(BorderFactory.createEmptyBorder(4, 4, 0, 4));
        int size = sequence.getSize(dim);
        this.extendPanel.setNewSize(size);
        this.extendPanel.setInsertPosition(size);
        this.extendPanel.setMaxDuplicate(size);
        this.mainPanel.add((Component)this.extendPanel, "Center");
        this.validate();
        this.extendPanel.setModel(new SequenceDimensionExtendFrameModel());
        this.setOkAction(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ThreadUtil.bgRun(new Runnable(){

                    @Override
                    public void run() {
                        Sequence sequence = (this).SequenceDimensionExtendFrame.this.sequence;
                        ProgressFrame pf = new ProgressFrame("Extending sequence...");
                        boolean canUndo = sequence.createUndoDataPoint("Dimension " + SequenceDimensionExtendFrame.this.getDimensionId().toString() + " extended");
                        if (!canUndo && !IdConfirmDialog.confirm("Not enough memory to undo the operation, do you want to continue ?", "AddZTNoUndoConfirm")) {
                            return;
                        }
                        switch (SequenceDimensionExtendFrame.this.getDimensionId()) {
                            default: {
                                SequenceUtil.addZ(sequence, (this).SequenceDimensionExtendFrame.this.extendPanel.getInsertPosition(), (this).SequenceDimensionExtendFrame.this.extendPanel.getNewSize() - sequence.getSizeZ(), (this).SequenceDimensionExtendFrame.this.extendPanel.getDuplicateNumber());
                                break;
                            }
                            case T: {
                                SequenceUtil.addT(sequence, (this).SequenceDimensionExtendFrame.this.extendPanel.getInsertPosition(), (this).SequenceDimensionExtendFrame.this.extendPanel.getNewSize() - sequence.getSizeT(), (this).SequenceDimensionExtendFrame.this.extendPanel.getDuplicateNumber());
                            }
                        }
                        if (!canUndo) {
                            sequence.clearUndoManager();
                        }
                        pf.close();
                    }
                });
            }
        });
        this.setSize(340, 400);
        ComponentUtil.center(this);
        this.setVisible(true);
    }

    DimensionId getDimensionId() {
        return this.extendPanel.getDimensionId();
    }

    private class SequenceDimensionExtendFrameModel
    extends AbstractSequenceModel {
        @Override
        public int getSizeX() {
            return SequenceDimensionExtendFrame.this.sequence.getSizeX();
        }

        @Override
        public int getSizeY() {
            return SequenceDimensionExtendFrame.this.sequence.getSizeX();
        }

        @Override
        public int getSizeZ() {
            if (SequenceDimensionExtendFrame.this.getDimensionId() == DimensionId.Z) {
                return SequenceDimensionExtendFrame.this.extendPanel.getNewSize();
            }
            return SequenceDimensionExtendFrame.this.sequence.getSizeZ();
        }

        @Override
        public int getSizeT() {
            if (SequenceDimensionExtendFrame.this.getDimensionId() == DimensionId.T) {
                return SequenceDimensionExtendFrame.this.extendPanel.getNewSize();
            }
            return SequenceDimensionExtendFrame.this.sequence.getSizeT();
        }

        @Override
        public int getSizeC() {
            if (SequenceDimensionExtendFrame.this.getDimensionId() == DimensionId.C) {
                return SequenceDimensionExtendFrame.this.extendPanel.getNewSize();
            }
            return SequenceDimensionExtendFrame.this.sequence.getSizeC();
        }

        @Override
        public BufferedImage getImage(int t, int z) {
            switch (SequenceDimensionExtendFrame.this.getDimensionId()) {
                default: {
                    return SequenceUtil.AddZHelper.getExtendedImage(SequenceDimensionExtendFrame.this.sequence, t, z, SequenceDimensionExtendFrame.this.extendPanel.getInsertPosition(), SequenceDimensionExtendFrame.this.extendPanel.getNewSize() - SequenceDimensionExtendFrame.this.sequence.getSizeZ(), SequenceDimensionExtendFrame.this.extendPanel.getDuplicateNumber());
                }
                case T: 
            }
            return SequenceUtil.AddTHelper.getExtendedImage(SequenceDimensionExtendFrame.this.sequence, t, z, SequenceDimensionExtendFrame.this.extendPanel.getInsertPosition(), SequenceDimensionExtendFrame.this.extendPanel.getNewSize() - SequenceDimensionExtendFrame.this.sequence.getSizeT(), SequenceDimensionExtendFrame.this.extendPanel.getDuplicateNumber());
        }

        @Override
        public BufferedImage getImage(int t, int z, int c) {
            IcyBufferedImage img = (IcyBufferedImage)this.getImage(t, z);
            if (img != null) {
                return img.getImage(c);
            }
            return null;
        }
    }
}

