/*
 * Decompiled with CFR 0.152.
 */
package icy.roi;

import icy.roi.BooleanMask2DIterator;
import icy.roi.ROI;
import icy.type.Position5DIterator;
import icy.type.point.Point5D;
import icy.type.rectangle.Rectangle5D;
import java.util.NoSuchElementException;

public class ROIIterator
implements Position5DIterator {
    protected final ROI roi;
    protected final Rectangle5D.Integer bounds;
    protected final boolean inclusive;
    protected int c;
    protected int z;
    protected int t;
    protected boolean done;
    protected BooleanMask2DIterator maskIterator;

    public ROIIterator(ROI roi, Rectangle5D region, boolean inclusive) {
        this.roi = roi;
        this.bounds = region != null ? region.createIntersection(roi.getBounds5D()).toInteger() : roi.getBounds5D().toInteger();
        this.inclusive = inclusive;
        if (this.bounds.isInfiniteZ()) {
            this.bounds.z = -1;
            this.bounds.sizeZ = 1;
        }
        if (this.bounds.isInfiniteT()) {
            this.bounds.t = -1;
            this.bounds.sizeT = 1;
        }
        if (this.bounds.isInfiniteC()) {
            this.bounds.c = -1;
            this.bounds.sizeC = 1;
        }
        this.reset();
    }

    public ROIIterator(ROI roi, boolean inclusive) {
        this(roi, null, inclusive);
    }

    public int getMinZ() {
        return this.bounds.z;
    }

    public int getMaxZ() {
        return this.bounds.z + this.bounds.sizeZ - 1;
    }

    public int getMinT() {
        return this.bounds.t;
    }

    public int getMaxT() {
        return this.bounds.t + this.bounds.sizeT - 1;
    }

    public int getMinC() {
        return this.bounds.c;
    }

    public int getMaxC() {
        return this.bounds.c + this.bounds.sizeC - 1;
    }

    @Override
    public void reset() {
        this.done = this.bounds.isEmpty();
        if (!this.done) {
            this.z = this.getMinZ();
            this.t = this.getMinT();
            this.c = this.getMinC();
            this.prepareXY();
            this.nextXYIfNeeded();
        }
    }

    protected void prepareXY() {
        this.maskIterator = new BooleanMask2DIterator(this.roi.getBooleanMask2D(this.z, this.t, this.c, this.inclusive));
    }

    @Override
    public void next() {
        if (this.done) {
            throw new NoSuchElementException();
        }
        this.maskIterator.next();
        this.nextXYIfNeeded();
    }

    protected void nextXYIfNeeded() {
        while (this.maskIterator.done() && !this.done) {
            if (++this.c > this.getMaxC()) {
                this.c = this.getMinC();
                if (++this.z > this.getMaxZ()) {
                    this.z = this.getMinZ();
                    if (++this.t > this.getMaxT()) {
                        this.done = true;
                        return;
                    }
                }
            }
            this.prepareXY();
        }
    }

    @Override
    public boolean done() {
        return this.done;
    }

    @Override
    public Point5D get() {
        if (this.done) {
            throw new NoSuchElementException();
        }
        return new Point5D.Integer(this.maskIterator.getX(), this.maskIterator.getY(), this.z, this.t, this.c);
    }

    @Override
    public int getX() {
        if (this.done) {
            throw new NoSuchElementException();
        }
        return this.maskIterator.getX();
    }

    @Override
    public int getY() {
        if (this.done) {
            throw new NoSuchElementException();
        }
        return this.maskIterator.getY();
    }

    @Override
    public int getC() {
        if (this.done) {
            throw new NoSuchElementException();
        }
        return this.c;
    }

    @Override
    public int getZ() {
        if (this.done) {
            throw new NoSuchElementException();
        }
        return this.z;
    }

    @Override
    public int getT() {
        if (this.done) {
            throw new NoSuchElementException();
        }
        return this.t;
    }
}

