/*
 * Decompiled with CFR 0.152.
 */
package loci.poi.util;

import java.util.HashMap;
import java.util.Map;
import loci.poi.util.NullLogger;
import loci.poi.util.POILogger;

public class POILogFactory {
    private static Map _loggers = new HashMap();

    private POILogFactory() {
    }

    public static POILogger getLogger(Class theclass) {
        return POILogFactory.getLogger(theclass.getName());
    }

    public static POILogger getLogger(String cat) {
        POILogger logger = null;
        if (_loggers.containsKey(cat)) {
            logger = (POILogger)_loggers.get(cat);
        } else {
            try {
                String loggerClassName = System.getProperty("loci.poi.util.POILogger");
                Class<?> loggerClass = Class.forName(loggerClassName);
                logger = (POILogger)loggerClass.newInstance();
            }
            catch (Exception e) {
                logger = new NullLogger();
            }
            logger.initialize(cat);
            _loggers.put(cat, logger);
        }
        return logger;
    }
}

