/*
 * Decompiled with CFR 0.152.
 */
package ucar.ma2;

import ucar.ma2.Array;
import ucar.ma2.ArrayChar;
import ucar.ma2.ArrayObject;
import ucar.ma2.ArrayStructure;
import ucar.ma2.ArrayStructureW;
import ucar.ma2.DataType;
import ucar.ma2.StructureData;
import ucar.ma2.StructureDataA;
import ucar.ma2.StructureMembers;

public class ArraySequenceNested
extends ArrayStructure {
    private int[] sequenceLen;
    private int[] sequenceOffset;
    private int total = 0;

    public ArraySequenceNested(StructureMembers members, int nseq) {
        super(members, new int[]{nseq});
        this.sequenceLen = new int[nseq];
    }

    @Override
    protected StructureData makeStructureData(ArrayStructure as, int index) {
        return new StructureDataA(as, index);
    }

    @Override
    public StructureData getStructureData(int index) {
        return new StructureDataA(this, index);
    }

    public void setSequenceLength(int outerIndex, int len) {
        this.sequenceLen[outerIndex] = len;
    }

    public int getSequenceLength(int outerIndex) {
        return this.sequenceLen[outerIndex];
    }

    public int getSequenceOffset(int outerIndex) {
        return this.sequenceOffset[outerIndex];
    }

    public void finish() {
        int i;
        this.sequenceOffset = new int[this.nelems];
        this.total = 0;
        for (i = 0; i < this.nelems; ++i) {
            this.sequenceOffset[i] = this.total;
            this.total += this.sequenceLen[i];
        }
        this.sdata = new StructureData[this.nelems];
        for (i = 0; i < this.nelems; ++i) {
            this.sdata[i] = new StructureDataA(this, this.sequenceOffset[i]);
        }
        for (StructureMembers.Member m3 : this.members.getMembers()) {
            int[] mShape = m3.getShape();
            int[] shape = new int[mShape.length + 1];
            shape[0] = this.total;
            System.arraycopy(mShape, 0, shape, 1, mShape.length);
            Array data = Array.factory(m3.getDataType(), shape);
            m3.setDataArray(data);
        }
    }

    public int getTotalNumberOfStructures() {
        return this.total;
    }

    public ArrayStructure flatten() {
        ArrayStructureW aw = new ArrayStructureW(this.getStructureMembers(), new int[]{this.total});
        for (int i = 0; i < this.total; ++i) {
            StructureDataA sdata = new StructureDataA(this, i);
            aw.setStructureData(sdata, i);
        }
        return aw;
    }

    @Override
    public double getScalarDouble(int recnum, StructureMembers.Member m3) {
        if (m3.getDataType() != DataType.DOUBLE) {
            throw new IllegalArgumentException("Type is " + (Object)((Object)m3.getDataType()) + ", must be double");
        }
        Array data = m3.getDataArray();
        return data.getDouble(recnum * m3.getSize());
    }

    @Override
    public double[] getJavaArrayDouble(int recnum, StructureMembers.Member m3) {
        if (m3.getDataType() != DataType.DOUBLE) {
            throw new IllegalArgumentException("Type is " + (Object)((Object)m3.getDataType()) + ", must be double");
        }
        int count = m3.getSize();
        Array data = m3.getDataArray();
        double[] pa = new double[count];
        for (int i = 0; i < count; ++i) {
            pa[i] = data.getDouble(recnum * count + i);
        }
        return pa;
    }

    @Override
    public float getScalarFloat(int recnum, StructureMembers.Member m3) {
        if (m3.getDataType() != DataType.FLOAT) {
            throw new IllegalArgumentException("Type is " + (Object)((Object)m3.getDataType()) + ", must be float");
        }
        Array data = m3.getDataArray();
        return data.getFloat(recnum * m3.getSize());
    }

    @Override
    public float[] getJavaArrayFloat(int recnum, StructureMembers.Member m3) {
        if (m3.getDataType() != DataType.FLOAT) {
            throw new IllegalArgumentException("Type is " + (Object)((Object)m3.getDataType()) + ", must be float");
        }
        int count = m3.getSize();
        Array data = m3.getDataArray();
        float[] pa = new float[count];
        for (int i = 0; i < count; ++i) {
            pa[i] = data.getFloat(recnum * count + i);
        }
        return pa;
    }

    @Override
    public byte getScalarByte(int recnum, StructureMembers.Member m3) {
        if (m3.getDataType() != DataType.BYTE && m3.getDataType() != DataType.ENUM1) {
            throw new IllegalArgumentException("Type is " + (Object)((Object)m3.getDataType()) + ", must be byte");
        }
        Array data = m3.getDataArray();
        return data.getByte(recnum * m3.getSize());
    }

    @Override
    public byte[] getJavaArrayByte(int recnum, StructureMembers.Member m3) {
        if (m3.getDataType() != DataType.BYTE && m3.getDataType() != DataType.ENUM1) {
            throw new IllegalArgumentException("Type is " + (Object)((Object)m3.getDataType()) + ", must be byte");
        }
        int count = m3.getSize();
        Array data = m3.getDataArray();
        byte[] pa = new byte[count];
        for (int i = 0; i < count; ++i) {
            pa[i] = data.getByte(recnum * count + i);
        }
        return pa;
    }

    @Override
    public short getScalarShort(int recnum, StructureMembers.Member m3) {
        if (m3.getDataType() != DataType.SHORT && m3.getDataType() != DataType.ENUM2) {
            throw new IllegalArgumentException("Type is " + (Object)((Object)m3.getDataType()) + ", must be short");
        }
        Array data = m3.getDataArray();
        return data.getShort(recnum * m3.getSize());
    }

    @Override
    public short[] getJavaArrayShort(int recnum, StructureMembers.Member m3) {
        if (m3.getDataType() != DataType.SHORT && m3.getDataType() != DataType.ENUM2) {
            throw new IllegalArgumentException("Type is " + (Object)((Object)m3.getDataType()) + ", must be short");
        }
        int count = m3.getSize();
        Array data = m3.getDataArray();
        short[] pa = new short[count];
        for (int i = 0; i < count; ++i) {
            pa[i] = data.getShort(recnum * count + i);
        }
        return pa;
    }

    @Override
    public int getScalarInt(int recnum, StructureMembers.Member m3) {
        if (m3.getDataType() != DataType.INT && m3.getDataType() != DataType.ENUM4) {
            throw new IllegalArgumentException("Type is " + (Object)((Object)m3.getDataType()) + ", must be int");
        }
        Array data = m3.getDataArray();
        return data.getInt(recnum * m3.getSize());
    }

    @Override
    public int[] getJavaArrayInt(int recnum, StructureMembers.Member m3) {
        if (m3.getDataType() != DataType.INT && m3.getDataType() != DataType.ENUM4) {
            throw new IllegalArgumentException("Type is " + (Object)((Object)m3.getDataType()) + ", must be int");
        }
        int count = m3.getSize();
        Array data = m3.getDataArray();
        int[] pa = new int[count];
        for (int i = 0; i < count; ++i) {
            pa[i] = data.getInt(recnum * count + i);
        }
        return pa;
    }

    @Override
    public long getScalarLong(int recnum, StructureMembers.Member m3) {
        if (m3.getDataType() != DataType.LONG) {
            throw new IllegalArgumentException("Type is " + (Object)((Object)m3.getDataType()) + ", must be long");
        }
        Array data = m3.getDataArray();
        return data.getLong(recnum * m3.getSize());
    }

    @Override
    public long[] getJavaArrayLong(int recnum, StructureMembers.Member m3) {
        if (m3.getDataType() != DataType.LONG) {
            throw new IllegalArgumentException("Type is " + (Object)((Object)m3.getDataType()) + ", must be long");
        }
        int count = m3.getSize();
        Array data = m3.getDataArray();
        long[] pa = new long[count];
        for (int i = 0; i < count; ++i) {
            pa[i] = data.getLong(recnum * count + i);
        }
        return pa;
    }

    @Override
    public char getScalarChar(int recnum, StructureMembers.Member m3) {
        if (m3.getDataType() != DataType.CHAR) {
            throw new IllegalArgumentException("Type is " + (Object)((Object)m3.getDataType()) + ", must be char");
        }
        Array data = m3.getDataArray();
        return data.getChar(recnum * m3.getSize());
    }

    @Override
    public char[] getJavaArrayChar(int recnum, StructureMembers.Member m3) {
        if (m3.getDataType() != DataType.CHAR) {
            throw new IllegalArgumentException("Type is " + (Object)((Object)m3.getDataType()) + ", must be char");
        }
        int count = m3.getSize();
        Array data = m3.getDataArray();
        char[] pa = new char[count];
        for (int i = 0; i < count; ++i) {
            pa[i] = data.getChar(recnum * count + i);
        }
        return pa;
    }

    @Override
    public String getScalarString(int recnum, StructureMembers.Member m3) {
        if (m3.getDataType() == DataType.CHAR) {
            ArrayChar data = (ArrayChar)m3.getDataArray();
            return data.getString(recnum);
        }
        if (m3.getDataType() == DataType.STRING) {
            ArrayObject data = (ArrayObject)m3.getDataArray();
            return (String)data.getObject(recnum);
        }
        throw new IllegalArgumentException("Type is " + (Object)((Object)m3.getDataType()) + ", must be String or char");
    }

    @Override
    public String[] getJavaArrayString(int recnum, StructureMembers.Member m3) {
        int n = m3.getSize();
        String[] result = new String[n];
        if (m3.getDataType() == DataType.CHAR) {
            ArrayChar data = (ArrayChar)m3.getDataArray();
            for (int i = 0; i < n; ++i) {
                result[i] = data.getString(recnum * n + i);
            }
            return result;
        }
        if (m3.getDataType() == DataType.STRING) {
            Array data = m3.getDataArray();
            for (int i = 0; i < n; ++i) {
                result[i] = (String)data.getObject(recnum * n + i);
            }
            return result;
        }
        throw new IllegalArgumentException("Type is " + (Object)((Object)m3.getDataType()) + ", must be String or char");
    }

    @Override
    public StructureData getScalarStructure(int recnum, StructureMembers.Member m3) {
        if (m3.getDataType() == DataType.STRUCTURE) {
            ArrayStructure data = (ArrayStructure)m3.getDataArray();
            return data.getStructureData(recnum * m3.getSize());
        }
        throw new IllegalArgumentException("Type is " + (Object)((Object)m3.getDataType()) + ", must be Structure");
    }

    @Override
    public ArrayStructure getArrayStructure(int recnum, StructureMembers.Member m3) {
        if (m3.getDataType() == DataType.STRUCTURE) {
            ArrayStructure data = (ArrayStructure)m3.getDataArray();
            int count = m3.getSize();
            StructureData[] sdata = new StructureData[count];
            for (int i = 0; i < count; ++i) {
                sdata[i] = data.getStructureData(recnum * count + i);
            }
            return new ArrayStructureW(data.getStructureMembers(), m3.getShape(), sdata);
        }
        throw new IllegalArgumentException("Type is " + (Object)((Object)m3.getDataType()) + ", must be Structure");
    }
}

