/*
 * Decompiled with CFR 0.152.
 */
package plugins.ylemontag.mathoperations;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import plugins.adufour.vars.gui.VarEditor;
import plugins.adufour.vars.gui.swing.SwingVarEditor;
import plugins.adufour.vars.lang.Var;
import plugins.ylemontag.mathoperations.Operation;
import plugins.ylemontag.mathoperations.operations.Operation1;
import plugins.ylemontag.mathoperations.operations.Operation2;

public class VarOperation
extends Var<Operation> {
    public VarOperation(String name, Operation defaultValue) {
        super(name, Operation.class, (Object)defaultValue);
    }

    public VarEditor<Operation> createVarEditor() {
        return new Editor(this);
    }

    public String getValueAsString() {
        Operation op = (Operation)this.getValue();
        if (op != null) {
            if (op instanceof Operation1) {
                return ((Operation1)op).name();
            }
            if (op instanceof Operation2) {
                return ((Operation2)op).name();
            }
        }
        return "null";
    }

    public Operation parse(String s) {
        try {
            return Enum.valueOf(Operation1.class, s);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            try {
                return Enum.valueOf(Operation2.class, s);
            }
            catch (IllegalArgumentException illegalArgumentException2) {
                return null;
            }
        }
    }

    private static class Editor
    extends SwingVarEditor<Operation> {
        private JComboBox _component;
        private DefaultComboBoxModel _model;
        private boolean _shuntListeners = false;

        public Editor(Var<Operation> variable) {
            super(variable);
        }

        private void feedModel() {
            for (Operation2 operation2 : Operation2.values()) {
                this._model.addElement(operation2);
            }
            for (Enum enum_ : Operation1.values()) {
                this._model.addElement(enum_);
            }
        }

        protected JComponent createEditorComponent() {
            this._model = new DefaultComboBoxModel();
            this._component = new JComboBox();
            this._component.setModel(this._model);
            this.feedModel();
            this._component.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    if (_shuntListeners) {
                        return;
                    }
                    variable.setValue((Object)((Operation)_component.getSelectedItem()));
                }
            });
            return this._component;
        }

        protected void activateListeners() {
            this._shuntListeners = false;
        }

        protected void deactivateListeners() {
            this._shuntListeners = true;
        }

        protected void updateInterfaceValue() {
            Operation currentValue = (Operation)this.variable.getValue();
            if (currentValue != null) {
                this._component.setSelectedItem(currentValue);
            }
        }
    }
}

