/*
 * Decompiled with CFR 0.152.
 */
package plugins.ylemontag.mathoperations.functors;

import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.util.LinkedList;
import java.util.List;
import plugins.ylemontag.mathoperations.Variant;

public class AutoGenerateApplyMethods {
    private static int methodCounter = 0;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) {
        int N = 1;
        boolean inOperation = false;
        String fileName = "out.txt";
        String tplApply1 = "/**\n * Specialized evaluation function\n * @see Functor%1$s.apply(%2$s)\n */\npublic %3$s apply(%4$s)\n{\n" + (inOperation ? "\treturn _functor.apply(%7$s);\n" : "\treturn apply(%5$s).%6$s;\n") + "}\n";
        LinkedList<MethodType> methods1 = AutoGenerateApplyMethods.makeCombinations(N, true);
        String tplApply2 = "/**\n * Specialized evaluation function\n * @see Functor%1$s.apply(Variant out, %2$s)\n */\npublic void apply(%3$s out, %4$s)\n{\n" + (inOperation ? "\t_functor.apply(out, %7$s);\n" : "\tapply(Variant.wrap(out), %5$s);\n") + "}\n";
        LinkedList<MethodType> methods2 = AutoGenerateApplyMethods.makeCombinations(N, false);
        String tplApply3 = "/**\n * Specialized evaluation function\n * @see Functor%1$s.apply(%2$s, Controller controller)\n */\npublic %3$s apply(%4$s, Controller controller)\n\tthrows Controller.CanceledByUser\n{\n" + (inOperation ? "\treturn _functor.apply(%7$s, controller);\n" : "\treturn apply(%5$s, controller).%6$s;\n") + "}\n";
        LinkedList<MethodType> methods3 = AutoGenerateApplyMethods.makeCombinations(N, false);
        String tplApply4 = "/**\n * Specialized evaluation function\n * @see Functor%1$s.apply(Variant out, %2$s, Controller controller)\n */\npublic void apply(%3$s out, %4$s, Controller controller)\n\tthrows Controller.CanceledByUser\n{\n" + (inOperation ? "\t_functor.apply(out, %7$s, controller);\n" : "\tapply(Variant.wrap(out), %5$s, controller);\n") + "}\n";
        LinkedList<MethodType> methods4 = AutoGenerateApplyMethods.makeCombinations(N, false);
        try {
            try (FileWriter stream = new FileWriter(fileName);){
                methodCounter = 0;
                AutoGenerateApplyMethods.printMethodFamily(stream, tplApply1, methods1);
                AutoGenerateApplyMethods.printMethodFamily(stream, tplApply2, methods2);
                AutoGenerateApplyMethods.printMethodFamily(stream, tplApply3, methods3);
                AutoGenerateApplyMethods.printMethodFamily(stream, tplApply4, methods4);
            }
            System.out.println("Done.");
            System.out.println("Method count: " + methodCounter);
        }
        catch (IOException err) {
            System.err.println("I/O error: " + err.getMessage());
        }
    }

    private static String code1(MethodType method) {
        return Integer.toString(method.input.length);
    }

    private static String code2(MethodType method) {
        String retVal = "";
        for (int k = 1; k <= method.input.length; ++k) {
            if (k >= 2) {
                retVal = retVal + ", ";
            }
            retVal = retVal + "Variant in" + k;
        }
        return retVal;
    }

    private static String code3(MethodType method) {
        return AutoGenerateApplyMethods.toJavaType(method.output);
    }

    private static String code4(MethodType method) {
        String retVal = "";
        for (int k = 1; k <= method.input.length; ++k) {
            if (k >= 2) {
                retVal = retVal + ", ";
            }
            retVal = retVal + AutoGenerateApplyMethods.toJavaType(method.input[k - 1]) + " in" + k;
        }
        return retVal;
    }

    private static String code5(MethodType method) {
        String retVal = "";
        for (int k = 1; k <= method.input.length; ++k) {
            if (k >= 2) {
                retVal = retVal + ", ";
            }
            retVal = retVal + "Variant.wrap(in" + k + ")";
        }
        return retVal;
    }

    private static String code6(MethodType method) {
        return AutoGenerateApplyMethods.toGetAsMethod(method.output);
    }

    private static String code7(MethodType method) {
        String retVal = "";
        for (int k = 1; k <= method.input.length; ++k) {
            if (k >= 2) {
                retVal = retVal + ", ";
            }
            retVal = retVal + "in" + k;
        }
        return retVal;
    }

    private static String toJavaType(Variant.Type type) {
        switch (type) {
            case SCALAR: {
                return "double";
            }
            case ARRAY: {
                return "double[]";
            }
            case SEQUENCE: {
                return "Sequence";
            }
            case SUBSEQUENCE: {
                return "SubSequence";
            }
        }
        throw new RuntimeException("Unreachable code point");
    }

    private static String toGetAsMethod(Variant.Type type) {
        switch (type) {
            case SCALAR: {
                return "getAsScalar()";
            }
            case ARRAY: {
                return "getAsArray()";
            }
            case SEQUENCE: {
                return "getAsSequence()";
            }
            case SUBSEQUENCE: {
                throw new IllegalArgumentException("No getAs-method for sub-sequences.");
            }
        }
        throw new RuntimeException("Unreachable code point");
    }

    private static void printMethodFamily(Writer stream, String template, List<MethodType> methods) throws IOException {
        for (MethodType method : methods) {
            String fullCode = String.format(template, AutoGenerateApplyMethods.code1(method), AutoGenerateApplyMethods.code2(method), AutoGenerateApplyMethods.code3(method), AutoGenerateApplyMethods.code4(method), AutoGenerateApplyMethods.code5(method), AutoGenerateApplyMethods.code6(method), AutoGenerateApplyMethods.code7(method));
            stream.write("\n" + fullCode);
            ++methodCounter;
        }
    }

    private static LinkedList<MethodType> makeCombinations(int n, boolean withOutputScalar) {
        LinkedList<MethodType> retVal = new LinkedList<MethodType>();
        if (withOutputScalar) {
            LinkedList<MethodType> outputScalar = AutoGenerateApplyMethods.makeCombinations(Variant.Type.SCALAR, n, Variant.Type.SCALAR);
            retVal.addAll(outputScalar);
        }
        LinkedList<MethodType> outputArray = AutoGenerateApplyMethods.makeCombinations(Variant.Type.ARRAY, n, Variant.Type.SCALAR, Variant.Type.ARRAY);
        outputArray.removeFirst();
        retVal.addAll(outputArray);
        LinkedList<MethodType> outputSeq = AutoGenerateApplyMethods.makeCombinations(Variant.Type.SEQUENCE, n, Variant.Type.SCALAR, Variant.Type.SEQUENCE, Variant.Type.SUBSEQUENCE);
        outputSeq.removeFirst();
        retVal.addAll(outputSeq);
        return retVal;
    }

    private static LinkedList<MethodType> makeCombinations(Variant.Type out, int n, Variant.Type ... in) {
        LinkedList<MethodType> retVal = new LinkedList<MethodType>();
        Variant.Type[] buffer = new Variant.Type[n];
        AutoGenerateApplyMethods.auxMakeCombinations(retVal, out, buffer, 0, in);
        return retVal;
    }

    private static void auxMakeCombinations(LinkedList<MethodType> retVal, Variant.Type out, Variant.Type[] buffer, int k, Variant.Type[] in) {
        if (k >= buffer.length) {
            retVal.addLast(new MethodType(out, buffer));
        } else {
            Variant.Type[] typeArray = in;
            int n = typeArray.length;
            for (int i = 0; i < n; ++i) {
                Variant.Type t;
                buffer[k] = t = typeArray[i];
                AutoGenerateApplyMethods.auxMakeCombinations(retVal, out, buffer, k + 1, in);
            }
        }
    }

    private static class MethodType {
        public Variant.Type output;
        public Variant.Type[] input;

        public MethodType(Variant.Type out, Variant.Type[] in) {
            this.output = out;
            this.input = new Variant.Type[in.length];
            for (int k = 0; k < in.length; ++k) {
                this.input[k] = in[k];
            }
        }
    }
}

