/*
 * Decompiled with CFR 0.152.
 */
package plugins.ylemontag.mathoperations.operations;

import icy.sequence.Sequence;
import plugins.ylemontag.mathoperations.Controller;
import plugins.ylemontag.mathoperations.Functor;
import plugins.ylemontag.mathoperations.Operation;
import plugins.ylemontag.mathoperations.SubSequence;
import plugins.ylemontag.mathoperations.functors.Functor2;

public enum Operation2 implements Operation
{
    ADD("Add", "%s + %s", new Functor.FunPtr(){

        @Override
        public double apply(double[] in) {
            return in[0] + in[1];
        }
    }),
    SUBTRACT("Subtract", "%s - %s", new Functor.FunPtr(){

        @Override
        public double apply(double[] in) {
            return in[0] - in[1];
        }
    }),
    MULTIPLY("Multiply", "%s\u00d7%s", new Functor.FunPtr(){

        @Override
        public double apply(double[] in) {
            return in[0] * in[1];
        }
    }),
    DIVIDE("Divide", "%s\u00f7%s", new Functor.FunPtr(){

        @Override
        public double apply(double[] in) {
            return in[0] / in[1];
        }
    }),
    POWER("Power", "%s^%s", new Functor.FunPtr(){

        @Override
        public double apply(double[] in) {
            return Math.pow(in[0], in[1]);
        }
    }),
    MAX("Max", "max(%s,%s)", new Functor.FunPtr(){

        @Override
        public double apply(double[] in) {
            return Math.max(in[0], in[1]);
        }
    }),
    MIN("Min", "min(%s,%s)", new Functor.FunPtr(){

        @Override
        public double apply(double[] in) {
            return Math.min(in[0], in[1]);
        }
    });

    private String _functionName;
    private Functor2 _functor;

    private Operation2(String functionName, String describePattern, Functor.FunPtr functionPointer) {
        this._functionName = functionName;
        this._functor = new Functor2(describePattern, functionPointer);
    }

    public String toString() {
        return this._functionName;
    }

    @Override
    public String getFunctionName() {
        return this._functionName;
    }

    @Override
    public Functor getRawFunctor() {
        return this._functor;
    }

    public Functor2 getFunctor() {
        return this._functor;
    }

    public String describeOperation(String in1, String in2) {
        return this._functor.describeOperation(in1, in2);
    }

    public double apply(double in1, double in2) {
        return this._functor.apply(in1, in2);
    }

    public double[] apply(double in1, double[] in2) {
        return this._functor.apply(in1, in2);
    }

    public double[] apply(double[] in1, double in2) {
        return this._functor.apply(in1, in2);
    }

    public double[] apply(double[] in1, double[] in2) {
        return this._functor.apply(in1, in2);
    }

    public Sequence apply(double in1, Sequence in2) {
        return this._functor.apply(in1, in2);
    }

    public Sequence apply(double in1, SubSequence in2) {
        return this._functor.apply(in1, in2);
    }

    public Sequence apply(Sequence in1, double in2) {
        return this._functor.apply(in1, in2);
    }

    public Sequence apply(Sequence in1, Sequence in2) {
        return this._functor.apply(in1, in2);
    }

    public Sequence apply(Sequence in1, SubSequence in2) {
        return this._functor.apply(in1, in2);
    }

    public Sequence apply(SubSequence in1, double in2) {
        return this._functor.apply(in1, in2);
    }

    public Sequence apply(SubSequence in1, Sequence in2) {
        return this._functor.apply(in1, in2);
    }

    public Sequence apply(SubSequence in1, SubSequence in2) {
        return this._functor.apply(in1, in2);
    }

    public void apply(double[] out, double in1, double[] in2) {
        this._functor.apply(out, in1, in2);
    }

    public void apply(double[] out, double[] in1, double in2) {
        this._functor.apply(out, in1, in2);
    }

    public void apply(double[] out, double[] in1, double[] in2) {
        this._functor.apply(out, in1, in2);
    }

    public void apply(Sequence out, double in1, Sequence in2) {
        this._functor.apply(out, in1, in2);
    }

    public void apply(Sequence out, double in1, SubSequence in2) {
        this._functor.apply(out, in1, in2);
    }

    public void apply(Sequence out, Sequence in1, double in2) {
        this._functor.apply(out, in1, in2);
    }

    public void apply(Sequence out, Sequence in1, Sequence in2) {
        this._functor.apply(out, in1, in2);
    }

    public void apply(Sequence out, Sequence in1, SubSequence in2) {
        this._functor.apply(out, in1, in2);
    }

    public void apply(Sequence out, SubSequence in1, double in2) {
        this._functor.apply(out, in1, in2);
    }

    public void apply(Sequence out, SubSequence in1, Sequence in2) {
        this._functor.apply(out, in1, in2);
    }

    public void apply(Sequence out, SubSequence in1, SubSequence in2) {
        this._functor.apply(out, in1, in2);
    }

    public double[] apply(double in1, double[] in2, Controller controller) throws Controller.CanceledByUser {
        return this._functor.apply(in1, in2, controller);
    }

    public double[] apply(double[] in1, double in2, Controller controller) throws Controller.CanceledByUser {
        return this._functor.apply(in1, in2, controller);
    }

    public double[] apply(double[] in1, double[] in2, Controller controller) throws Controller.CanceledByUser {
        return this._functor.apply(in1, in2, controller);
    }

    public Sequence apply(double in1, Sequence in2, Controller controller) throws Controller.CanceledByUser {
        return this._functor.apply(in1, in2, controller);
    }

    public Sequence apply(double in1, SubSequence in2, Controller controller) throws Controller.CanceledByUser {
        return this._functor.apply(in1, in2, controller);
    }

    public Sequence apply(Sequence in1, double in2, Controller controller) throws Controller.CanceledByUser {
        return this._functor.apply(in1, in2, controller);
    }

    public Sequence apply(Sequence in1, Sequence in2, Controller controller) throws Controller.CanceledByUser {
        return this._functor.apply(in1, in2, controller);
    }

    public Sequence apply(Sequence in1, SubSequence in2, Controller controller) throws Controller.CanceledByUser {
        return this._functor.apply(in1, in2, controller);
    }

    public Sequence apply(SubSequence in1, double in2, Controller controller) throws Controller.CanceledByUser {
        return this._functor.apply(in1, in2, controller);
    }

    public Sequence apply(SubSequence in1, Sequence in2, Controller controller) throws Controller.CanceledByUser {
        return this._functor.apply(in1, in2, controller);
    }

    public Sequence apply(SubSequence in1, SubSequence in2, Controller controller) throws Controller.CanceledByUser {
        return this._functor.apply(in1, in2, controller);
    }

    public void apply(double[] out, double in1, double[] in2, Controller controller) throws Controller.CanceledByUser {
        this._functor.apply(out, in1, in2, controller);
    }

    public void apply(double[] out, double[] in1, double in2, Controller controller) throws Controller.CanceledByUser {
        this._functor.apply(out, in1, in2, controller);
    }

    public void apply(double[] out, double[] in1, double[] in2, Controller controller) throws Controller.CanceledByUser {
        this._functor.apply(out, in1, in2, controller);
    }

    public void apply(Sequence out, double in1, Sequence in2, Controller controller) throws Controller.CanceledByUser {
        this._functor.apply(out, in1, in2, controller);
    }

    public void apply(Sequence out, double in1, SubSequence in2, Controller controller) throws Controller.CanceledByUser {
        this._functor.apply(out, in1, in2, controller);
    }

    public void apply(Sequence out, Sequence in1, double in2, Controller controller) throws Controller.CanceledByUser {
        this._functor.apply(out, in1, in2, controller);
    }

    public void apply(Sequence out, Sequence in1, Sequence in2, Controller controller) throws Controller.CanceledByUser {
        this._functor.apply(out, in1, in2, controller);
    }

    public void apply(Sequence out, Sequence in1, SubSequence in2, Controller controller) throws Controller.CanceledByUser {
        this._functor.apply(out, in1, in2, controller);
    }

    public void apply(Sequence out, SubSequence in1, double in2, Controller controller) throws Controller.CanceledByUser {
        this._functor.apply(out, in1, in2, controller);
    }

    public void apply(Sequence out, SubSequence in1, Sequence in2, Controller controller) throws Controller.CanceledByUser {
        this._functor.apply(out, in1, in2, controller);
    }

    public void apply(Sequence out, SubSequence in1, SubSequence in2, Controller controller) throws Controller.CanceledByUser {
        this._functor.apply(out, in1, in2, controller);
    }
}

