/*
 * Decompiled with CFR 0.152.
 */
package ij.plugin;

import ij.IJ;
import ij.ImagePlus;
import ij.Prefs;
import ij.WindowManager;
import ij.gui.DialogListener;
import ij.gui.GenericDialog;
import ij.gui.Roi;
import ij.plugin.PlugIn;
import java.awt.AWTEvent;

public class WandToolOptions
implements PlugIn,
DialogListener {
    private static final String[] modes = new String[]{"Legacy", "4-connected", "8-connected"};
    private static String mode = modes[0];
    private static double tolerance;
    private ImagePlus imp;
    private boolean showCheckbox;
    private static int startx;
    private static int starty;
    private static int ID;

    @Override
    public void run(String arg) {
        int depth;
        boolean selection;
        this.imp = WindowManager.getCurrentImage();
        Roi roi = this.imp != null ? this.imp.getRoi() : null;
        boolean bl = selection = roi != null && (roi.getType() == 4 || roi.getType() == 2);
        if (this.imp == null || ID != 0 && this.imp.getID() != ID || !selection) {
            starty = 0;
            startx = 0;
        }
        ID = this.imp != null ? this.imp.getID() : 0;
        double sliderMax = 255.0;
        int n = depth = this.imp != null ? this.imp.getBitDepth() : 0;
        if (depth == 16 || depth == 32) {
            sliderMax = this.imp.getProcessor().getMax();
            if (depth == 32) {
                sliderMax += 1.0E-10;
            }
        }
        this.showCheckbox = this.imp != null && depth != 24 && WindowManager.getFrame("Threshold") == null && !this.imp.isThreshold();
        GenericDialog gd = new GenericDialog("Wand Tool");
        gd.addSlider("Tolerance: ", 0.0, sliderMax, tolerance);
        gd.addChoice("Mode:", modes, mode);
        if (this.showCheckbox) {
            gd.addCheckbox("Enable Thresholding", false);
        }
        gd.addCheckbox("Smooth if thresholded", Prefs.smoothWand);
        if (this.showCheckbox) {
            gd.setInsets(2, 0, 0);
            gd.addMessage("Thresholded objects are traced and \"Tolerance\"\nis ignored when thresholding is enabled.");
        }
        gd.addDialogListener(this);
        gd.showDialog();
    }

    @Override
    public boolean dialogItemChanged(GenericDialog gd, AWTEvent e) {
        if (gd.wasCanceled()) {
            return false;
        }
        tolerance = gd.getNextNumber();
        mode = gd.getNextChoice();
        if (this.showCheckbox && gd.getNextBoolean()) {
            this.imp.deleteRoi();
            IJ.run("Threshold...");
        }
        Prefs.smoothWand = gd.getNextBoolean();
        if (startx > 0 || starty > 0) {
            IJ.doWand(startx, starty, tolerance, mode + (Prefs.smoothWand ? " smooth" : ""));
        }
        return true;
    }

    public static String getMode() {
        return mode;
    }

    public static double getTolerance() {
        return tolerance;
    }

    public static final void setStart(int x, int y) {
        startx = x;
        starty = y;
    }
}

