/*
 * Decompiled with CFR 0.152.
 */
package plugins.perrine.ec_clem.autofinder;

import icy.canvas.IcyCanvas;
import icy.file.FileUtil;
import icy.gui.dialog.MessageDialog;
import icy.gui.frame.progress.AnnounceFrame;
import icy.gui.frame.progress.ProgressFrame;
import icy.gui.frame.progress.ToolTipFrame;
import icy.painter.Overlay;
import icy.plugin.PluginDescriptor;
import icy.plugin.PluginLauncher;
import icy.plugin.PluginLoader;
import icy.roi.ROI;
import icy.sequence.Sequence;
import icy.sequence.SequenceUtil;
import icy.type.DataType;
import icy.type.point.Point5D;
import icy.util.XMLUtil;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Random;
import java.util.concurrent.CompletableFuture;
import javax.inject.Inject;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import plugins.adufour.blocks.lang.Block;
import plugins.adufour.blocks.util.VarList;
import plugins.adufour.ezplug.EzComponent;
import plugins.adufour.ezplug.EzGroup;
import plugins.adufour.ezplug.EzLabel;
import plugins.adufour.ezplug.EzPlug;
import plugins.adufour.ezplug.EzStoppable;
import plugins.adufour.ezplug.EzVar;
import plugins.adufour.ezplug.EzVarBoolean;
import plugins.adufour.ezplug.EzVarDouble;
import plugins.adufour.ezplug.EzVarInteger;
import plugins.adufour.ezplug.EzVarListener;
import plugins.adufour.ezplug.EzVarSequence;
import plugins.adufour.ezplug.EzVarText;
import plugins.adufour.vars.lang.Var;
import plugins.adufour.vars.lang.VarInteger;
import plugins.adufour.vars.lang.VarSequence;
import plugins.kernel.roi.descriptor.measure.ROIMassCenterDescriptorsPlugin;
import plugins.kernel.roi.roi3d.ROI3DPoint;
import plugins.perrine.ec_clem.autofinder.DaggerEcClemAutoFinderComponent;
import plugins.perrine.ec_clem.autofinder.helpButton;
import plugins.perrine.ec_clem.ec_clem.transformation.configuration.TransformationConfigurationFactory;
import plugins.perrine.ec_clem.ec_clem.transformation.schema.NoiseModel;
import plugins.perrine.ec_clem.ec_clem.transformation.schema.TransformationType;
import plugins.perrine.ec_clem.ec_clem.ui.ProgressBarManager;
import plugins.perrine.ec_clem.ec_clem.workspace.Workspace;
import plugins.perrine.ec_clem.ec_clem.workspace.WorkspaceTransformer;
import vtk.vtkAbstractArray;
import vtk.vtkAbstractTransform;
import vtk.vtkCenterOfMass;
import vtk.vtkDataObject;
import vtk.vtkDataSet;
import vtk.vtkDoubleArray;
import vtk.vtkIdList;
import vtk.vtkImageData;
import vtk.vtkImageReslice;
import vtk.vtkIterativeClosestPointTransform;
import vtk.vtkLinearTransform;
import vtk.vtkMath;
import vtk.vtkMatrix4x4;
import vtk.vtkPCAStatistics;
import vtk.vtkPointLocator;
import vtk.vtkPointSet;
import vtk.vtkPoints;
import vtk.vtkPolyData;
import vtk.vtkTable;
import vtk.vtkTransform;
import vtk.vtkTransformPolyDataFilter;
import vtk.vtkVertexGlyphFilter;

public class EcClemAutoFinder
extends EzPlug
implements Block,
EzStoppable {
    private EzVarSequence source = new EzVarSequence("Source");
    private EzVarSequence target = new EzVarSequence("Target");
    private EzVarDouble pixelsizexysource = new EzVarDouble("Pixel size x,y of source in nanometers");
    private EzVarDouble pixelsizexytarget = new EzVarDouble("Pixel size x,y of target in nanometers");
    private EzVarDouble pixelsizezsource = new EzVarDouble("Slice spacing of source in nanometers");
    private EzVarDouble pixelsizeztarget = new EzVarDouble("Slice spacing of target in nanometers");
    private EzLabel versioninfo = new EzLabel("Version " + this.getDescriptor().getVersion());
    private EzVarText choicemode = new EzVarText("Transform Mode:", new String[]{"Already in the same orientation", "About the same content in both n-D images", "Find small part in bigger field of view", "Find small part in bigger field of view Reverse"}, 0, Boolean.valueOf(false));
    EzVarBoolean showtarget = new EzVarBoolean(" Also show the transformed target on source", false);
    EzVarBoolean exporttoecclem = new EzVarBoolean(" Export results for further analysis in ec-clem", false);
    EzVarDouble distvar = new EzVarDouble("Max error allowed for testing in microns", 1.0, 0.0, 1000000.0, 1.0);
    EzVarInteger proportion = new EzVarInteger("Percentage of target point to keep for test", 70, 1, 100, 20);
    private double InputSpacingx;
    private double InputSpacingy;
    private double InputSpacingz;
    private Sequence imagesource;
    private Sequence imagetarget;
    private vtkDataSet[] imageData;
    private vtkImageReslice ImageReslice;
    private vtkPolyData sourcepoint;
    private vtkPolyData targetpoint;
    private int extentx;
    private int extenty;
    private int extentz;
    private double spacingx;
    private double spacingy;
    private double spacingz;
    private double radius;
    private int sourcenbpointsradius1;
    private int sourcenbpointsradius2;
    private DataType oriType;
    double distance = Double.POSITIVE_INFINITY;
    private int nbpoints;
    private VarSequence tseqtarget = new VarSequence("Target transformed on source", null);
    private VarSequence tseqsource = new VarSequence("Source transformed on Target sequence", null);
    private VarInteger scalepercent = new VarInteger("Scale", 100);
    private EzVarBoolean affine = new EzVarBoolean("Physical scaling", false);
    boolean stopFlag;
    private double minspacingtotest = 4.0;
    private double minscore = Double.POSITIVE_INFINITY;
    private int keptpoint = 0;
    private double percent;
    private int nbtasks;
    private vtkPoints icppointsource;
    private vtkPoints icppointtarget;
    private Sequence sequence4;
    private TransformationConfigurationFactory transformationConfigurationFactory;
    private vtkPoints icppointsource_nr;

    public EcClemAutoFinder() {
        DaggerEcClemAutoFinderComponent.builder().build().inject(this);
    }

    public void stopExecution() {
        this.stopFlag = true;
    }

    public void declareInput(VarList inputMap) {
        inputMap.add("Source Image", (Var)this.source.getVariable());
        inputMap.add("Target Image", (Var)this.target.getVariable());
        inputMap.add("Transformation Mode", this.choicemode.getVariable());
        this.distvar.setValue((Object)1.0);
        inputMap.add("Distance max", this.distvar.getVariable());
        inputMap.add("Proportion", this.proportion.getVariable());
        inputMap.add("Affine", this.affine.getVariable());
    }

    public void declareOutput(VarList outputMap) {
        outputMap.add("Source Transformed on Target", (Var)this.tseqsource);
        outputMap.add("Target Transformed on Source", (Var)this.tseqtarget);
        outputMap.add("Corrected scale", (Var)this.scalepercent);
    }

    public void clean() {
    }

    protected void execute() {
        this.stopFlag = false;
        if (this.source.getValue() == this.target.getValue()) {
            new AnnounceFrame("You have selected the same source and target image!");
            return;
        }
        if (this.source.getValue() == null) {
            new AnnounceFrame("Source image was closed!");
            return;
        }
        if (this.target.getValue() == null) {
            new AnnounceFrame("Target image was closed!");
            return;
        }
        if (((Sequence)this.source.getValue()).getROIs().size() == 0) {
            new AnnounceFrame("There is no Roi on " + ((Sequence)this.source.getValue()).getName());
            return;
        }
        if (((Sequence)this.target.getValue()).getROIs().size() == 0) {
            new AnnounceFrame("There is no Roi on " + ((Sequence)this.target.getValue()).getName());
            return;
        }
        if (((Sequence)this.source.getValue()).getROIs().size() < 8) {
            new AnnounceFrame("You need at least 8 Roi points on " + ((Sequence)this.source.getValue()).getName());
            new AnnounceFrame("Give a try to BinarytoPointRoi, from Rois with small sampling");
            return;
        }
        if (((Sequence)this.target.getValue()).getROIs().size() < 8) {
            new AnnounceFrame("You need at least 8 Roi points on " + ((Sequence)this.target.getValue()).getName());
            new AnnounceFrame("Give a try to BinarytoPointRoi, from Rois with small sampling");
            return;
        }
        List oldoverlays = ((Sequence)this.target.getValue()).getOverlays();
        for (int i = 0; i < oldoverlays.size(); ++i) {
            if (!((Overlay)oldoverlays.get(i)).getCanBeRemoved()) continue;
            ((Sequence)this.target.getValue()).removeOverlay((Overlay)oldoverlays.get(i));
        }
        boolean showtargetTransformed = (Boolean)this.showtarget.getValue();
        boolean prepareexport = (Boolean)this.exporttoecclem.getValue();
        if (prepareexport) {
            showtargetTransformed = true;
        }
        this.sourcepoint = this.getRoifromsequence((Sequence)this.source.getValue(), 0, ((Sequence)this.source.getValue()).getSizeX(), 0, ((Sequence)this.source.getValue()).getSizeY(), -1, ((Sequence)this.source.getValue()).getSizeZ());
        this.targetpoint = this.getRoifromsequence((Sequence)this.target.getValue(), 0, Math.round(((Sequence)this.target.getValue()).getSizeX()), 0, Math.round(((Sequence)this.target.getValue()).getSizeY()), -1, ((Sequence)this.target.getValue()).getSizeZ());
        System.out.println("# source points" + this.sourcepoint.GetNumberOfPoints());
        System.out.println("# target points" + this.targetpoint.GetNumberOfPoints());
        this.icppointsource = new vtkPoints();
        this.icppointtarget = new vtkPoints();
        this.setData();
        this.distance = Double.POSITIVE_INFINITY;
        this.minscore = Double.POSITIVE_INFINITY;
        this.keptpoint = 0;
        this.percent = (double)((Integer)this.proportion.getValue()).intValue() / 100.0;
        vtkTransform myvtktransform = new vtkTransform();
        vtkMatrix4x4 mybesttransform = new vtkMatrix4x4();
        double dist = (Double)this.distvar.getValue();
        System.out.println("Distance max " + dist + "microns");
        System.out.println("Proportion " + this.proportion.getValue() + "%");
        vtkTransform tobewritten = new vtkTransform();
        if (this.choicemode.getValue() == "Already in the same orientation") {
            mybesttransform = this.AutoFinder(this.targetpoint, dist);
            System.out.println("The distance now is:" + this.distance);
            myvtktransform.SetMatrix(mybesttransform);
            this.applyTransformtosequenceandROIworkspace((vtkAbstractTransform)myvtktransform);
            tobewritten.DeepCopy((vtkAbstractTransform)myvtktransform);
            if (showtargetTransformed || this.isHeadLess()) {
                this.applyInverseTransformtoTarget(myvtktransform);
            }
        } else if (((String)this.choicemode.getValue()).contains("About the same content in both n-D images")) {
            vtkTransform aligned = this.ReorientSourcepointandComputeRadius(false);
            vtkTransform reorientingTargetPoint = this.ReorientCandidatesTargetpoints(this.targetpoint);
            vtkTransformPolyDataFilter trup = new vtkTransformPolyDataFilter();
            trup.SetInputData((vtkDataObject)this.targetpoint);
            trup.SetTransform((vtkAbstractTransform)reorientingTargetPoint);
            trup.Update();
            mybesttransform = this.AutoFinder(trup.GetOutput(), dist);
            double back_updistance = this.distance;
            this.sourcepoint = this.getRoifromsequence((Sequence)this.source.getValue(), 0, ((Sequence)this.source.getValue()).getSizeX(), 0, ((Sequence)this.source.getValue()).getSizeY(), -1, ((Sequence)this.source.getValue()).getSizeZ());
            vtkTransform aligned2 = this.ReorientSourcepointandComputeRadius(true);
            vtkMatrix4x4 mybesttransform2 = new vtkMatrix4x4();
            mybesttransform2 = this.AutoFinder(trup.GetOutput(), dist);
            if (this.distance < back_updistance) {
                mybesttransform.DeepCopy(mybesttransform2);
                aligned.DeepCopy((vtkAbstractTransform)aligned2);
                System.out.println("Reverse kept");
            } else {
                this.distance = back_updistance;
                this.sourcepoint = this.getRoifromsequence((Sequence)this.source.getValue(), 0, ((Sequence)this.source.getValue()).getSizeX(), 0, ((Sequence)this.source.getValue()).getSizeY(), -1, ((Sequence)this.source.getValue()).getSizeZ());
                this.ReorientSourcepointandComputeRadius(false);
                System.out.println("not reverse kept");
            }
            this.transformVtkInlierTargetPoints(reorientingTargetPoint);
            this.transformVtkInlierSourcePoints(reorientingTargetPoint);
            vtkTransform myvtktransformtmp = new vtkTransform();
            myvtktransformtmp.SetMatrix(mybesttransform);
            myvtktransformtmp.PostMultiply();
            myvtktransformtmp.Concatenate((vtkLinearTransform)reorientingTargetPoint.GetInverse());
            myvtktransformtmp.Update();
            myvtktransform.DeepCopy((vtkAbstractTransform)myvtktransformtmp);
            aligned.PostMultiply();
            aligned.Concatenate((vtkLinearTransform)myvtktransform);
            aligned.Update();
            if (this.distance < Double.POSITIVE_INFINITY) {
                System.out.println("I will apply transfo now");
                this.applyTransformtosequenceandROIworkspace((vtkAbstractTransform)aligned);
                tobewritten.DeepCopy((vtkAbstractTransform)aligned);
                if (showtargetTransformed || this.isHeadLess()) {
                    this.applyInverseTransformtoTarget(aligned);
                }
                this.writeCSVfile(this.icppointsource, "inlierregisteredsourcepointsinnm.csv");
                this.writeCSVfile(this.icppointtarget, "inliertargetpointsinnm.csv");
                System.out.println("Registrered point source and taregt has been saved under Icy directory as csv file");
                System.out.println("You can reimport them using import RoiPointsfromfile");
                System.out.println("For example to use a non rigid transform from ec-Clem");
            } else {
                new AnnounceFrame("notransform found");
            }
        } else if (this.choicemode.getValue() == "Find small part in bigger field of view") {
            vtkTransform aligned = this.ReorientSourcepointandComputeRadius(false);
            vtkPoints candidates = new vtkPoints();
            candidates.Initialize();
            vtkPoints other = this.FindCandidatesAreasinTarget();
            candidates.ShallowCopy(other);
            if (candidates.GetNumberOfPoints() == 0) {
                System.out.println("no candidates based on the number of point were found, testing the other method, based on density ratio");
                vtkPoints other2 = this.FindCandidatesAreasinTargetMethod2();
                candidates.ShallowCopy(other2);
            }
            double distance_max = (Double)this.distvar.getValue() * 1000.0;
            myvtktransform = new vtkTransform();
            ProgressFrame progressc = new ProgressFrame("Analyzing Candidates...");
            progressc.setLength((double)candidates.GetNumberOfPoints());
            for (int cand = 0; cand < candidates.GetNumberOfPoints(); ++cand) {
                if (this.stopFlag) {
                    progressc.close();
                    return;
                }
                progressc.setPosition((double)cand);
                vtkPointLocator plocator = new vtkPointLocator();
                plocator.SetDataSet((vtkDataSet)this.targetpoint);
                vtkIdList listofpoints = new vtkIdList();
                plocator.FindPointsWithinRadius(this.radius, candidates.GetPoint(cand), listofpoints);
                vtkPoints test = new vtkPoints();
                test.Initialize();
                test.SetDataTypeToDouble();
                for (int ip = 0; ip < listofpoints.GetNumberOfIds(); ++ip) {
                    test.InsertNextPoint(this.targetpoint.GetPoint(listofpoints.GetId(ip)));
                }
                vtkPolyData mypoints = new vtkPolyData();
                mypoints.SetPoints(test);
                vtkVertexGlyphFilter vertexfilter = new vtkVertexGlyphFilter();
                vertexfilter.SetInputData((vtkDataObject)mypoints);
                vtkPolyData newsetoftargetpoints = new vtkPolyData();
                vertexfilter.Update();
                newsetoftargetpoints.ShallowCopy((vtkDataObject)vertexfilter.GetOutput());
                vtkTransform reorientingTargetPoint = this.ReorientCandidatesTargetpoints(newsetoftargetpoints);
                vtkTransformPolyDataFilter trup = new vtkTransformPolyDataFilter();
                trup.SetInputData((vtkDataObject)newsetoftargetpoints);
                trup.SetTransform((vtkAbstractTransform)reorientingTargetPoint);
                trup.Update();
                mybesttransform = new vtkMatrix4x4();
                MyCandidatesOverlay mycandidate = new MyCandidatesOverlay(cand);
                mycandidate.setParameters(candidates.GetPoint(cand)[0] / this.imagetarget.getPixelSizeX(), candidates.GetPoint(cand)[1] / this.imagetarget.getPixelSizeY(), this.radius * 2.0 / this.imagetarget.getPixelSizeY());
                ((Sequence)this.target.getValue()).addOverlay((Overlay)mycandidate);
                mybesttransform = this.AutoFinder(trup.GetOutput(), dist);
                vtkTransform myvtktransformtmp = new vtkTransform();
                myvtktransformtmp.SetMatrix(mybesttransform);
                myvtktransformtmp.PostMultiply();
                myvtktransformtmp.Concatenate((vtkLinearTransform)reorientingTargetPoint.GetInverse());
                myvtktransformtmp.Update();
                if (!(this.distance < distance_max)) continue;
                distance_max = this.distance;
                myvtktransform.DeepCopy((vtkAbstractTransform)myvtktransformtmp);
                mycandidate.setHot();
                this.transformVtkInlierTargetPoints(reorientingTargetPoint);
                this.transformVtkInlierSourcePoints(reorientingTargetPoint);
                this.writeCSVfile(this.icppointsource, "inlierregisteredsourcepointsinnm.csv");
                this.writeCSVfile(this.icppointtarget, "inliertargetpointsinnm.csv");
                System.out.println("Registrered point source and taregt has been saved under Icy directory as csv file");
                System.out.println("You can reimport them using import RoiPointsfromfile");
                System.out.println("For example to use a non rigid transform from ec-Clem");
            }
            progressc.close();
            if (distance_max < (Double)this.distvar.getValue() * 1000.0) {
                aligned.PostMultiply();
                aligned.Concatenate((vtkLinearTransform)myvtktransform);
                aligned.Update();
                System.out.println("I will apply transfo now");
                this.applyTransformtosequenceandROIworkspace((vtkAbstractTransform)aligned);
                tobewritten.DeepCopy((vtkAbstractTransform)aligned);
                if (showtargetTransformed || this.isHeadLess()) {
                    this.applyInverseTransformtoTarget(aligned);
                }
            } else {
                System.err.println("No transform was found, Check Your Calibration Settings, and the detection of points");
                new AnnounceFrame("No transform was found: you can augment the tolerance on error or play on the proportion of point to be tested for example");
            }
        } else {
            vtkTransform aligned = this.ReorientSourcepointandComputeRadius(true);
            vtkPoints candidates = new vtkPoints();
            candidates.Initialize();
            vtkPoints other = this.FindCandidatesAreasinTarget();
            candidates.ShallowCopy(other);
            if (candidates.GetNumberOfPoints() == 0) {
                System.out.println("no candidates based on the number of point were found, testing the other method, based on density ratio");
                vtkPoints other2 = this.FindCandidatesAreasinTargetMethod2();
                candidates.ShallowCopy(other2);
            }
            this.distance = Double.POSITIVE_INFINITY;
            double distance_max = (Double)this.distvar.getValue() * 1000.0;
            myvtktransform = new vtkTransform();
            ProgressFrame progressc = new ProgressFrame("Analyzing Candidates...");
            progressc.setLength((double)candidates.GetNumberOfPoints());
            for (int cand = 0; cand < candidates.GetNumberOfPoints(); ++cand) {
                if (this.stopFlag) {
                    progressc.close();
                    return;
                }
                progressc.setPosition((double)cand);
                vtkPointLocator plocator = new vtkPointLocator();
                plocator.SetDataSet((vtkDataSet)this.targetpoint);
                vtkIdList listofpoints = new vtkIdList();
                plocator.FindPointsWithinRadius(this.radius, candidates.GetPoint(cand), listofpoints);
                vtkPoints test = new vtkPoints();
                test.Initialize();
                test.SetDataTypeToDouble();
                for (int ip = 0; ip < listofpoints.GetNumberOfIds(); ++ip) {
                    test.InsertNextPoint(this.targetpoint.GetPoint(listofpoints.GetId(ip)));
                }
                vtkPolyData mypoints = new vtkPolyData();
                mypoints.SetPoints(test);
                vtkVertexGlyphFilter vertexfilter = new vtkVertexGlyphFilter();
                vertexfilter.SetInputData((vtkDataObject)mypoints);
                vtkPolyData newsetoftargetpoints = new vtkPolyData();
                vertexfilter.Update();
                newsetoftargetpoints.ShallowCopy((vtkDataObject)vertexfilter.GetOutput());
                vtkTransform reorientingTargetPoint = this.ReorientCandidatesTargetpoints(newsetoftargetpoints);
                vtkTransformPolyDataFilter trup = new vtkTransformPolyDataFilter();
                trup.SetInputData((vtkDataObject)newsetoftargetpoints);
                trup.SetTransform((vtkAbstractTransform)reorientingTargetPoint);
                trup.Update();
                mybesttransform = new vtkMatrix4x4();
                MyCandidatesOverlay mycandidate = new MyCandidatesOverlay(cand);
                mycandidate.setParameters(candidates.GetPoint(cand)[0] / this.imagetarget.getPixelSizeX(), candidates.GetPoint(cand)[1] / this.imagetarget.getPixelSizeY(), this.radius * 2.0 / this.imagetarget.getPixelSizeY());
                ((Sequence)this.target.getValue()).addOverlay((Overlay)mycandidate);
                mybesttransform = this.AutoFinder(trup.GetOutput(), dist);
                vtkTransform myvtktransformtmp = new vtkTransform();
                myvtktransformtmp.SetMatrix(mybesttransform);
                myvtktransformtmp.PostMultiply();
                myvtktransformtmp.Concatenate((vtkLinearTransform)reorientingTargetPoint.GetInverse());
                myvtktransformtmp.Update();
                if (!(this.distance < distance_max)) continue;
                distance_max = this.distance;
                myvtktransform.DeepCopy((vtkAbstractTransform)myvtktransformtmp);
                mycandidate.setHot();
                this.transformVtkInlierTargetPoints(reorientingTargetPoint);
                this.transformVtkInlierSourcePoints(reorientingTargetPoint);
                this.writeCSVfile(this.icppointsource, "inlierregisteredsourcepointsinnm.csv");
                this.writeCSVfile(this.icppointtarget, "inliertargetpointsinnm.csv");
            }
            progressc.close();
            if (distance_max < (Double)this.distvar.getValue() * 1000.0) {
                aligned.PostMultiply();
                aligned.Concatenate((vtkLinearTransform)myvtktransform);
                aligned.Update();
                System.out.println("I will apply transfo now");
                this.applyTransformtosequenceandROIworkspace((vtkAbstractTransform)aligned);
                tobewritten.DeepCopy((vtkAbstractTransform)aligned);
                if (showtargetTransformed || this.isHeadLess() || prepareexport) {
                    this.applyInverseTransformtoTarget(aligned);
                }
            } else {
                System.err.println("No transform was found, Check Your Calibration Settings, and the detection of points");
                new AnnounceFrame("No transform found, try to augment the distance or decrease the proportion of point to be tested");
            }
        }
        this.transformVtkInlierTargetPoints(tobewritten);
        this.transformVtkInlierSourcePoints(tobewritten);
        this.writeCSVfile(this.icppointsource, "inversetransfoinlierregisteredsourcepointsinnm.csv");
        this.writeCSVfile(this.icppointtarget, "inversetransfoinliertargetpointsinnm.csv");
        this.writeTransfo((Sequence)this.source.getValue(), (Sequence)this.target.getValue(), tobewritten);
        this.writeTransfo((Sequence)this.target.getValue(), (Sequence)this.source.getValue(), (vtkTransform)tobewritten.GetInverse());
        if (prepareexport) {
            this.LaunchReadytoUseEcCLEM();
        }
    }

    protected vtkPolyData getRoifromsequence(Sequence seq, int minx, int maxx, int miny, int maxy, int minz, int maxz) {
        vtkPoints test = new vtkPoints();
        test.SetDataTypeToDouble();
        if (seq == null) {
            MessageDialog.showDialog((String)"Make sure source image is openned");
            return null;
        }
        ArrayList listfiducials = seq.getROIs();
        int i = -1;
        for (ROI roi : listfiducials) {
            ++i;
            Point5D p3D = null;
            try {
                p3D = ROIMassCenterDescriptorsPlugin.computeMassCenter((ROI)roi);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            if (roi.getClass().getName() == "plugins.kernel.roi.roi2d.ROI2DPoint") {
                p3D = roi.getPosition5D();
            }
            if (roi.getClass().getName() == "plugins.perrine.easyclemv0.myRoi3D") {
                p3D = roi.getPosition5D();
            }
            if (p3D.getZ() < 0.0) {
                p3D.setZ(0.0);
            }
            if (!this.testinside(p3D, minx, maxx, miny, maxy, minz, maxz)) continue;
            test.InsertNextPoint(p3D.getX() * seq.getPixelSizeX(), p3D.getY() * seq.getPixelSizeY(), p3D.getZ() * seq.getPixelSizeZ());
        }
        vtkPolyData mypoints = new vtkPolyData();
        mypoints.SetPoints(test);
        vtkVertexGlyphFilter vertexfilter = new vtkVertexGlyphFilter();
        vertexfilter.SetInputData((vtkDataObject)mypoints);
        vtkPolyData copy = new vtkPolyData();
        vertexfilter.Update();
        copy.ShallowCopy((vtkDataObject)vertexfilter.GetOutput());
        return copy;
    }

    private boolean testinside(Point5D p3d, int minx, int maxx, int miny, int maxy, int minz, int maxz) {
        return p3d.getX() >= (double)minx && p3d.getX() <= (double)maxx && p3d.getY() >= (double)miny && p3d.getY() <= (double)maxy && p3d.getZ() >= (double)minz && p3d.getZ() <= (double)maxz;
    }

    vtkImageData converttoVtkImageData(int posC, Sequence seq, boolean affectfield) {
        return null;
    }

    protected void CreateRoifromPoints(Sequence seq, vtkPolyData points, Color mycolor, String Name2) {
        String POINT_TYPE_PROPERTY = "point_type";
        vtkPoints listofpoints = points.GetPoints();
        for (int i = 0; i < points.GetNumberOfPoints(); ++i) {
            ROI3DPoint roi = new ROI3DPoint();
            Point5D position = roi.getPosition5D();
            position.setX(listofpoints.GetPoint(i)[0] / seq.getPixelSizeX());
            position.setY(listofpoints.GetPoint(i)[1] / seq.getPixelSizeY());
            position.setZ(listofpoints.GetPoint(i)[2] / seq.getPixelSizeZ());
            roi.setPosition5D(position);
            roi.setName(Name2 + " Point " + i);
            roi.setColor(mycolor);
            roi.setProperty(POINT_TYPE_PROPERTY, "FIDUCIAL");
            seq.addROI((ROI)roi);
        }
    }

    private void setData() {
        this.imagesource = (Sequence)this.source.getValue();
        this.imagetarget = (Sequence)this.target.getValue();
        this.InputSpacingx = ((Sequence)this.source.getValue()).getPixelSizeX();
        this.InputSpacingy = ((Sequence)this.source.getValue()).getPixelSizeY();
        this.InputSpacingz = ((Sequence)this.source.getValue()).getPixelSizeZ();
        this.oriType = ((Sequence)this.source.getValue()).getDataType_();
        this.extentx = ((Sequence)this.target.getValue()).getSizeX() - 1;
        this.extenty = ((Sequence)this.target.getValue()).getSizeY() - 1;
        this.extentz = ((Sequence)this.target.getValue()).getSizeZ() - 1;
        this.spacingx = ((Sequence)this.target.getValue()).getPixelSizeX();
        this.spacingy = ((Sequence)this.target.getValue()).getPixelSizeY();
        this.spacingz = ((Sequence)this.target.getValue()).getPixelSizeZ();
    }

    private void applyTransformtosequenceandROIworkspace(vtkAbstractTransform transform) {
        String transformationtype = "RIGID";
        if (((Boolean)this.affine.getValue()).booleanValue()) {
            transformationtype = "SIMILARITY";
        }
        Workspace workspace = new Workspace();
        ArrayList roitargetlist = this.imagetarget.getROIs();
        this.imagetarget.removeAllROI();
        Sequence result = SequenceUtil.getCopy((Sequence)this.imagesource);
        result.removeAllROI();
        workspace.setSourceSequence(result);
        workspace.setTargetSequence(this.imagetarget);
        vtkPolyData mypoints = new vtkPolyData();
        mypoints.SetPoints(this.icppointtarget);
        this.CreateRoifromPoints(this.imagetarget, mypoints, Color.YELLOW, "ICP target");
        vtkPolyData mytmppoints = new vtkPolyData();
        mytmppoints.SetPoints(this.icppointsource);
        vtkVertexGlyphFilter vertexfilter = new vtkVertexGlyphFilter();
        vertexfilter.SetInputData((vtkDataObject)mytmppoints);
        vtkPolyData newsetoftargetpoints = new vtkPolyData();
        vertexfilter.Update();
        newsetoftargetpoints.ShallowCopy((vtkDataObject)vertexfilter.GetOutput());
        vtkTransformPolyDataFilter trup = new vtkTransformPolyDataFilter();
        trup.SetInputData((vtkDataObject)newsetoftargetpoints);
        trup.SetTransform(transform.GetInverse());
        trup.Update();
        this.icppointsource_nr = trup.GetOutput().GetPoints();
        vtkPolyData mypoints2 = new vtkPolyData();
        mypoints2.SetPoints(this.icppointsource_nr);
        this.CreateRoifromPoints(result, mypoints2, Color.YELLOW, "ICP source");
        this.addSequence(result);
        Path parent = Paths.get(FileUtil.getApplicationDirectory(), new String[0]);
        String warningmessagestorage = "All saved files will be under " + FileUtil.getApplicationDirectory();
        if (this.imagesource.getFilename() == null) {
            if (this.imagetarget.getFilename() == null) {
                MessageDialog.showDialog((String)("Note that Source and Target are not saved on disk, \n  " + warningmessagestorage), (int)2);
            } else {
                parent = Paths.get(this.imagetarget.getFilename(), new String[0]).getParent();
                MessageDialog.showDialog((String)("Note that Source is not saved on disk, \n  " + warningmessagestorage), (int)2);
            }
        } else {
            parent = Paths.get(this.imagesource.getFilename(), new String[0]).getParent();
        }
        if (parent == null) {
            parent = Paths.get(FileUtil.getApplicationDirectory(), new String[0]);
        }
        String date = LocalDateTime.now().format(DateTimeFormatter.ofPattern("yyyy_MM_dd_HH_mm_ss"));
        File transformationSchemaOutputFile = new File(String.format("%s/%s_to_%s_%s.autofinder.transformation_schema.xml", parent.toString(), this.imagesource.getName(), this.imagetarget.getName(), date));
        System.out.println(String.format("Transformation schema saved at : %s", transformationSchemaOutputFile.toString()));
        workspace.setTransformationSchemaOutputFile(transformationSchemaOutputFile);
        File csvTransformationFile = new File(String.format("%s/%s_to_%s_%s.autofinder.transformation.csv", parent.toString(), this.imagesource.getName(), this.imagetarget.getName(), date));
        System.out.println(String.format("CSV format transformation saved at : %s", csvTransformationFile.toString()));
        workspace.setCsvTransformationOutputFile(csvTransformationFile);
        File XmlTransformationFile = new File(String.format("%s/%s_to_%s_%s.autofinder.transformation.xml", parent.toString(), this.imagesource.getName(), this.imagetarget.getName(), date));
        System.out.println(String.format("XML format transformation saved at : %s", XmlTransformationFile.toString()));
        workspace.setXmlTransformationOutputFile(XmlTransformationFile);
        workspace.setTransformationConfiguration(this.transformationConfigurationFactory.getFrom(TransformationType.valueOf(transformationtype), NoiseModel.valueOf("ANISOTROPIC"), false));
        ProgressBarManager progressBarManager = new ProgressBarManager();
        WorkspaceTransformer workspaceTransformer = new WorkspaceTransformer(workspace);
        progressBarManager.subscribe(workspaceTransformer);
        CompletableFuture.runAsync(workspaceTransformer).exceptionally(e -> {
            e.printStackTrace();
            MessageDialog.showDialog((String)("Something went wrong: " + e.getCause().getMessage()), (int)0);
            return null;
        });
    }

    @Inject
    public void setTransformationConfigurationFactory(TransformationConfigurationFactory transformationConfigurationFactory) {
        this.transformationConfigurationFactory = transformationConfigurationFactory;
    }

    private vtkMatrix4x4 AutoFinder(vtkPolyData subtargetpoint, double dist) {
        vtkIterativeClosestPointTransform myicp = new vtkIterativeClosestPointTransform();
        vtkMatrix4x4 transform = new vtkMatrix4x4();
        vtkMatrix4x4 mybesttransform = new vtkMatrix4x4();
        int max_iter_icp = 100;
        int max_iter_ransac = Math.max(100, Math.min(3 * this.sourcepoint.GetNumberOfPoints(), 1000));
        if (this.sourcepoint.GetNumberOfPoints() < 100) {
            max_iter_ransac = 500;
            max_iter_icp = 500;
        }
        double mybesttotald = this.distance;
        int nbtarget = Math.max((int)Math.round(this.percent * (double)subtargetpoint.GetNumberOfPoints()), 8);
        int nbsource = Math.max((int)Math.round(this.percent * (double)this.sourcepoint.GetNumberOfPoints()), 8);
        int nbpointransac = Math.min(nbsource, nbtarget);
        int minnbpoint = Math.min(nbpointransac, this.keptpoint);
        if (this.keptpoint == 0) {
            minnbpoint = nbpointransac;
        }
        if ((double)subtargetpoint.GetNumberOfPoints() < 0.5 * (double)this.keptpoint) {
            return mybesttransform;
        }
        for (int iter = 0; iter < max_iter_ransac && !(this.distance < Math.min(this.imagesource.getPixelSizeX(), this.imagetarget.getPixelSizeX())); ++iter) {
            myicp.SetTarget((vtkDataSet)this.sourcepoint);
            List<Integer> listidx = this.generateSmartRandomPointsList(subtargetpoint, nbpointransac, subtargetpoint.GetNumberOfPoints());
            vtkPoints mypointsransac = new vtkPoints();
            mypointsransac.Initialize();
            mypointsransac.SetDataTypeToDouble();
            for (int pp = 0; pp < listidx.size(); ++pp) {
                mypointsransac.InsertNextPoint(subtargetpoint.GetPoint(listidx.get(pp).intValue()));
            }
            vtkPolyData copytmp = new vtkPolyData();
            copytmp.SetPoints(mypointsransac);
            vtkVertexGlyphFilter vertexfiltertmp = new vtkVertexGlyphFilter();
            vertexfiltertmp.SetInputData((vtkDataObject)copytmp);
            vertexfiltertmp.Update();
            vtkPolyData maskedset = new vtkPolyData();
            maskedset.ShallowCopy((vtkDataObject)vertexfiltertmp.GetOutput());
            myicp.SetSource((vtkDataSet)maskedset);
            myicp.GetLandmarkTransform().SetModeToRigidBody();
            if (((Boolean)this.affine.getValue()).booleanValue()) {
                myicp.GetLandmarkTransform().SetModeToSimilarity();
            }
            myicp.SetMaximumNumberOfIterations(max_iter_icp);
            myicp.StartByMatchingCentroidsOn();
            myicp.SetCheckMeanDistance(1);
            myicp.SetMaximumMeanDistance(0.001);
            myicp.Modified();
            myicp.Update();
            transform.DeepCopy(myicp.GetMatrix());
            if (transform.GetElement(3, 3) != 1.0) {
                int tmp = maskedset.GetNumberOfPoints();
                int tmp2 = this.sourcepoint.GetNumberOfPoints();
                System.out.println(tmp + " " + tmp2);
                System.out.println("problem singular transform " + subtargetpoint.GetNumberOfPoints() + " selected " + maskedset.GetNumberOfPoints());
                continue;
            }
            vtkTransformPolyDataFilter tr = new vtkTransformPolyDataFilter();
            tr.SetInputData((vtkDataObject)subtargetpoint);
            vtkTransform tmptr = new vtkTransform();
            tmptr.SetMatrix(transform);
            tr.SetTransform((vtkAbstractTransform)tmptr);
            tr.Update();
            vtkPointLocator plocator = new vtkPointLocator();
            plocator.SetDataSet((vtkDataSet)this.sourcepoint);
            double mytotald = 0.0;
            vtkPoints test = new vtkPoints();
            test.Initialize();
            test.SetDataTypeToDouble();
            vtkPoints testsource = new vtkPoints();
            testsource.Initialize();
            testsource.SetDataTypeToDouble();
            vtkMath mat = new vtkMath();
            double mybestd = 0.0;
            for (int ip = 0; ip < subtargetpoint.GetNumberOfPoints(); ++ip) {
                int closestpointid = plocator.FindClosestPoint(tr.GetOutput().GetPoint(ip));
                double myd = Math.sqrt(mat.Distance2BetweenPoints(this.sourcepoint.GetPoint(closestpointid), tr.GetOutput().GetPoint(ip)));
                if (!(myd < dist)) continue;
                test.InsertNextPoint(subtargetpoint.GetPoint(ip));
                testsource.InsertNextPoint(this.sourcepoint.GetPoint(closestpointid));
                mybestd += myd;
            }
            if (test.GetNumberOfPoints() < minnbpoint) continue;
            mybestd /= (double)test.GetNumberOfPoints();
            vtkPolyData mypoints = new vtkPolyData();
            mypoints.SetPoints(test);
            vtkVertexGlyphFilter vertexfilter = new vtkVertexGlyphFilter();
            vertexfilter.SetInputData((vtkDataObject)mypoints);
            vertexfilter.Update();
            vtkPolyData copy = new vtkPolyData();
            copy.ShallowCopy((vtkDataObject)vertexfilter.GetOutput());
            vtkPolyData mypoints2 = new vtkPolyData();
            mypoints2.SetPoints(testsource);
            vtkVertexGlyphFilter vertexfilter2 = new vtkVertexGlyphFilter();
            vertexfilter2.SetInputData((vtkDataObject)mypoints2);
            vertexfilter2.Update();
            vtkPolyData testsourcepl = new vtkPolyData();
            testsourcepl.ShallowCopy((vtkDataObject)vertexfilter2.GetOutput());
            myicp.SetTarget((vtkDataSet)copy);
            myicp.SetSource((vtkDataSet)testsourcepl);
            myicp.SetMaximumNumberOfIterations(max_iter_icp);
            myicp.Modified();
            myicp.Update();
            mytotald = 0.0;
            for (int ip = 0; ip < myicp.GetLandmarkTransform().GetSourceLandmarks().GetNumberOfPoints(); ++ip) {
                double myd = Math.sqrt(mat.Distance2BetweenPoints(myicp.GetLandmarkTransform().GetSourceLandmarks().GetPoint(ip), myicp.GetLandmarkTransform().GetTargetLandmarks().GetPoint(ip)));
                mytotald += myd;
            }
            if (!((mytotald /= (double)myicp.GetLandmarkTransform().GetSourceLandmarks().GetNumberOfPoints()) < mybesttotald)) continue;
            System.out.println(" Score bestd " + mybestd + "totald" + mytotald);
            System.out.println(" Nb subtargettotal " + subtargetpoint.GetNumberOfPoints());
            System.out.println(" Nb points kept" + myicp.GetLandmarkTransform().GetSourceLandmarks().GetNumberOfPoints() + " d=" + mytotald);
            System.out.println(" Nb points kept target" + myicp.GetLandmarkTransform().GetTargetLandmarks().GetNumberOfPoints() + " d=" + mytotald);
            this.keptpoint = Math.max(this.keptpoint, myicp.GetLandmarkTransform().GetSourceLandmarks().GetNumberOfPoints());
            mybesttransform.DeepCopy(myicp.GetMatrix());
            mybesttotald = mytotald;
            this.nbpoints = test.GetNumberOfPoints();
            System.out.println(" Nb points kept" + this.nbpoints);
            this.icppointsource.DeepCopy(myicp.GetLandmarkTransform().GetSourceLandmarks());
            this.icppointtarget.DeepCopy(myicp.GetLandmarkTransform().GetTargetLandmarks());
        }
        this.distance = mybesttotald;
        myicp.Delete();
        return mybesttransform;
    }

    private void applyInverseTransformtoTarget(vtkTransform aligned) {
    }

    private vtkTransform ReorientSourcepointandComputeRadius(boolean reverse) {
        vtkPoints test = new vtkPoints();
        for (int i = 0; i < this.sourcepoint.GetNumberOfPoints(); ++i) {
            test.InsertNextPoint(this.sourcepoint.GetPoint(i));
        }
        vtkDoubleArray xArray = new vtkDoubleArray();
        vtkDoubleArray yArray = new vtkDoubleArray();
        vtkDoubleArray zArray = new vtkDoubleArray();
        xArray.SetName("x");
        yArray.SetName("y");
        zArray.SetName("z");
        for (int i = 0; i < test.GetNumberOfPoints(); ++i) {
            double[] p = new double[3];
            test.GetPoint(i, p);
            xArray.InsertNextValue(p[0]);
            yArray.InsertNextValue(p[1]);
            zArray.InsertNextValue(p[2]);
        }
        vtkTable datasetTable = new vtkTable();
        datasetTable.AddColumn((vtkAbstractArray)xArray);
        datasetTable.AddColumn((vtkAbstractArray)yArray);
        datasetTable.AddColumn((vtkAbstractArray)zArray);
        vtkPCAStatistics pcaStatistics = new vtkPCAStatistics();
        pcaStatistics.SetInputData((vtkDataObject)datasetTable);
        pcaStatistics.SetColumnStatus("x", 1);
        pcaStatistics.SetColumnStatus("y", 1);
        pcaStatistics.RequestSelectedColumns();
        pcaStatistics.SetDeriveOption(true);
        pcaStatistics.Update();
        vtkDoubleArray eigenValues = new vtkDoubleArray();
        pcaStatistics.GetEigenvalues(eigenValues);
        vtkDoubleArray evec1 = new vtkDoubleArray();
        pcaStatistics.GetEigenvector(0, evec1);
        double[] vectoraxe = new double[3];
        double[] vectoraxe2 = new double[3];
        double[] axeref = new double[3];
        for (int i = 0; i < 3; ++i) {
            vectoraxe[i] = evec1.GetValue(i);
            vectoraxe2[i] = -evec1.GetValue(i);
        }
        axeref[0] = 100.0;
        vtkMath mymath = new vtkMath();
        double angle = mymath.AngleBetweenVectors(vectoraxe, axeref);
        angle = Math.toDegrees(angle);
        if (reverse) {
            angle = mymath.AngleBetweenVectors(vectoraxe2, axeref);
            angle = Math.toDegrees(angle);
            System.out.println("Reverse angle " + angle);
        } else {
            System.out.println("Not reverse angle " + angle);
        }
        vtkCenterOfMass centerOfMassFilter = new vtkCenterOfMass();
        centerOfMassFilter.SetInputData((vtkPointSet)this.sourcepoint);
        centerOfMassFilter.SetUseScalarsAsWeights(false);
        centerOfMassFilter.Update();
        double[] center = new double[3];
        center = centerOfMassFilter.GetCenter();
        vtkTransformPolyDataFilter tr = new vtkTransformPolyDataFilter();
        tr.SetInputData((vtkDataObject)this.sourcepoint);
        vtkTransform tmptr = new vtkTransform();
        tmptr.Translate(center[0], center[1], 0.0);
        tmptr.RotateZ(-angle);
        tmptr.Translate(-center[0], -center[1], 0.0);
        tr.SetTransform((vtkAbstractTransform)tmptr);
        tr.Update();
        this.sourcepoint = tr.GetOutput();
        vtkPolyData mypoints = new vtkPolyData();
        mypoints.SetPoints(test);
        mypoints.ComputeBounds();
        double[] bounds = mypoints.GetBounds();
        double dimx = bounds[1] - bounds[0];
        double dimy = bounds[3] - bounds[2];
        double dimz = bounds[5] - bounds[4];
        this.radius = 0.0;
        if (dimx > this.radius) {
            this.radius = dimx;
        }
        if (dimy > this.radius) {
            this.radius = dimy;
        }
        if (dimz > this.radius) {
            this.radius = dimz;
        }
        if (Math.sqrt(dimx * dimx + dimy * dimy + dimz * dimz) > this.radius) {
            this.radius = Math.sqrt(dimx * dimx + dimy * dimy + dimz * dimz);
        }
        this.radius /= 2.0;
        System.out.println("Search Radius in um " + this.radius);
        System.out.println("corrected rotation source:" + angle);
        vtkPointLocator plocator = new vtkPointLocator();
        vtkCenterOfMass centerOfMassFilter2 = new vtkCenterOfMass();
        centerOfMassFilter2.SetInputData((vtkPointSet)this.sourcepoint);
        plocator.SetDataSet((vtkDataSet)this.sourcepoint);
        double mytotald = 0.0;
        centerOfMassFilter2.SetUseScalarsAsWeights(false);
        centerOfMassFilter2.Update();
        double[] center2 = new double[3];
        center2 = centerOfMassFilter2.GetCenter();
        vtkIdList listofpoints = new vtkIdList();
        vtkIdList listofpoints2 = new vtkIdList();
        int mypointcenter = plocator.FindClosestPoint(center2);
        plocator.FindPointsWithinRadius(this.radius, this.sourcepoint.GetPoint(mypointcenter), listofpoints);
        plocator.FindPointsWithinRadius(this.radius / 2.0, this.sourcepoint.GetPoint(mypointcenter), listofpoints2);
        this.sourcenbpointsradius1 = listofpoints.GetNumberOfIds();
        this.sourcenbpointsradius2 = listofpoints2.GetNumberOfIds();
        return tmptr;
    }

    private vtkTransform ReorientCandidatesTargetpoints(vtkPolyData newset) {
        vtkPoints test = new vtkPoints();
        for (int i = 0; i < newset.GetNumberOfPoints(); ++i) {
            test.InsertNextPoint(newset.GetPoint(i));
        }
        vtkDoubleArray xArray = new vtkDoubleArray();
        vtkDoubleArray yArray = new vtkDoubleArray();
        vtkDoubleArray zArray = new vtkDoubleArray();
        xArray.SetName("x");
        yArray.SetName("y");
        zArray.SetName("z");
        for (int i = 0; i < test.GetNumberOfPoints(); ++i) {
            double[] p = new double[3];
            test.GetPoint(i, p);
            xArray.InsertNextValue(p[0]);
            yArray.InsertNextValue(p[1]);
            zArray.InsertNextValue(p[2]);
        }
        vtkTable datasetTable = new vtkTable();
        datasetTable.AddColumn((vtkAbstractArray)xArray);
        datasetTable.AddColumn((vtkAbstractArray)yArray);
        datasetTable.AddColumn((vtkAbstractArray)zArray);
        vtkPCAStatistics pcaStatistics = new vtkPCAStatistics();
        pcaStatistics.SetInputData((vtkDataObject)datasetTable);
        pcaStatistics.SetColumnStatus("x", 1);
        pcaStatistics.SetColumnStatus("y", 1);
        pcaStatistics.RequestSelectedColumns();
        pcaStatistics.SetDeriveOption(true);
        pcaStatistics.Update();
        vtkDoubleArray eigenValues = new vtkDoubleArray();
        pcaStatistics.GetEigenvalues(eigenValues);
        vtkDoubleArray evec1 = new vtkDoubleArray();
        pcaStatistics.GetEigenvector(0, evec1);
        double[] vectoraxe = new double[3];
        double[] axeref = new double[3];
        for (int i = 0; i < 3; ++i) {
            vectoraxe[i] = evec1.GetValue(i);
        }
        axeref[0] = 100.0;
        vtkMath mymath = new vtkMath();
        double angle = mymath.AngleBetweenVectors(vectoraxe, axeref);
        angle = Math.toDegrees(angle);
        vtkCenterOfMass centerOfMassFilter = new vtkCenterOfMass();
        centerOfMassFilter.SetInputData((vtkPointSet)newset);
        centerOfMassFilter.SetUseScalarsAsWeights(false);
        centerOfMassFilter.Update();
        double[] center = new double[3];
        center = centerOfMassFilter.GetCenter();
        vtkTransform tmptr = new vtkTransform();
        tmptr.Translate(center[0], center[1], 0.0);
        tmptr.RotateZ(-angle);
        tmptr.Translate(-center[0], -center[1], 0.0);
        return tmptr;
    }

    private void transformVtkInlierTargetPoints(vtkTransform reorientingTargetPoint) {
        vtkPolyData mypoints = new vtkPolyData();
        mypoints.SetPoints(this.icppointtarget);
        vtkVertexGlyphFilter vertexfilter = new vtkVertexGlyphFilter();
        vertexfilter.SetInputData((vtkDataObject)mypoints);
        vtkPolyData newsetoftargetpoints = new vtkPolyData();
        vertexfilter.Update();
        newsetoftargetpoints.ShallowCopy((vtkDataObject)vertexfilter.GetOutput());
        vtkTransformPolyDataFilter trup = new vtkTransformPolyDataFilter();
        trup.SetInputData((vtkDataObject)newsetoftargetpoints);
        trup.SetTransform(reorientingTargetPoint.GetInverse());
        trup.Update();
        this.icppointtarget = trup.GetOutput().GetPoints();
    }

    private void transformVtkInlierSourcePoints(vtkTransform transform) {
        vtkPolyData mypoints = new vtkPolyData();
        mypoints.SetPoints(this.icppointsource);
        vtkVertexGlyphFilter vertexfilter = new vtkVertexGlyphFilter();
        vertexfilter.SetInputData((vtkDataObject)mypoints);
        vtkPolyData newsetoftargetpoints = new vtkPolyData();
        vertexfilter.Update();
        newsetoftargetpoints.ShallowCopy((vtkDataObject)vertexfilter.GetOutput());
        vtkTransformPolyDataFilter trup = new vtkTransformPolyDataFilter();
        trup.SetInputData((vtkDataObject)newsetoftargetpoints);
        trup.SetTransform(transform.GetInverse());
        trup.Update();
        this.icppointsource = trup.GetOutput().GetPoints();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeCSVfile(vtkPoints Landmarks, String filename) {
        BufferedWriter br = null;
        try {
            br = new BufferedWriter(new FileWriter(filename));
            String cvsSplitBy = ";";
            boolean index = true;
            for (int i = 0; i < Landmarks.GetNumberOfPoints(); ++i) {
                double[] coordinates = Landmarks.GetPoint(i);
                String tobewritten = coordinates[0] * 1000.0 + cvsSplitBy + coordinates[1] * 1000.0 + cvsSplitBy + coordinates[2] * 1000.0;
                br.write(tobewritten);
                br.newLine();
            }
            System.out.println("Number of points written in " + filename + ": " + Landmarks.GetNumberOfPoints());
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            if (br != null) {
                try {
                    br.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    private vtkPoints FindCandidatesAreasinTargetMethod2() {
        vtkPointLocator plocator = new vtkPointLocator();
        plocator.SetDataSet((vtkDataSet)this.targetpoint);
        vtkPoints tmpcandidates = new vtkPoints();
        tmpcandidates.Initialize();
        tmpcandidates.SetDataTypeToDouble();
        for (int ip = 0; ip < this.targetpoint.GetNumberOfPoints(); ++ip) {
            vtkIdList listofpoints = new vtkIdList();
            vtkIdList listofpoints2 = new vtkIdList();
            plocator.FindPointsWithinRadius(this.radius, this.targetpoint.GetPoint(ip), listofpoints);
            plocator.FindPointsWithinRadius(this.radius / 2.0, this.targetpoint.GetPoint(ip), listofpoints2);
            int ctarget1 = listofpoints.GetNumberOfIds();
            int ctarget2 = listofpoints2.GetNumberOfIds();
            boolean tobeadded = true;
            if (!((double)ctarget1 / (double)ctarget2 <= 1.2 * (double)this.sourcenbpointsradius1 / (double)this.sourcenbpointsradius2) || !((double)ctarget1 / (double)ctarget2 >= 0.8 * (double)this.sourcenbpointsradius1 / (double)this.sourcenbpointsradius2)) continue;
            if (tmpcandidates.GetNumberOfPoints() > 0) {
                vtkPolyData polydata = new vtkPolyData();
                vtkPoints candidates2 = new vtkPoints();
                candidates2.ShallowCopy(tmpcandidates);
                polydata.SetPoints(candidates2);
                vtkPointLocator plocatorcandidates = new vtkPointLocator();
                plocatorcandidates.SetDataSet((vtkDataSet)polydata);
                vtkIdList listofpointsalreadycandidates = new vtkIdList();
                plocatorcandidates.FindPointsWithinRadius(this.radius / this.minspacingtotest, this.targetpoint.GetPoint(ip), listofpointsalreadycandidates);
                if (listofpointsalreadycandidates.GetNumberOfIds() > 0) {
                    tobeadded = false;
                }
            }
            if (!tobeadded) continue;
            tmpcandidates.InsertNextPoint(this.targetpoint.GetPoint(ip));
        }
        vtkPoints candidates2 = new vtkPoints();
        candidates2.ShallowCopy(tmpcandidates);
        return candidates2;
    }

    private vtkPoints FindCandidatesAreasinTarget() {
        vtkPointLocator plocator = new vtkPointLocator();
        plocator.SetDataSet((vtkDataSet)this.targetpoint);
        vtkPoints tmpcandidates = new vtkPoints();
        tmpcandidates.Initialize();
        tmpcandidates.SetDataTypeToDouble();
        for (int ip = 0; ip < this.targetpoint.GetNumberOfPoints(); ++ip) {
            vtkIdList listofpoints = new vtkIdList();
            vtkIdList listofpoints2 = new vtkIdList();
            plocator.FindPointsWithinRadius(this.radius, this.targetpoint.GetPoint(ip), listofpoints);
            plocator.FindPointsWithinRadius(this.radius / 2.0, this.targetpoint.GetPoint(ip), listofpoints2);
            int ctarget1 = listofpoints.GetNumberOfIds();
            int ctarget2 = listofpoints2.GetNumberOfIds();
            boolean tobeadded = true;
            if (!((double)ctarget1 <= 1.3 * (double)this.sourcenbpointsradius1) || !((double)ctarget1 >= 0.7 * (double)this.sourcenbpointsradius1) || !((double)ctarget2 <= 1.3 * (double)this.sourcenbpointsradius2) || !((double)ctarget2 >= 0.7 * (double)this.sourcenbpointsradius2)) continue;
            if (tmpcandidates.GetNumberOfPoints() > 0) {
                vtkPolyData polydata = new vtkPolyData();
                vtkPoints candidates2 = new vtkPoints();
                candidates2.ShallowCopy(tmpcandidates);
                polydata.SetPoints(candidates2);
                vtkPointLocator plocatorcandidates = new vtkPointLocator();
                plocatorcandidates.SetDataSet((vtkDataSet)polydata);
                vtkIdList listofpointsalreadycandidates = new vtkIdList();
                plocatorcandidates.FindPointsWithinRadius(this.radius / this.minspacingtotest, this.targetpoint.GetPoint(ip), listofpointsalreadycandidates);
                if (listofpointsalreadycandidates.GetNumberOfIds() > 0) {
                    tobeadded = false;
                }
            }
            if (!tobeadded) continue;
            tmpcandidates.InsertNextPoint(this.targetpoint.GetPoint(ip));
        }
        vtkPoints candidates = new vtkPoints();
        candidates.ShallowCopy(tmpcandidates);
        return candidates;
    }

    private void LaunchReadytoUseEcCLEM() {
        Sequence newtarget = SequenceUtil.getCopy((Sequence)((Sequence)this.source.getValue()));
        vtkPolyData mypoints = new vtkPolyData();
        mypoints.SetPoints(this.icppointsource);
        this.CreateRoifromPoints(newtarget, mypoints, Color.YELLOW, "ICP target");
        newtarget.setName("Target");
        this.addSequence(newtarget);
        Sequence newsource = SequenceUtil.getCopy((Sequence)this.sequence4);
        newsource.setName("Source");
        vtkPolyData mypoints2 = new vtkPolyData();
        mypoints2.SetPoints(this.icppointtarget);
        this.CreateRoifromPoints(newsource, mypoints2, Color.YELLOW, "ICP source");
        this.addSequence(newsource);
        new ToolTipFrame("<html><br> Use source and target as named. Loaded points are the paired point actually used for the registration. <br> If you want to do the contrary check your icy installation for .csv and load the non reverse file</html>");
        for (PluginDescriptor pluginDescriptor : PluginLoader.getPlugins()) {
            if (pluginDescriptor.getSimpleClassName().compareToIgnoreCase("Ec_clem") != 0) continue;
            PluginLauncher.start((PluginDescriptor)pluginDescriptor);
        }
    }

    private void writeTransfo(Sequence imagesource, Sequence imagetarget, vtkTransform myvtktransform) {
        vtkMatrix4x4 transfo = myvtktransform.GetMatrix();
        String name = imagesource.getFilename() + "_TRANSFOAUTO.xml";
        File XMLFile = new File(name);
        Document document = XMLUtil.createDocument((boolean)true);
        Element transfoElement = XMLUtil.addElement((Node)document.getDocumentElement(), (String)"TargetSize");
        XMLUtil.setAttributeIntValue((Element)transfoElement, (String)"width", (int)imagetarget.getWidth());
        XMLUtil.setAttributeIntValue((Element)transfoElement, (String)"height", (int)imagetarget.getHeight());
        XMLUtil.setAttributeDoubleValue((Element)transfoElement, (String)"sx", (double)imagetarget.getPixelSizeX());
        XMLUtil.setAttributeDoubleValue((Element)transfoElement, (String)"sy", (double)imagetarget.getPixelSizeY());
        XMLUtil.setAttributeDoubleValue((Element)transfoElement, (String)"sz", (double)imagetarget.getPixelSizeZ());
        XMLUtil.setAttributeIntValue((Element)transfoElement, (String)"nz", (int)imagetarget.getSizeZ());
        XMLUtil.setAttributeIntValue((Element)transfoElement, (String)"auto", (int)1);
        System.out.println("Transformation will be saved as " + XMLFile.getPath());
        transfoElement = XMLUtil.addElement((Node)document.getDocumentElement(), (String)"MatrixTransformation");
        XMLUtil.setAttributeIntValue((Element)transfoElement, (String)"order", (int)0);
        XMLUtil.setAttributeDoubleValue((Element)transfoElement, (String)"m00", (double)transfo.GetElement(0, 0));
        XMLUtil.setAttributeDoubleValue((Element)transfoElement, (String)"m01", (double)transfo.GetElement(0, 1));
        XMLUtil.setAttributeDoubleValue((Element)transfoElement, (String)"m02", (double)transfo.GetElement(0, 2));
        XMLUtil.setAttributeDoubleValue((Element)transfoElement, (String)"m03", (double)transfo.GetElement(0, 3));
        XMLUtil.setAttributeDoubleValue((Element)transfoElement, (String)"m10", (double)transfo.GetElement(1, 0));
        XMLUtil.setAttributeDoubleValue((Element)transfoElement, (String)"m11", (double)transfo.GetElement(1, 1));
        XMLUtil.setAttributeDoubleValue((Element)transfoElement, (String)"m12", (double)transfo.GetElement(1, 2));
        XMLUtil.setAttributeDoubleValue((Element)transfoElement, (String)"m13", (double)transfo.GetElement(1, 3));
        XMLUtil.setAttributeDoubleValue((Element)transfoElement, (String)"m20", (double)transfo.GetElement(2, 0));
        XMLUtil.setAttributeDoubleValue((Element)transfoElement, (String)"m21", (double)transfo.GetElement(2, 1));
        XMLUtil.setAttributeDoubleValue((Element)transfoElement, (String)"m22", (double)transfo.GetElement(2, 2));
        XMLUtil.setAttributeDoubleValue((Element)transfoElement, (String)"m23", (double)transfo.GetElement(2, 3));
        XMLUtil.setAttributeDoubleValue((Element)transfoElement, (String)"m30", (double)0.0);
        XMLUtil.setAttributeDoubleValue((Element)transfoElement, (String)"m31", (double)0.0);
        XMLUtil.setAttributeDoubleValue((Element)transfoElement, (String)"m32", (double)0.0);
        XMLUtil.setAttributeDoubleValue((Element)transfoElement, (String)"m33", (double)1.0);
        XMLUtil.setAttributeValue((Element)transfoElement, (String)"process_date", (String)new Date().toString());
        XMLUtil.saveDocument((Document)document, (File)XMLFile);
        System.out.println("Transformation matrix as been saved as " + XMLFile.getPath());
        System.out.println("If there is no path indicated, it means it is in your ICY installation path");
    }

    private List<Integer> generateSmartRandomPointsList(vtkPolyData subtargetpoint, int nbpointransac, int orinbpoint) {
        ArrayList<Integer> myCoords = new ArrayList<Integer>();
        if (nbpointransac >= orinbpoint) {
            for (int i = 0; i < orinbpoint; ++i) {
                myCoords.add(i);
            }
        } else {
            Random rn = new Random();
            vtkPointLocator targetlocator = new vtkPointLocator();
            targetlocator.SetDataSet((vtkDataSet)subtargetpoint);
            while (myCoords.size() < nbpointransac) {
                Integer idx = rn.nextInt(orinbpoint);
                if (myCoords.contains(idx)) continue;
                vtkIdList result = new vtkIdList();
                targetlocator.FindClosestNPoints(nbpointransac / 10 + 1, subtargetpoint.GetPoint(idx.intValue()), result);
                myCoords.add(idx);
                for (int i = 0; i < result.GetNumberOfIds(); ++i) {
                    if (myCoords.size() >= nbpointransac || myCoords.contains(result.GetId(i))) continue;
                    myCoords.add(result.GetId(i));
                }
            }
        }
        return myCoords;
    }

    protected void initialize() {
        new ToolTipFrame("<html><br> You need to first have identified ROI on both images, only their center will be considered.<br> The plugin <b>Spot detector</b>  is a good choice here,  <br> just make sure to have activated <b>Export to Roi</b> as output;<br>or eC-CLEM tool <b>ConvertBinaryToPointRoi</b><br><b>IMPORTANT: Check your metadata </b> first as it will be used by MyAutoFinder.<br> <li> <b>About the same content in both n-D images </b> :<br> This option will try to fit the full content of the image, assuming you have similar detections<br>  </li><br> <li> <b>Find Small Part in Bigger View (reverse or not)</b> : <br> The purpose here is to find an image position (typically EM) <br> on a larger field of view (typically LM). The prealignment will be different </li><br> <li> <b>Max Error in microns:  </b> :<br> A pointshould have a distance to its closest matching point below this value<br> in order not to be considered as an outlier. Increase if no transformation was found. <br> Rule of Thumb: about 10 pixels </li><br> <li> <b>Percentage of target point to keep:  </b> :<br> This is the minimum percentage of point that have to match: 90% means almost no outliers<br> 50% or less if the number of detection are very different. 70% is usually a good trade off<br>  </li><br> See the online tutorials for further example or the wizard (I need help). </li><br></html>", "helpautofinder");
        this.setTimeDisplay(true);
        this.addEzComponent((EzComponent)this.versioninfo);
        this.target = new EzVarSequence("Select Target Image with Rois on it");
        this.source = new EzVarSequence("Select Source Image with Rois on it");
        this.source.setToolTipText("will be tentatively positionned on target image");
        this.addComponent(new helpButton(this));
        this.addEzComponent((EzComponent)this.source);
        this.addEzComponent((EzComponent)this.target);
        this.pixelsizezsource.setToolTipText("Z voxel size");
        this.pixelsizeztarget.setToolTipText("Z voxel size");
        EzGroup grp = new EzGroup("Metadata to check", new EzComponent[]{this.pixelsizexysource, this.pixelsizezsource, this.pixelsizexytarget, this.pixelsizeztarget});
        this.addEzComponent((EzComponent)grp);
        this.source.addVarChangeListener((EzVarListener)new EzVarListener<Sequence>(){

            public void variableChanged(EzVar<Sequence> source, Sequence newValue) {
                if (newValue != null) {
                    if (newValue.getPixelSizeZ() <= 0.0) {
                        newValue.setPixelSizeZ(1.0);
                    }
                    EcClemAutoFinder.this.pixelsizexysource.setValue((Object)(newValue.getPixelSizeX() * 1000.0));
                    EcClemAutoFinder.this.pixelsizezsource.setValue((Object)(newValue.getPixelSizeZ() * 1000.0));
                    EcClemAutoFinder.this.distvar.setValue((Object)Math.max(0.01 * (Double)EcClemAutoFinder.this.pixelsizexysource.getValue(), 0.01 * (Double)EcClemAutoFinder.this.pixelsizexytarget.getValue()));
                }
            }
        });
        this.pixelsizexysource.addVarChangeListener((EzVarListener)new EzVarListener<Double>(){

            public void variableChanged(EzVar<Double> sourced, Double newValue) {
                if (EcClemAutoFinder.this.source.getValue() != null) {
                    ((Sequence)EcClemAutoFinder.this.source.getValue()).setPixelSizeX(newValue / 1000.0);
                    ((Sequence)EcClemAutoFinder.this.source.getValue()).setPixelSizeY(newValue / 1000.0);
                    EcClemAutoFinder.this.distvar.setValue((Object)Math.max(0.01 * (Double)EcClemAutoFinder.this.pixelsizexysource.getValue(), 0.01 * (Double)EcClemAutoFinder.this.pixelsizexytarget.getValue()));
                }
            }
        });
        this.pixelsizexytarget.addVarChangeListener((EzVarListener)new EzVarListener<Double>(){

            public void variableChanged(EzVar<Double> sourced, Double newValue) {
                if (EcClemAutoFinder.this.target.getValue() != null) {
                    ((Sequence)EcClemAutoFinder.this.target.getValue()).setPixelSizeX(newValue / 1000.0);
                    ((Sequence)EcClemAutoFinder.this.target.getValue()).setPixelSizeY(newValue / 1000.0);
                    EcClemAutoFinder.this.distvar.setValue((Object)Math.max(0.01 * (Double)EcClemAutoFinder.this.pixelsizexysource.getValue(), 0.01 * (Double)EcClemAutoFinder.this.pixelsizexytarget.getValue()));
                }
            }
        });
        this.pixelsizezsource.addVarChangeListener((EzVarListener)new EzVarListener<Double>(){

            public void variableChanged(EzVar<Double> sourced, Double newValue) {
                if (EcClemAutoFinder.this.source.getValue() != null) {
                    ((Sequence)EcClemAutoFinder.this.source.getValue()).setPixelSizeZ(newValue / 1000.0);
                }
            }
        });
        this.pixelsizeztarget.addVarChangeListener((EzVarListener)new EzVarListener<Double>(){

            public void variableChanged(EzVar<Double> sourced, Double newValue) {
                if (EcClemAutoFinder.this.target.getValue() != null) {
                    ((Sequence)EcClemAutoFinder.this.target.getValue()).setPixelSizeZ(newValue / 1000.0);
                }
            }
        });
        this.target.addVarChangeListener((EzVarListener)new EzVarListener<Sequence>(){

            public void variableChanged(EzVar<Sequence> source, Sequence newValue) {
                if (newValue != null) {
                    if (newValue.getPixelSizeZ() <= 0.0) {
                        newValue.setPixelSizeZ(1.0);
                    }
                    EcClemAutoFinder.this.pixelsizexytarget.setValue((Object)(newValue.getPixelSizeX() * 1000.0));
                    EcClemAutoFinder.this.pixelsizeztarget.setValue((Object)(newValue.getPixelSizeZ() * 1000.0));
                    EcClemAutoFinder.this.distvar.setValue((Object)Math.max(0.01 * (Double)EcClemAutoFinder.this.pixelsizexysource.getValue(), 0.01 * (Double)EcClemAutoFinder.this.pixelsizexytarget.getValue()));
                }
            }
        });
        this.addEzComponent((EzComponent)this.choicemode);
        this.addEzComponent((EzComponent)this.showtarget);
        this.addEzComponent((EzComponent)this.exporttoecclem);
        this.distvar.setToolTipText("This distance will the one used to test the candidates");
        this.proportion.setToolTipText("This is the proportion of target point that will be tested at each iteration");
        this.addEzComponent((EzComponent)this.distvar);
        this.addEzComponent((EzComponent)this.proportion);
        this.addEzComponent((EzComponent)this.affine);
    }

    public class MyCandidatesOverlay
    extends Overlay {
        double candidatex;
        double candidatey;
        double radius;
        Color color;

        public MyCandidatesOverlay(int number) {
            super("candidate " + number);
        }

        public void paint(Graphics2D g, Sequence seq, IcyCanvas canvas) {
            g.setColor(this.color);
            g.setStroke(new BasicStroke(5.0f));
            g.drawOval((int)(this.candidatex - this.radius / 2.0), (int)(this.candidatey - this.radius / 2.0), (int)this.radius, (int)this.radius);
        }

        public void setParameters(double candidatex, double candidatey, double radius) {
            this.candidatex = candidatex;
            this.candidatey = candidatey;
            this.color = Color.CYAN;
            this.radius = radius;
        }

        public void setHot() {
            this.color = Color.ORANGE;
        }
    }
}

