/*
 * Decompiled with CFR 0.152.
 */
package plugins.perrine.ec_clem.ec_clem.error.fitzpatrick;

import Jama.Matrix;
import javax.inject.Inject;
import org.apache.commons.math3.stat.descriptive.moment.Mean;
import plugins.perrine.ec_clem.ec_clem.fiducialset.dataset.point.Point;

public class TREComputer {
    private double expectedSquareFLE;
    private double n;
    private double[] f;
    private Matrix eigenVectors;
    private Matrix barycentre;

    @Inject
    public TREComputer(double n, double[] f, Matrix eigenVectors, Matrix barycentre, double expectedSquareFLE) {
        this.n = n;
        this.f = f;
        this.eigenVectors = eigenVectors;
        this.barycentre = barycentre;
        this.expectedSquareFLE = expectedSquareFLE;
    }

    public double getN() {
        return this.n;
    }

    public double[] getF() {
        return this.f;
    }

    public double getExpectedSquareTRE(Point point) {
        int i;
        Mean mean = new Mean();
        double[] d = new double[point.getDimension()];
        for (i = 0; i < point.getDimension(); ++i) {
            int n = i;
            d[n] = d[n] + point.getSquareDistance(this.eigenVectors.getMatrix(0, this.eigenVectors.getRowDimension() - 1, i, i), this.barycentre);
        }
        mean.clear();
        for (i = 0; i < point.getDimension(); ++i) {
            mean.increment(d[i] / this.f[i]);
        }
        return Math.sqrt(this.expectedSquareFLE * (1.0 / this.n + 1.0 / (double)point.getDimension() * mean.getResult()));
    }
}

