/*
 * Decompiled with CFR 0.152.
 */
package plugins.perrine.ec_clem.ec_clem.error.fitzpatrick;

import Jama.Matrix;
import javax.inject.Inject;
import org.apache.commons.math3.stat.descriptive.moment.Mean;
import plugins.perrine.ec_clem.ec_clem.error.fitzpatrick.FLEComputer;
import plugins.perrine.ec_clem.ec_clem.error.fitzpatrick.FREComputer;
import plugins.perrine.ec_clem.ec_clem.error.fitzpatrick.InertiaMatrixComputer;
import plugins.perrine.ec_clem.ec_clem.error.fitzpatrick.TREComputer;
import plugins.perrine.ec_clem.ec_clem.fiducialset.dataset.Dataset;
import plugins.perrine.ec_clem.ec_clem.fiducialset.dataset.DatasetFactory;
import plugins.perrine.ec_clem.ec_clem.transformation.schema.TransformationSchema;
import plugins.perrine.ec_clem.ec_clem.transformation.schema.TransformationSchemaFactory;
import plugins.perrine.ec_clem.ec_clem.workspace.Workspace;

public class TREComputerFactory {
    private InertiaMatrixComputer inertiaMatrixComputer;
    private FREComputer freComputer;
    private FLEComputer fleComputer;
    private TransformationSchemaFactory transformationSchemaFactory;
    private DatasetFactory datasetFactory;

    @Inject
    public TREComputerFactory(InertiaMatrixComputer inertiaMatrixComputer, FREComputer freComputer, FLEComputer fleComputer, TransformationSchemaFactory transformationSchemaFactory, DatasetFactory datasetFactory) {
        this.inertiaMatrixComputer = inertiaMatrixComputer;
        this.freComputer = freComputer;
        this.fleComputer = fleComputer;
        this.transformationSchemaFactory = transformationSchemaFactory;
        this.datasetFactory = datasetFactory;
    }

    public TREComputer getFrom(Workspace workspace) {
        if (workspace.getTransformationSchema() != null) {
            return this.getFrom(workspace.getTransformationSchema());
        }
        return this.getFrom(this.transformationSchemaFactory.getFrom(workspace));
    }

    public TREComputer getFrom(TransformationSchema transformationSchema) {
        return this.getFrom(this.datasetFactory.getFrom(transformationSchema.getFiducialSet().getSourceDataset(), transformationSchema), transformationSchema.getFiducialSet().getTargetDataset());
    }

    private TREComputer getFrom(Dataset sourceTransformedDataset, Dataset targetDataset) {
        Matrix barycentre = targetDataset.getBarycentre().getMatrix();
        Dataset clone = targetDataset.clone();
        clone.substractBarycentre();
        Matrix eigenVectors = this.inertiaMatrixComputer.getInertiaMatrix(clone).eig().getV();
        double[] f = this.getF(clone, eigenVectors);
        return new TREComputer(targetDataset.getN(), f, eigenVectors, barycentre, this.fleComputer.getExpectedSquareFLE(this.freComputer.getExpectedSquareFRE(sourceTransformedDataset, targetDataset), targetDataset.getN()));
    }

    public TREComputer getFrom(Dataset dataset, double expectedSquareFLE) {
        Matrix barycentre = dataset.getBarycentre().getMatrix();
        Matrix eigenVectors = this.inertiaMatrixComputer.getInertiaMatrix(dataset).eig().getV();
        double[] f = this.getF(dataset, eigenVectors);
        return new TREComputer(dataset.getN(), f, eigenVectors, barycentre, expectedSquareFLE);
    }

    private double[] getF(Dataset dataset, Matrix eigenVectors) {
        Mean mean = new Mean();
        double[] f = new double[dataset.getDimension()];
        int j = 0;
        while (j < dataset.getDimension()) {
            mean.clear();
            for (int i = 0; i < dataset.getN(); ++i) {
                mean.increment(dataset.getPoint(i).getSquareDistance(eigenVectors.getMatrix(0, eigenVectors.getRowDimension() - 1, j, j), dataset.getBarycentre().getMatrix()));
            }
            int n = j++;
            f[n] = f[n] + mean.getResult();
        }
        return f;
    }
}

