/*
 * Decompiled with CFR 0.152.
 */
package plugins.perrine.ec_clem.ec_clem.registration;

import Jama.Matrix;
import javax.inject.Inject;
import plugins.perrine.ec_clem.ec_clem.fiducialset.FiducialSet;
import plugins.perrine.ec_clem.ec_clem.matrix.MatrixUtil;
import plugins.perrine.ec_clem.ec_clem.registration.RegistrationParameter;
import plugins.perrine.ec_clem.ec_clem.registration.RegistrationParameterComputer;
import plugins.perrine.ec_clem.ec_clem.transformation.AffineTransformation;

public class AffineRegistrationParameterComputer
implements RegistrationParameterComputer {
    private MatrixUtil matrixUtil;

    @Inject
    public AffineRegistrationParameterComputer(MatrixUtil matrixUtil) {
        this.matrixUtil = matrixUtil;
    }

    @Override
    public RegistrationParameter compute(FiducialSet fiducialSet) {
        Matrix A = fiducialSet.getSourceDataset().getHomogeneousMatrixLeft();
        Matrix B = fiducialSet.getTargetDataset().getMatrix();
        Matrix result = this.matrixUtil.pseudoInverse(A.transpose().times(A)).times(A.transpose()).times(B);
        AffineTransformation affineTransformation = new AffineTransformation(result.getMatrix(1, result.getRowDimension() - 1, 0, result.getColumnDimension() - 1).transpose(), result.getMatrix(0, 0, 0, result.getColumnDimension() - 1).transpose());
        Matrix residuals = fiducialSet.getTargetDataset().getMatrix().minus(affineTransformation.apply(fiducialSet.getSourceDataset()).getMatrix());
        Matrix covariance = residuals.transpose().times(residuals).times(1.0 / (double)fiducialSet.getN());
        return new RegistrationParameter(affineTransformation, covariance, this.getLogLikelihood(residuals, covariance));
    }

    protected double getLogLikelihood(Matrix residuals, Matrix covariance) {
        Matrix inverseCovariance = this.matrixUtil.pseudoInverse(covariance);
        double sum = 0.0;
        for (int i = 0; i < residuals.getRowDimension(); ++i) {
            Matrix current = residuals.getMatrix(i, i, 0, residuals.getColumnDimension() - 1);
            Matrix times = current.times(inverseCovariance).times(current.transpose());
            assert (times.getRowDimension() == 1);
            assert (times.getColumnDimension() == 1);
            sum += times.get(0, 0);
        }
        return Math.log(1.0 / Math.sqrt(Math.pow(Math.PI * 2, residuals.getColumnDimension()) * covariance.det())) * (double)residuals.getRowDimension() - sum / 2.0;
    }
}

