/*
 * Decompiled with CFR 0.152.
 */
package plugins.perrine.ec_clem.ec_clem.roi;

import icy.canvas.IcyCanvas;
import icy.roi.ROI;
import icy.sequence.Sequence;
import icy.sequence.SequenceListener;
import java.util.List;
import javax.inject.Inject;
import plugins.perrine.ec_clem.ec_clem.error.ellipse.ConfidenceEllipseFactory;
import plugins.perrine.ec_clem.ec_clem.fiducialset.dataset.Dataset;
import plugins.perrine.ec_clem.ec_clem.fiducialset.dataset.DatasetFactory;
import plugins.perrine.ec_clem.ec_clem.roi.PointType;
import plugins.perrine.ec_clem.ec_clem.roi.RoiFactory;
import plugins.perrine.ec_clem.ec_clem.sequence.SequenceSizeFactory;
import plugins.perrine.ec_clem.ec_clem.sequence_listener.RoiListenerManager;
import plugins.perrine.ec_clem.ec_clem.sequence_listener.SequenceListenerUtil;
import plugins.perrine.ec_clem.ec_clem.transformation.schema.TransformationSchema;

public class RoiUpdater {
    private DatasetFactory datasetFactory;
    private RoiFactory roiFactory;
    private SequenceListenerUtil sequenceListenerUtil;
    private RoiListenerManager roiListenerManager;
    private ConfidenceEllipseFactory confidenceEllipseFactory;
    private SequenceSizeFactory sequenceSizeFactory;

    @Inject
    public RoiUpdater(DatasetFactory datasetFactory, RoiFactory roiFactory, SequenceListenerUtil sequenceListenerUtil, RoiListenerManager roiListenerManager, ConfidenceEllipseFactory confidenceEllipseFactory, SequenceSizeFactory sequenceSizeFactory) {
        this.datasetFactory = datasetFactory;
        this.roiFactory = roiFactory;
        this.sequenceListenerUtil = sequenceListenerUtil;
        this.roiListenerManager = roiListenerManager;
        this.confidenceEllipseFactory = confidenceEllipseFactory;
        this.sequenceSizeFactory = sequenceSizeFactory;
    }

    public void updateRoi(Dataset dataset, Sequence sequence) {
        Dataset pixelDataset = this.datasetFactory.toPixel(dataset, sequence);
        this.clear(sequence, dataset.getPointType());
        List<SequenceListener> sequenceListeners = this.roiListenerManager.removeAll(sequence);
        for (int i = 0; i < pixelDataset.getN(); ++i) {
            ROI roi = this.roiFactory.getRoiFrom(this.roiFactory.getFrom(pixelDataset.getPoint(i)), i + 1, dataset.getPointType());
            sequence.addROI(roi);
        }
        this.sequenceListenerUtil.addListeners(sequence, sequenceListeners);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateErrorRoi(Dataset dataset, TransformationSchema transformationSchema, Sequence sequence) {
        List<SequenceListener> sequenceListeners = this.roiListenerManager.removeAll(sequence);
        try {
            for (int i = 0; i < dataset.getN(); ++i) {
                ROI ellipseROI = this.roiFactory.getFrom(this.confidenceEllipseFactory.getFrom(dataset.getPoint(i), transformationSchema, 0.95), this.sequenceSizeFactory.getFrom(sequence));
                ellipseROI.setName(String.format("%s_%s_%d", PointType.PREDICTED_ERROR.name(), dataset.getPointType().name(), i + 1));
                sequence.addROI(ellipseROI);
            }
        }
        finally {
            this.sequenceListenerUtil.addListeners(sequence, sequenceListeners);
        }
    }

    public void updateMeasuredErrorRoi(Dataset sourceDataset, Dataset targetDataset, Sequence sequence) {
        assert (sourceDataset.getDimension() == targetDataset.getDimension());
        List<SequenceListener> sequenceListeners = this.roiListenerManager.removeAll(sequence);
        for (int i = 0; i < sourceDataset.getN(); ++i) {
            ROI lineROI = this.roiFactory.getFrom(sourceDataset.getPoint(i), targetDataset.getPoint(i));
            lineROI.setName(String.format("%s_%s_%d", PointType.MEASURED_ERROR.name(), sourceDataset.getPointType().name(), i + 1));
            sequence.addROI(lineROI);
        }
        this.sequenceListenerUtil.addListeners(sequence, sequenceListeners);
    }

    public void clear(Sequence sequence, PointType type) {
        sequence.removeROIs(this.roiFactory.getFrom(sequence, type), false);
    }

    public void setLayersVisible(Sequence sequence, PointType pointType, boolean visible) {
        List<ROI> roiList = this.roiFactory.getFrom(sequence, pointType);
        for (ROI roi : roiList) {
            this.setLayersVisible(roi, visible);
        }
    }

    private void setLayersVisible(ROI roi, boolean visible) {
        List attachedCanvas = roi.getOverlay().getAttachedCanvas();
        for (IcyCanvas canvas : attachedCanvas) {
            canvas.getLayer(roi).setVisible(visible);
        }
    }
}

