/*
 * Decompiled with CFR 0.152.
 */
package plugins.perrine.ec_clem.ec_clem.sequence;

import icy.common.listener.ProgressListener;
import icy.gui.frame.progress.ProgressFrame;
import icy.sequence.Sequence;
import icy.sequence.SequenceUtil;
import icy.type.DataType;
import icy.vtk.VtkUtil;
import javax.inject.Inject;
import plugins.perrine.ec_clem.ec_clem.sequence.DimensionSize;
import plugins.perrine.ec_clem.ec_clem.sequence.SequenceSize;
import plugins.perrine.ec_clem.ec_clem.sequence.VtkDataSequenceSupplier;
import plugins.perrine.ec_clem.ec_clem.sequence.VtkImageGridSourceFactory;
import vtk.vtkDataArray;
import vtk.vtkImageGridSource;

public class SequenceFactory {
    private VtkImageGridSourceFactory vtkImageGridSourceFactory;

    @Inject
    public SequenceFactory(VtkImageGridSourceFactory vtkImageGridSourceFactory) {
        this.vtkImageGridSourceFactory = vtkImageGridSourceFactory;
    }

    public Sequence getMergeSequence(Sequence source, Sequence target) {
        ProgressFrame progressFrame = new ProgressFrame("Merge sequence");
        Sequence result = SequenceUtil.concatC((Sequence[])new Sequence[]{SequenceUtil.convertToType((Sequence)source, (DataType)target.getDataType_(), (boolean)true), target}, (boolean)false, (boolean)false, (ProgressListener)progressFrame);
        result.setName("Merged");
        progressFrame.close();
        return result;
    }

    public Sequence getGridSequence(int xSize, int ySize, int zSize, double spacingX, double spacingY, double spacingZ) {
        vtkImageGridSource sourceGrid = this.vtkImageGridSourceFactory.getFrom(xSize, ySize, zSize, spacingX, spacingY, spacingZ);
        Sequence grid = new Sequence();
        VtkDataSequenceSupplier vtkDataSequenceSupplier = new VtkDataSequenceSupplier(grid, DataType.UBYTE, 0, 1, VtkUtil.getJavaArray((vtkDataArray)sourceGrid.GetOutput().GetPointData().GetScalars()), xSize, ySize, zSize, 1, spacingX, spacingY, spacingZ);
        grid = vtkDataSequenceSupplier.get();
        grid.setName("Grid");
        return grid;
    }

    public Sequence getFrom(SequenceSize sequenceSize) {
        Sequence newSequence = new Sequence();
        for (DimensionSize dimensionSize : sequenceSize.getDimensions()) {
            switch (dimensionSize.getDimensionId()) {
                case X: {
                    newSequence.setPixelSizeX(dimensionSize.getPixelSizeInMicrometer());
                    break;
                }
                case Y: {
                    newSequence.setPixelSizeY(dimensionSize.getPixelSizeInMicrometer());
                    break;
                }
                case Z: {
                    newSequence.setPixelSizeZ(dimensionSize.getPixelSizeInMicrometer());
                }
            }
        }
        return newSequence;
    }
}

