/*
 * Decompiled with CFR 0.152.
 */
package plugins.perrine.ec_clem.ec_clem.storage.transformation.csv;

import Jama.Matrix;
import java.io.IOException;
import javax.inject.Inject;
import org.apache.commons.csv.CSVFormat;
import org.apache.commons.csv.CSVPrinter;
import plugins.perrine.ec_clem.ec_clem.storage.Formatter;

public class MatrixToCsvFormatter
implements Formatter<Matrix> {
    @Inject
    public MatrixToCsvFormatter() {
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public String format(Matrix matrix) {
        StringBuilder stringBuilder = new StringBuilder();
        try (CSVPrinter printer = new CSVPrinter(stringBuilder, CSVFormat.DEFAULT);){
            for (int i = 0; i < matrix.getRowDimension(); ++i) {
                for (int j = 0; j < matrix.getRowDimension(); ++j) {
                    printer.print(matrix.get(i, j));
                }
                printer.println();
            }
            printer.flush();
            String string = stringBuilder.toString();
            return string;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

