/*
 * Decompiled with CFR 0.152.
 */
package plugins.perrine.ec_clem.ec_clem.storage.transformation_schema.writer;

import icy.util.XMLUtil;
import java.time.ZonedDateTime;
import javax.inject.Inject;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import plugins.perrine.ec_clem.ec_clem.fiducialset.dataset.Dataset;
import plugins.perrine.ec_clem.ec_clem.fiducialset.dataset.point.Point;
import plugins.perrine.ec_clem.ec_clem.sequence.DimensionSize;
import plugins.perrine.ec_clem.ec_clem.sequence.SequenceName;
import plugins.perrine.ec_clem.ec_clem.sequence.SequenceSize;
import plugins.perrine.ec_clem.ec_clem.storage.transformation_schema.XmlTransformation;
import plugins.perrine.ec_clem.ec_clem.transformation.schema.TransformationSchema;

public class XmlTransformationWriter {
    @Inject
    public XmlTransformationWriter() {
    }

    public void write(Document document, TransformationSchema transformationSchema) {
        Element transformationElement = XMLUtil.addElement((Node)document.getDocumentElement(), (String)XmlTransformation.transformationElementName);
        transformationElement.setAttribute(XmlTransformation.transformationTypeAttributeName, transformationSchema.getTransformationType().name());
        transformationElement.setAttribute(XmlTransformation.transformationNoiseModelAttributeName, transformationSchema.getNoiseModel().name());
        transformationElement.setAttribute(XmlTransformation.transformationDateAttributeName, ZonedDateTime.now().toString());
        this.write(transformationSchema.getSourceSize(), "source", transformationElement);
        this.write(transformationSchema.getTargetSize(), "target", transformationElement);
        this.write(transformationSchema.getSourceName(), "source", transformationElement);
        this.write(transformationSchema.getTargetName(), "target", transformationElement);
        this.write(transformationSchema.getFiducialSet().getSourceDataset(), "source", transformationElement);
        this.write(transformationSchema.getFiducialSet().getTargetDataset(), "target", transformationElement);
    }

    public void writeSequenceInfoOnly(Document document, TransformationSchema transformationSchema) {
        Element transformationElement = XMLUtil.addElement((Node)document.getDocumentElement(), (String)XmlTransformation.transformationElementName);
        transformationElement.setAttribute(XmlTransformation.transformationTypeAttributeName, transformationSchema.getTransformationType().name());
        transformationElement.setAttribute(XmlTransformation.transformationNoiseModelAttributeName, transformationSchema.getNoiseModel().name());
        transformationElement.setAttribute(XmlTransformation.transformationDateAttributeName, ZonedDateTime.now().toString());
        this.write(transformationSchema.getSourceSize(), "source", transformationElement);
        this.write(transformationSchema.getTargetSize(), "target", transformationElement);
        this.write(transformationSchema.getSourceName(), "source", transformationElement);
        this.write(transformationSchema.getTargetName(), "target", transformationElement);
    }

    private void write(SequenceSize sequenceSize, String type, Element transformationElement) {
        Element element = XMLUtil.addElement((Node)transformationElement, (String)XmlTransformation.sequenceSizeElementName);
        XMLUtil.setAttributeValue((Element)element, (String)XmlTransformation.sequenceSizeDimensionAttributeName, (String)String.valueOf(sequenceSize.getN()));
        XMLUtil.setAttributeValue((Element)element, (String)XmlTransformation.sequenceTypeAttributeName, (String)type);
        for (DimensionSize entry : sequenceSize.getDimensions()) {
            Element value = XMLUtil.addElement((Node)element, (String)XmlTransformation.dimensionSizeElementName);
            value.setAttribute(XmlTransformation.dimensionSizeDimensionNameAttributeName, entry.getDimensionId().name());
            value.setAttribute(XmlTransformation.dimensionSizePixelSizeAttributeName, String.valueOf(entry.getPixelSizeInMicrometer()));
            value.setTextContent(String.valueOf(entry.getSize()));
            element.appendChild(value);
        }
    }

    private void write(SequenceName sequenceName, String type, Element transformationElement) {
        Element element = XMLUtil.addElement((Node)transformationElement, (String)XmlTransformation.sequenceFileName);
        XMLUtil.setAttributeValue((Element)element, (String)XmlTransformation.sequenceTypeAttributeName, (String)type);
        element.setTextContent(sequenceName.getPath() + sequenceName.getName());
    }

    private void write(Dataset dataset, String type, Element transformationElement) {
        Element sourceDatasetElement = XMLUtil.addElement((Node)transformationElement, (String)XmlTransformation.datasetElementName);
        sourceDatasetElement.setAttribute(XmlTransformation.datasetTypeAttributeName, type);
        this.write(dataset, sourceDatasetElement);
    }

    private void write(Dataset dataset, Element datasetElement) {
        datasetElement.setAttribute(XmlTransformation.datasetNAttributeName, String.valueOf(dataset.getN()));
        datasetElement.setAttribute(XmlTransformation.datasetDimensionAttributeName, String.valueOf(dataset.getDimension()));
        datasetElement.setAttribute(XmlTransformation.datasetPointTypeAttributeName, dataset.getPointType().name());
        for (int i = 0; i < dataset.getN(); ++i) {
            Element point = XMLUtil.addElement((Node)datasetElement, (String)XmlTransformation.pointElementName);
            point.setAttribute(XmlTransformation.pointIdAttributeName, String.valueOf(i));
            this.write(dataset.getPoint(i), point);
        }
    }

    private void write(Point point, Element pointElement) {
        for (int i = 0; i < point.getDimension(); ++i) {
            Element coordinate = XMLUtil.addElement((Node)pointElement, (String)XmlTransformation.coordinateElementName);
            coordinate.setAttribute(XmlTransformation.coordinateDimensionAttributeName, String.valueOf(i));
            coordinate.setTextContent(String.valueOf(point.getMatrix().get(i, 0)));
        }
    }
}

