/*
 * Decompiled with CFR 0.152.
 */
package plugins.perrine.ec_clem.ec_clem.transformation;

import javax.inject.Inject;
import plugins.perrine.ec_clem.ec_clem.fiducialset.dataset.Dataset;
import plugins.perrine.ec_clem.ec_clem.fiducialset.dataset.DatasetFactory;
import plugins.perrine.ec_clem.ec_clem.fiducialset.dataset.point.Point;
import plugins.perrine.ec_clem.ec_clem.fiducialset.dataset.point.PointFactory;
import plugins.perrine.ec_clem.ec_clem.sequence.VtkPointsFactory;
import plugins.perrine.ec_clem.ec_clem.transformation.Transformation;
import vtk.vtkAbstractTransform;
import vtk.vtkDataObject;
import vtk.vtkPoints;
import vtk.vtkPolyData;
import vtk.vtkThinPlateSplineTransform;
import vtk.vtkTransformPolyDataFilter;
import vtk.vtkVertexGlyphFilter;

public class SplineTransformation
implements Transformation {
    private vtkThinPlateSplineTransform splineTransform;
    private VtkPointsFactory vtkPointsFactory;
    private DatasetFactory datasetFactory;
    private PointFactory pointFactory;

    @Inject
    public SplineTransformation(VtkPointsFactory vtkPointsFactory, DatasetFactory datasetFactory, PointFactory pointFactory) {
        this.vtkPointsFactory = vtkPointsFactory;
        this.datasetFactory = datasetFactory;
        this.pointFactory = pointFactory;
    }

    public vtkThinPlateSplineTransform getSplineTransform() {
        return this.splineTransform;
    }

    public SplineTransformation setSplineTransform(vtkThinPlateSplineTransform splineTransform) {
        this.splineTransform = splineTransform;
        return this;
    }

    @Override
    public Point apply(Point point) {
        vtkPolyData vtkPointsResult = this.apply(this.vtkPointsFactory.getFrom(point), this.splineTransform);
        return this.pointFactory.getFrom(vtkPointsResult);
    }

    @Override
    public Dataset apply(Dataset dataset) {
        vtkPolyData vtkPointsResult = this.apply(this.vtkPointsFactory.getFrom(dataset), this.splineTransform);
        return this.datasetFactory.getFrom(vtkPointsResult, dataset.getPointType());
    }

    private vtkPolyData apply(vtkPoints sourcePoints, vtkThinPlateSplineTransform transform) {
        vtkPolyData mypoints = new vtkPolyData();
        mypoints.SetPoints(sourcePoints);
        vtkVertexGlyphFilter vertexfilter = new vtkVertexGlyphFilter();
        vertexfilter.SetInputData((vtkDataObject)mypoints);
        vertexfilter.Update();
        vtkPolyData sourcepolydata = new vtkPolyData();
        sourcepolydata.ShallowCopy((vtkDataObject)vertexfilter.GetOutput());
        vtkTransformPolyDataFilter tr = new vtkTransformPolyDataFilter();
        tr.SetInputData((vtkDataObject)sourcepolydata);
        tr.SetTransform((vtkAbstractTransform)transform);
        tr.Update();
        return tr.GetOutput();
    }
}

