/*
 * Decompiled with CFR 0.152.
 */
package plugins.perrine.ec_clem.ec_clem.ui;

import java.awt.Component;
import java.util.Objects;
import javax.inject.Inject;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import plugins.perrine.ec_clem.ec_clem.roi.PointType;
import plugins.perrine.ec_clem.ec_clem.sequence_listener.RoiListenerManager;
import plugins.perrine.ec_clem.ec_clem.workspace.Workspace;

public class SelectPointTypeBox
extends JPanel {
    private JLabel jLabel;
    private JComboBox<PointType> stringJComboBox;
    private Workspace workspace;
    private RoiListenerManager roiListenerManager;

    @Inject
    public SelectPointTypeBox(RoiListenerManager roiListenerManager) {
        this.roiListenerManager = roiListenerManager;
        this.jLabel = new JLabel("Point type");
        this.stringJComboBox = new JComboBox<PointType>(new PointType[]{PointType.FIDUCIAL, PointType.NOT_FIDUCIAL});
        this.stringJComboBox.addItemListener(itemEvent -> {
            if (itemEvent.getStateChange() == 1) {
                roiListenerManager.set((PointType)((Object)((Object)itemEvent.getItem())));
            }
        });
        this.add(this.jLabel);
        this.add(this.stringJComboBox);
    }

    public void setWorkspace(Workspace workspace) {
        this.workspace = workspace;
        this.roiListenerManager.setSequences(workspace.getSourceSequence(), workspace.getTargetSequence());
        this.roiListenerManager.setWorkspace(workspace);
        this.stringJComboBox.setSelectedItem((Object)PointType.FIDUCIAL);
    }

    @Override
    public void setEnabled(boolean enabled) {
        for (Component component : this.getComponents()) {
            component.setEnabled(enabled);
        }
        if (this.workspace != null) {
            if (enabled) {
                this.roiListenerManager.set((PointType)((Object)Objects.requireNonNull(this.stringJComboBox.getSelectedItem())));
            } else {
                this.roiListenerManager.clear();
            }
        }
    }
}

