/*
 * Decompiled with CFR 0.152.
 */
package plugins.perrine.ec_clem.ec_clem.workspace;

import icy.sequence.SequenceListener;
import java.util.List;
import javax.inject.Inject;
import plugins.perrine.ec_clem.ec_clem.fiducialset.dataset.Dataset;
import plugins.perrine.ec_clem.ec_clem.fiducialset.dataset.DatasetFactory;
import plugins.perrine.ec_clem.ec_clem.progress.ProgressTrackableMasterTask;
import plugins.perrine.ec_clem.ec_clem.roi.PointType;
import plugins.perrine.ec_clem.ec_clem.roi.RoiUpdater;
import plugins.perrine.ec_clem.ec_clem.sequence_listener.FiducialRoiListener;
import plugins.perrine.ec_clem.ec_clem.sequence_listener.SequenceListenerUtil;
import plugins.perrine.ec_clem.ec_clem.workspace.DaggerUndoComponent;
import plugins.perrine.ec_clem.ec_clem.workspace.ResetOriginalImage;
import plugins.perrine.ec_clem.ec_clem.workspace.Workspace;
import plugins.perrine.ec_clem.ec_clem.workspace.WorkspaceTransformer;

public class Undo
extends ProgressTrackableMasterTask
implements Runnable {
    private SequenceListenerUtil sequenceListenerUtil;
    private DatasetFactory datasetFactory;
    private RoiUpdater roiUpdater;
    private Workspace workspace;
    private ResetOriginalImage resetOriginalImage;
    private WorkspaceTransformer workspaceTransformer;

    public Undo(Workspace workspace) {
        DaggerUndoComponent.builder().build().inject(this);
        this.workspace = workspace;
        this.resetOriginalImage = new ResetOriginalImage(workspace);
        this.workspaceTransformer = new WorkspaceTransformer(workspace);
        super.add(this.resetOriginalImage);
        super.add(this.workspaceTransformer);
    }

    @Override
    public void run() {
        List<SequenceListener> targetSequenceListeners = this.sequenceListenerUtil.removeListeners(this.workspace.getTargetSequence(), FiducialRoiListener.class);
        this.resetOriginalImage.run();
        Dataset sourceDataset = this.datasetFactory.getFrom(this.workspace.getSourceSequence(), PointType.FIDUCIAL);
        sourceDataset.removePoint(sourceDataset.getN() - 1);
        Dataset targetDataset = this.datasetFactory.getFrom(this.workspace.getTargetSequence(), PointType.FIDUCIAL);
        targetDataset.removePoint(targetDataset.getN() - 1);
        this.roiUpdater.updateRoi(sourceDataset, this.workspace.getSourceSequence());
        this.roiUpdater.updateRoi(targetDataset, this.workspace.getTargetSequence());
        this.sequenceListenerUtil.addListeners(this.workspace.getTargetSequence(), targetSequenceListeners);
        this.workspaceTransformer.run();
    }

    @Inject
    public void setSequenceListenerUtil(SequenceListenerUtil sequenceListenerUtil) {
        this.sequenceListenerUtil = sequenceListenerUtil;
    }

    @Inject
    public void setDatasetFactory(DatasetFactory datasetFactory) {
        this.datasetFactory = datasetFactory;
    }

    @Inject
    public void setRoiUpdater(RoiUpdater roiUpdater) {
        this.roiUpdater = roiUpdater;
    }
}

