/*
 * Decompiled with CFR 0.152.
 */
package plugins.perrine.ec_clem.transformation_schema_loader;

import icy.sequence.Sequence;
import java.io.File;
import javax.inject.Inject;
import plugins.adufour.blocks.lang.Block;
import plugins.adufour.blocks.util.VarList;
import plugins.adufour.ezplug.EzComponent;
import plugins.adufour.ezplug.EzPlug;
import plugins.adufour.ezplug.EzVarFile;
import plugins.adufour.ezplug.EzVarSequence;
import plugins.adufour.vars.lang.Var;
import plugins.perrine.ec_clem.ec_clem.roi.RoiUpdater;
import plugins.perrine.ec_clem.ec_clem.storage.transformation_schema.reader.XmlToTransformationSchemaFileReader;
import plugins.perrine.ec_clem.ec_clem.transformation.schema.TransformationSchema;
import plugins.perrine.ec_clem.transformation_schema_loader.DaggerEcClemTransformationSchemaLoaderComponent;

public class EcClemTransformationSchemaLoader
extends EzPlug
implements Block {
    private RoiUpdater roiUpdater;
    private XmlToTransformationSchemaFileReader xmlToTransformationSchemaFileReader;
    private EzVarFile inputFiducialFile = new EzVarFile("transformation schema", null);
    private EzVarSequence inputSourceSequence = new EzVarSequence("source sequence");
    private EzVarSequence inputTargetSequence = new EzVarSequence("target sequence");

    public EcClemTransformationSchemaLoader() {
        DaggerEcClemTransformationSchemaLoaderComponent.builder().build().inject(this);
    }

    protected void initialize() {
        this.addEzComponent((EzComponent)this.inputSourceSequence);
        this.addEzComponent((EzComponent)this.inputTargetSequence);
        this.addEzComponent((EzComponent)this.inputFiducialFile);
    }

    protected void execute() {
        TransformationSchema transformationSchema = this.xmlToTransformationSchemaFileReader.read((File)this.inputFiducialFile.getValue());
        this.roiUpdater.updateRoi(transformationSchema.getFiducialSet().getSourceDataset(), (Sequence)this.inputSourceSequence.getValue());
        this.roiUpdater.updateRoi(transformationSchema.getFiducialSet().getTargetDataset(), (Sequence)this.inputTargetSequence.getValue());
    }

    public void clean() {
    }

    public void declareInput(VarList varList) {
        varList.add("0", (Var)this.inputSourceSequence.getVariable());
        varList.add("1", (Var)this.inputTargetSequence.getVariable());
        varList.add("2", this.inputFiducialFile.getVariable());
    }

    public void declareOutput(VarList varList) {
    }

    @Inject
    public void setRoiUpdater(RoiUpdater roiUpdater) {
        this.roiUpdater = roiUpdater;
    }

    @Inject
    public void setXmlToTransformationSchemaFileReader(XmlToTransformationSchemaFileReader xmlToTransformationSchemaFileReader) {
        this.xmlToTransformationSchemaFileReader = xmlToTransformationSchemaFileReader;
    }
}

