/*
 * Decompiled with CFR 0.152.
 */
package plugins.perrine.ec_clem.autofinder;

import icy.image.IcyBufferedImage;
import icy.roi.ROI;
import icy.sequence.Sequence;
import icy.sequence.SequenceDataIterator;
import icy.type.DataIterator;
import icy.type.DataIteratorUtil;
import icy.type.DataType;
import icy.type.point.Point5D;
import java.awt.Color;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import plugins.adufour.blocks.lang.Block;
import plugins.adufour.blocks.util.VarList;
import plugins.adufour.ezplug.EzComponent;
import plugins.adufour.ezplug.EzPlug;
import plugins.adufour.ezplug.EzVarBoolean;
import plugins.adufour.ezplug.EzVarDouble;
import plugins.adufour.ezplug.EzVarSequence;
import plugins.adufour.vars.lang.Var;
import plugins.kernel.roi.roi3d.ROI3DPoint;
import vtk.vtkDataArray;
import vtk.vtkDataObject;
import vtk.vtkDecimatePro;
import vtk.vtkDoubleArray;
import vtk.vtkFloatArray;
import vtk.vtkImageData;
import vtk.vtkImageResample;
import vtk.vtkIntArray;
import vtk.vtkMarchingCubes;
import vtk.vtkMarchingSquares;
import vtk.vtkPoints;
import vtk.vtkPolyData;
import vtk.vtkShortArray;
import vtk.vtkUnsignedCharArray;
import vtk.vtkUnsignedIntArray;
import vtk.vtkUnsignedShortArray;

public class ConvertBinarytoPointRoi
extends EzPlug
implements Block {
    private EzVarSequence source = new EzVarSequence("Binary Image");
    private EzVarDouble newsize = new EzVarDouble("put points every (in um)", 1.0, 0.01, 100.0, 0.1);
    private EzVarBoolean fromrois = new EzVarBoolean("Generate point from Rois", false);
    private vtkImageData imageData;

    public void clean() {
    }

    protected void execute() {
        this.imageData = this.converttoVtkImageData(0, (Sequence)this.source.getValue(), false);
        double resampling = (Double)this.newsize.getValue();
        double reductionfactorx = ((Sequence)this.source.getValue()).getPixelSizeX() / resampling;
        double reductionfactorz = ((Sequence)this.source.getValue()).getPixelSizeZ() / resampling;
        vtkImageResample resampler = new vtkImageResample();
        resampler.SetInputData((vtkDataObject)this.imageData);
        resampler.SetAxisMagnificationFactor(0, reductionfactorx);
        resampler.SetAxisMagnificationFactor(1, reductionfactorx);
        resampler.SetAxisMagnificationFactor(2, reductionfactorz);
        resampler.Update();
        int downsample = 1;
        System.out.println(((Sequence)this.source.getValue()).getChannelMax(0));
        double contourlevel = 255.0;
        if (!((Boolean)this.fromrois.getValue()).booleanValue()) {
            contourlevel = ((Sequence)this.source.getValue()).getChannelMax(0);
        }
        if (((Sequence)this.source.getValue()).getSizeZ() == 1) {
            vtkMarchingSquares surfaceextractor2D = new vtkMarchingSquares();
            surfaceextractor2D.SetInputData((vtkDataObject)resampler.GetOutput());
            surfaceextractor2D.SetValue(0, contourlevel);
            surfaceextractor2D.Update();
            vtkPolyData surface = surfaceextractor2D.GetOutput();
            vtkPoints extractedpoints = surface.GetPoints();
            if (surface.GetNumberOfPoints() == 0) {
                return;
            }
            System.out.println(extractedpoints.GetNumberOfPoints());
            this.CreateRoifromPoints((Sequence)this.source.getValue(), surface, Color.GREEN, downsample);
        } else {
            vtkMarchingCubes surfaceextractor = new vtkMarchingCubes();
            surfaceextractor.SetInputData((vtkDataObject)resampler.GetOutput());
            surfaceextractor.SetValue(0, ((Sequence)this.source.getValue()).getChannelMax(0));
            surfaceextractor.ComputeScalarsOn();
            surfaceextractor.ComputeNormalsOn();
            surfaceextractor.ComputeGradientsOn();
            surfaceextractor.Update();
            vtkDecimatePro deci = new vtkDecimatePro();
            deci.SetInputConnection(surfaceextractor.GetOutputPort());
            deci.SetTargetReduction(0.9);
            deci.Update();
            vtkPolyData surface = deci.GetOutput();
            vtkPoints extractedpoints = surface.GetPoints();
            System.out.println(extractedpoints.GetNumberOfPoints());
            this.CreateRoifromPoints((Sequence)this.source.getValue(), surface, Color.RED, downsample);
        }
    }

    protected void CreateRoifromPoints(Sequence seq, vtkPolyData points, Color mycolor, int downsample) {
        vtkPoints listofpoints = points.GetPoints();
        for (int i = 0; i < points.GetNumberOfPoints(); i += downsample) {
            ROI3DPoint roi = new ROI3DPoint();
            Point5D position = roi.getPosition5D();
            position.setX(listofpoints.GetPoint(i)[0] / seq.getPixelSizeX());
            position.setY(listofpoints.GetPoint(i)[1] / seq.getPixelSizeY());
            position.setZ(listofpoints.GetPoint(i)[2] / seq.getPixelSizeZ());
            roi.setPosition5D(position);
            roi.setName(" Point " + i);
            roi.setColor(mycolor);
            seq.addROI((ROI)roi);
        }
    }

    protected void initialize() {
        this.addEzComponent((EzComponent)this.source);
        this.addEzComponent((EzComponent)this.newsize);
        this.addEzComponent((EzComponent)this.fromrois);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    vtkImageData converttoVtkImageData(int posC, Sequence seq, boolean affectfield) {
        Sequence sequence2 = seq;
        int sizeX = sequence2.getSizeX();
        int sizeY = sequence2.getSizeY();
        int sizeZ = sequence2.getSizeZ();
        vtkImageData newImageData = new vtkImageData();
        if (seq == null) {
            return null;
        }
        Sequence out = new Sequence("ROI conversion");
        if (((Boolean)this.fromrois.getValue()).booleanValue()) {
            ArrayList rois = sequence2.getROIs();
            out.beginUpdate();
            try {
                for (int t = 0; t < sequence2.getSizeT(); ++t) {
                    for (int z = 0; z < sequence2.getSizeZ(); ++z) {
                        out.setImage(t, z, (BufferedImage)new IcyBufferedImage(sequence2.getSizeX(), sequence2.getSizeY(), 1, DataType.UBYTE));
                    }
                }
                for (ROI roi : rois) {
                    if (roi.getBounds5D().isEmpty()) continue;
                    DataIteratorUtil.set((DataIterator)new SequenceDataIterator(out, roi), (double)255.0);
                }
                out.dataChanged();
            }
            finally {
                out.endUpdate();
                sequence2.removeAllROI();
            }
            out.setPixelSizeX(seq.getPixelSizeX());
            out.setPixelSizeY(seq.getPixelSizeY());
            out.setPixelSizeZ(seq.getPixelSizeZ());
            int posT = !this.isHeadLess() ? sequence2.getFirstViewer().getPositionT() : 0;
            newImageData.SetDimensions(sizeX, sizeY, sizeZ);
            newImageData.SetSpacing(seq.getPixelSizeX(), seq.getPixelSizeY(), seq.getPixelSizeZ());
            newImageData.AllocateScalars(3, 1);
            vtkDataArray array = newImageData.GetPointData().GetScalars();
            if (posC == -1) {
                ((vtkUnsignedCharArray)array).SetJavaArray(out.getDataCopyCXYZAsByte(posT));
            } else {
                ((vtkUnsignedCharArray)array).SetJavaArray(out.getDataCopyXYZAsByte(posT, posC));
            }
        } else {
            int posT = !this.isHeadLess() ? sequence2.getFirstViewer().getPositionT() : 0;
            DataType dataType = sequence2.getDataType_();
            newImageData.SetDimensions(sizeX, sizeY, sizeZ);
            newImageData.SetSpacing(seq.getPixelSizeX(), seq.getPixelSizeY(), seq.getPixelSizeZ());
            switch (dataType) {
                case UBYTE: {
                    newImageData.AllocateScalars(3, 1);
                    vtkDataArray array = newImageData.GetPointData().GetScalars();
                    if (posC == -1) {
                        ((vtkUnsignedCharArray)array).SetJavaArray(seq.getDataCopyCXYZAsByte(posT));
                        break;
                    }
                    ((vtkUnsignedCharArray)array).SetJavaArray(seq.getDataCopyXYZAsByte(posT, posC));
                    break;
                }
                case BYTE: {
                    newImageData.AllocateScalars(3, 1);
                    vtkDataArray array = newImageData.GetPointData().GetScalars();
                    if (posC == -1) {
                        ((vtkUnsignedCharArray)array).SetJavaArray(seq.getDataCopyCXYZAsByte(posT));
                        break;
                    }
                    ((vtkUnsignedCharArray)array).SetJavaArray(seq.getDataCopyXYZAsByte(posT, posC));
                    break;
                }
                case USHORT: {
                    newImageData.AllocateScalars(5, 1);
                    vtkDataArray array = newImageData.GetPointData().GetScalars();
                    if (posC == -1) {
                        ((vtkUnsignedShortArray)array).SetJavaArray(seq.getDataCopyCXYZAsShort(posT));
                        break;
                    }
                    ((vtkUnsignedShortArray)array).SetJavaArray(seq.getDataCopyXYZAsShort(posT, posC));
                    break;
                }
                case SHORT: {
                    newImageData.AllocateScalars(4, 1);
                    vtkDataArray array = newImageData.GetPointData().GetScalars();
                    if (posC == -1) {
                        ((vtkShortArray)array).SetJavaArray(seq.getDataCopyCXYZAsShort(posT));
                        break;
                    }
                    ((vtkShortArray)array).SetJavaArray(seq.getDataCopyXYZAsShort(posT, posC));
                    break;
                }
                case UINT: {
                    newImageData.AllocateScalars(7, 1);
                    vtkDataArray array = newImageData.GetPointData().GetScalars();
                    if (posC == -1) {
                        ((vtkUnsignedIntArray)array).SetJavaArray(seq.getDataCopyCXYZAsInt(posT));
                        break;
                    }
                    ((vtkUnsignedIntArray)array).SetJavaArray(seq.getDataCopyXYZAsInt(posT, posC));
                    break;
                }
                case INT: {
                    newImageData.AllocateScalars(6, 1);
                    vtkDataArray array = newImageData.GetPointData().GetScalars();
                    if (posC == -1) {
                        ((vtkIntArray)array).SetJavaArray(seq.getDataCopyCXYZAsInt(posT));
                        break;
                    }
                    ((vtkIntArray)array).SetJavaArray(seq.getDataCopyXYZAsInt(posT, posC));
                    break;
                }
                case FLOAT: {
                    newImageData.AllocateScalars(10, 1);
                    vtkDataArray array = newImageData.GetPointData().GetScalars();
                    if (posC == -1) {
                        ((vtkFloatArray)array).SetJavaArray(seq.getDataCopyCXYZAsFloat(posT));
                        break;
                    }
                    ((vtkFloatArray)array).SetJavaArray(seq.getDataCopyXYZAsFloat(posT, posC));
                    break;
                }
                case DOUBLE: {
                    newImageData.AllocateScalars(11, 1);
                    vtkDataArray array = newImageData.GetPointData().GetScalars();
                    if (posC == -1) {
                        ((vtkDoubleArray)array).SetJavaArray(seq.getDataCopyCXYZAsDouble(posT));
                        break;
                    }
                    ((vtkDoubleArray)array).SetJavaArray(seq.getDataCopyXYZAsDouble(posT, posC));
                    break;
                }
                default: {
                    newImageData.SetDimensions(1, 1, 1);
                    newImageData.SetSpacing(seq.getPixelSizeX(), seq.getPixelSizeY(), seq.getPixelSizeZ());
                    newImageData.SetNumberOfScalarComponents(1, null);
                    newImageData.SetExtent(0, 0, 0, 0, 0, 0);
                    newImageData.AllocateScalars(null);
                }
            }
        }
        return newImageData;
    }

    public void declareInput(VarList inputMap) {
        inputMap.add("Sequence to process", (Var)this.source.getVariable());
        inputMap.add("sampling", this.newsize.getVariable());
        inputMap.add("read rois instead of binary", this.fromrois.getVariable());
    }

    public void declareOutput(VarList outputMap) {
        outputMap.add("sequence with Rois", (Var)this.source.getVariable());
    }
}

