/*
 * Decompiled with CFR 0.152.
 */
package plugins.perrine.ec_clem.cascade_transform;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.LinkedList;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class FileList
extends JPanel
implements ListSelectionListener {
    private List<File> fileList;
    private JList<File> list;
    private DefaultListModel<File> listModel;
    private static final String addString = "Add";
    private static final String deleteString = "Delete";
    private JButton addButton;
    private JButton deleteButton;

    public FileList(List<File> filelist) {
        super(new BorderLayout());
        this.fileList = filelist;
        this.listModel = new DefaultListModel();
        this.list = new JList<File>(this.listModel);
        this.list.setSelectionMode(0);
        this.list.setSelectedIndex(0);
        this.list.addListSelectionListener(this);
        this.list.setVisibleRowCount(5);
        JScrollPane listScrollPane = new JScrollPane(this.list);
        this.addButton = new JButton(addString);
        this.addButton.setActionCommand(addString);
        this.addButton.addActionListener(new AddListener());
        this.addButton.setEnabled(true);
        this.deleteButton = new JButton(deleteString);
        this.deleteButton.setActionCommand(deleteString);
        this.deleteButton.addActionListener(new DeleteListener());
        this.deleteButton.setEnabled(false);
        JPanel buttonPane = new JPanel();
        buttonPane.setLayout(new BoxLayout(buttonPane, 2));
        buttonPane.add(this.deleteButton);
        buttonPane.add(Box.createHorizontalStrut(5));
        buttonPane.add(new JSeparator(1));
        buttonPane.add(Box.createHorizontalStrut(5));
        buttonPane.add(this.addButton);
        buttonPane.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.add((Component)listScrollPane, "Center");
        this.add((Component)buttonPane, "Last");
    }

    @Override
    public void valueChanged(ListSelectionEvent e) {
        if (!e.getValueIsAdjusting()) {
            if (this.list.getSelectedIndex() == -1) {
                this.deleteButton.setEnabled(false);
            } else {
                this.deleteButton.setEnabled(true);
            }
        }
    }

    @Override
    public void setEnabled(boolean enabled) {
        this.addButton.setEnabled(enabled);
        this.deleteButton.setEnabled(enabled && this.listModel.getSize() > 0);
    }

    public List<File> getFiles() {
        LinkedList<File> files = new LinkedList<File>();
        for (int i = 0; i < this.listModel.getSize(); ++i) {
            files.add(this.listModel.get(i));
        }
        return files;
    }

    class AddListener
    implements ActionListener {
        AddListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            int index = FileList.this.list.getSelectedIndex();
            index = index == -1 ? 0 : ++index;
            JFileChooser jFileChooser = new JFileChooser();
            jFileChooser.setMultiSelectionEnabled(true);
            int r = jFileChooser.showOpenDialog(null);
            if (r == 0) {
                for (int i = 0; i < jFileChooser.getSelectedFiles().length; ++i) {
                    FileList.this.listModel.insertElementAt(jFileChooser.getSelectedFiles()[i], index + i);
                    FileList.this.fileList.add(index + i, jFileChooser.getSelectedFiles()[i]);
                    FileList.this.list.setSelectedIndex(index + i);
                    FileList.this.list.ensureIndexIsVisible(index + i);
                }
            }
        }
    }

    class DeleteListener
    implements ActionListener {
        DeleteListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            int index = FileList.this.list.getSelectedIndex();
            FileList.this.listModel.remove(index);
            FileList.this.fileList.remove(index);
            int size = FileList.this.listModel.getSize();
            if (size == 0) {
                FileList.this.deleteButton.setEnabled(false);
            } else {
                if (index == FileList.this.listModel.getSize()) {
                    --index;
                }
                FileList.this.list.setSelectedIndex(index);
                FileList.this.list.ensureIndexIsVisible(index);
            }
        }
    }
}

