/*
 * Decompiled with CFR 0.152.
 */
package plugins.perrine.ec_clem.ec_clem.error.ellipse.rigid;

import Jama.Matrix;
import javax.inject.Inject;
import plugins.perrine.ec_clem.ec_clem.error.ellipse.CovarianceEstimator;
import plugins.perrine.ec_clem.ec_clem.error.ellipse.rigid.InverseFisherInformationMatrixEstimatorFactory;
import plugins.perrine.ec_clem.ec_clem.error.ellipse.rigid.JacobianMatrixFactory;
import plugins.perrine.ec_clem.ec_clem.fiducialset.dataset.point.Point;
import plugins.perrine.ec_clem.ec_clem.registration.RegistrationParameter;
import plugins.perrine.ec_clem.ec_clem.transformation.RegistrationParameterFactory;
import plugins.perrine.ec_clem.ec_clem.transformation.schema.TransformationSchema;

public class RigidCovarianceEstimator
implements CovarianceEstimator {
    private RegistrationParameterFactory transformationFactory;
    private InverseFisherInformationMatrixEstimatorFactory inverseFisherInformationMatrixEstimatorFactory;
    private JacobianMatrixFactory jacobianMatrixFactory;

    @Inject
    public RigidCovarianceEstimator(RegistrationParameterFactory transformationFactory, InverseFisherInformationMatrixEstimatorFactory inverseFisherInformationMatrixEstimatorFactory, JacobianMatrixFactory jacobianMatrixFactory) {
        this.transformationFactory = transformationFactory;
        this.inverseFisherInformationMatrixEstimatorFactory = inverseFisherInformationMatrixEstimatorFactory;
        this.jacobianMatrixFactory = jacobianMatrixFactory;
    }

    @Override
    public Matrix getCovariance(TransformationSchema transformationSchema, Point zSource) {
        RegistrationParameter from = this.transformationFactory.getFrom(transformationSchema);
        Matrix lambda = from.getNoiseCovariance();
        Matrix sigma = this.inverseFisherInformationMatrixEstimatorFactory.getFrom(zSource.getDimension()).getInverseFisherInformationMatrix(transformationSchema.getFiducialSet(), from);
        Matrix jacobian = this.jacobianMatrixFactory.getFrom(zSource.getDimension()).getJacobian(zSource, from);
        Matrix E = jacobian.times(sigma).times(jacobian.transpose());
        return E.plus(lambda);
    }
}

