/*
 * Decompiled with CFR 0.152.
 */
package plugins.perrine.ec_clem.ec_clem.misc;

import Jama.Matrix;
import icy.canvas.IcyCanvas;
import icy.canvas.IcyCanvas2D;
import icy.gui.dialog.MessageDialog;
import icy.gui.frame.progress.ProgressFrame;
import icy.preferences.ApplicationPreferences;
import icy.roi.ROI;
import icy.sequence.Sequence;
import icy.system.thread.ThreadUtil;
import icy.type.geom.Polygon2D;
import icy.type.point.Point5D;
import icy.util.XMLUtil;
import java.awt.geom.Point2D;
import java.io.File;
import java.util.ArrayList;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import plugins.adufour.blocks.lang.Block;
import plugins.adufour.blocks.util.VarList;
import plugins.adufour.ezplug.EzComponent;
import plugins.adufour.ezplug.EzLabel;
import plugins.adufour.ezplug.EzPlug;
import plugins.adufour.ezplug.EzVarFile;
import plugins.adufour.ezplug.EzVarSequence;
import plugins.adufour.vars.lang.Var;
import plugins.adufour.vars.lang.VarROIArray;
import plugins.kernel.roi.roi2d.ROI2DEllipse;
import plugins.kernel.roi.roi2d.ROI2DPolygon;
import plugins.perrine.ec_clem.ec_clem.storage.transformation.xml.XmlFiletoTransformationReader;

public class ApplyTransformationtoRoi
extends EzPlug
implements Block {
    EzVarSequence source = new EzVarSequence("Select Source Image (showing Rois)");
    EzVarSequence target = new EzVarSequence("Select Target Image (to set the new Rois)");
    private EzVarFile xmlFile = new EzVarFile("Xml file containing ec-clem v2 transformation", ApplicationPreferences.getPreferences().node("frame/imageLoader").get("path", "."));
    private Runnable transformer;
    protected VarROIArray outputROIs = new VarROIArray("list of ROI");
    private int auto;

    protected void initialize() {
        EzLabel textinfo = new EzLabel("Please open images with Roi (source) and the destination target image, and the storage file containing the transformations (likely your source file name _transfo.storage)");
        String varName = "Xml file containing ec-clem v2 transformation";
        this.xmlFile = this.source.getValue() != null ? new EzVarFile(varName, ((Sequence)this.source.getValue()).getFilename()) : new EzVarFile(varName, ApplicationPreferences.getPreferences().node("frame/imageLoader").get("path", "."));
        this.addEzComponent((EzComponent)textinfo);
        this.addEzComponent((EzComponent)this.source);
        this.addEzComponent((EzComponent)this.target);
        this.addEzComponent((EzComponent)this.xmlFile);
    }

    protected void execute() {
        final Sequence sourceseq = (Sequence)this.source.getValue();
        if (sourceseq == null) {
            MessageDialog.showDialog((String)"Please make sure that your image is opened");
            return;
        }
        final Document document = XMLUtil.loadDocument((File)((File)this.xmlFile.getValue()));
        this.transformer = new Runnable(){

            @Override
            public void run() {
                IcyCanvas sourcecanvas;
                Matrix CombinedTransfo = ApplyTransformationtoRoi.this.getTransfov2(document);
                ProgressFrame progress = new ProgressFrame("Applying transformation...");
                ArrayList Rois = sourceseq.getROIs();
                block10: for (ROI Roi : Rois) {
                    ROI newRoi = Roi.getCopy();
                    switch (newRoi.getSimpleClassName()) {
                        case "ROI2DRectangle": {
                            Point5D oldposition = Roi.getPosition5D();
                            Point5D newposition = ApplyTransformationtoRoi.this.transformPoints5D(CombinedTransfo, oldposition);
                            newRoi.setPosition5D(newposition);
                            if (!ApplyTransformationtoRoi.this.isHeadLess()) {
                                ((Sequence)ApplyTransformationtoRoi.this.target.getValue()).addROI(newRoi);
                                continue block10;
                            }
                            ApplyTransformationtoRoi.this.outputROIs.add((Object[])new ROI[]{newRoi});
                            continue block10;
                        }
                        case "ROI2DEllipse": {
                            Point5D oldposition2 = Roi.getPosition5D();
                            Point5D newposition2 = ApplyTransformationtoRoi.this.transformPoints5D(CombinedTransfo, oldposition2);
                            newRoi.setPosition5D(newposition2);
                            ArrayList ControlPoints = ((ROI2DEllipse)newRoi).getPoints();
                            for (Point2D pt2D : ControlPoints) {
                                oldposition2 = new Point5D.Double(pt2D.getX(), pt2D.getY(), 1.0, 1.0, 1.0);
                                newposition2 = ApplyTransformationtoRoi.this.transformPoints5D(CombinedTransfo, oldposition2);
                                pt2D.setLocation(newposition2.getX(), newposition2.getY());
                            }
                            newRoi.roiChanged(true);
                            if (!ApplyTransformationtoRoi.this.isHeadLess()) {
                                ((Sequence)ApplyTransformationtoRoi.this.target.getValue()).addROI(newRoi);
                                continue block10;
                            }
                            ApplyTransformationtoRoi.this.outputROIs.add((Object[])new ROI[]{newRoi});
                            continue block10;
                        }
                        case "ROI2DPolygon": {
                            Point5D oldposition3 = Roi.getPosition5D();
                            Point5D newposition3 = ApplyTransformationtoRoi.this.transformPoints5D(CombinedTransfo, oldposition3);
                            Polygon2D poly = ((ROI2DPolygon)newRoi).getPolygon2D();
                            for (int i = 0; i < poly.npoints; ++i) {
                                oldposition3 = new Point5D.Double(poly.xpoints[i], poly.ypoints[i], 1.0, 1.0, 1.0);
                                newposition3 = ApplyTransformationtoRoi.this.transformPoints5D(CombinedTransfo, oldposition3);
                                poly.xpoints[i] = newposition3.getX();
                                poly.ypoints[i] = newposition3.getY();
                            }
                            ((ROI2DPolygon)newRoi).setPolygon2D(poly);
                            newRoi.roiChanged(true);
                            if (!ApplyTransformationtoRoi.this.isHeadLess()) {
                                ((Sequence)ApplyTransformationtoRoi.this.target.getValue()).addROI(newRoi);
                                continue block10;
                            }
                            ApplyTransformationtoRoi.this.outputROIs.add((Object[])new ROI[]{newRoi});
                            continue block10;
                        }
                    }
                    System.err.println("Roi of type " + newRoi.getSimpleClassName() + " non implemented yet ");
                }
                progress.close();
                if (!ApplyTransformationtoRoi.this.isHeadLess() && (sourcecanvas = ((Sequence)ApplyTransformationtoRoi.this.source.getValue()).getFirstViewer().getCanvas()) instanceof IcyCanvas2D) {
                    ((IcyCanvas2D)sourcecanvas).fitCanvasToImage();
                }
            }
        };
        if (!this.isHeadLess()) {
            ThreadUtil.bgRun((Runnable)this.transformer);
        } else {
            ThreadUtil.invokeNow((Runnable)this.transformer);
        }
    }

    protected Point5D transformPoints5D(Matrix combinedTransfo, Point5D oldposition) {
        double[][] array = new double[][]{{oldposition.getX() * ((Sequence)this.source.getValue()).getPixelSizeX(), oldposition.getY() * ((Sequence)this.source.getValue()).getPixelSizeY(), 1.0, 1.0}};
        Matrix oldpositionmatrix = new Matrix((double[][])array);
        Matrix newpositionmatrix = combinedTransfo.times(oldpositionmatrix.transpose());
        Point5D.Double newposition = new Point5D.Double();
        newposition.setX(newpositionmatrix.get(0, 0) / ((Sequence)this.target.getValue()).getPixelSizeX());
        newposition.setY(newpositionmatrix.get(1, 0) / ((Sequence)this.target.getValue()).getPixelSizeY());
        newposition.setZ(1.0);
        return newposition;
    }

    public void clean() {
    }

    public Matrix getCombinedTransfo(Document document) {
        Element root = XMLUtil.getRootElement((Document)document);
        ArrayList transfoElementArrayList = XMLUtil.getElements((Node)root, (String)"MatrixTransformation");
        ArrayList<Matrix> listoftransfo = new ArrayList<Matrix>();
        for (Element transfoElement : transfoElementArrayList) {
            double[][] m = new double[4][4];
            m[0][0] = XMLUtil.getAttributeDoubleValue((Element)transfoElement, (String)"m00", (double)0.0);
            m[0][1] = XMLUtil.getAttributeDoubleValue((Element)transfoElement, (String)"m01", (double)0.0);
            m[0][2] = XMLUtil.getAttributeDoubleValue((Element)transfoElement, (String)"m02", (double)0.0);
            m[0][3] = XMLUtil.getAttributeDoubleValue((Element)transfoElement, (String)"m03", (double)0.0);
            m[1][0] = XMLUtil.getAttributeDoubleValue((Element)transfoElement, (String)"m10", (double)0.0);
            m[1][1] = XMLUtil.getAttributeDoubleValue((Element)transfoElement, (String)"m11", (double)0.0);
            m[1][2] = XMLUtil.getAttributeDoubleValue((Element)transfoElement, (String)"m12", (double)0.0);
            m[1][3] = XMLUtil.getAttributeDoubleValue((Element)transfoElement, (String)"m13", (double)0.0);
            m[2][0] = XMLUtil.getAttributeDoubleValue((Element)transfoElement, (String)"m20", (double)0.0);
            m[2][1] = XMLUtil.getAttributeDoubleValue((Element)transfoElement, (String)"m21", (double)0.0);
            m[2][2] = XMLUtil.getAttributeDoubleValue((Element)transfoElement, (String)"m22", (double)0.0);
            m[2][3] = XMLUtil.getAttributeDoubleValue((Element)transfoElement, (String)"m23", (double)0.0);
            m[3][0] = XMLUtil.getAttributeDoubleValue((Element)transfoElement, (String)"m30", (double)0.0);
            m[3][1] = XMLUtil.getAttributeDoubleValue((Element)transfoElement, (String)"m31", (double)0.0);
            m[3][2] = XMLUtil.getAttributeDoubleValue((Element)transfoElement, (String)"m32", (double)0.0);
            m[3][3] = XMLUtil.getAttributeDoubleValue((Element)transfoElement, (String)"m33", (double)0.0);
            Matrix T = new Matrix(m);
            listoftransfo.add(T);
        }
        Matrix CombinedTransfo = Matrix.identity((int)4, (int)4);
        for (int i = 0; i < listoftransfo.size(); ++i) {
            CombinedTransfo = ((Matrix)listoftransfo.get(i)).times(CombinedTransfo);
        }
        return CombinedTransfo;
    }

    public Matrix getTransfov2(Document document) {
        XmlFiletoTransformationReader reader = new XmlFiletoTransformationReader();
        double[][] m = reader.read(document);
        Matrix T = new Matrix(m);
        return T;
    }

    public Document getdocumentTitle() {
        Document document = XMLUtil.loadDocument((File)((File)this.xmlFile.getValue()));
        return document;
    }

    public void declareInput(VarList inputMap) {
        inputMap.add("Input Image", (Var)this.source.getVariable());
        inputMap.add("Imput XML File", this.xmlFile.getVariable());
    }

    public void declareOutput(VarList outputMap) {
        outputMap.add("output transformedregions", (Var)this.outputROIs);
    }
}

