/*
 * Decompiled with CFR 0.152.
 */
package plugins.perrine.ec_clem.ec_clem.sequence;

import icy.gui.viewer.Viewer;
import icy.image.lut.LUT;
import icy.sequence.DimensionId;
import icy.sequence.Sequence;
import icy.sequence.SequenceUtil;
import icy.type.DataType;
import icy.vtk.VtkUtil;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.function.Supplier;
import javax.inject.Inject;
import plugins.perrine.ec_clem.ec_clem.progress.ProgressTrackable;
import plugins.perrine.ec_clem.ec_clem.progress.ProgressTrackableMasterTask;
import plugins.perrine.ec_clem.ec_clem.sequence.DaggerStack3DVTKTransformerComponent;
import plugins.perrine.ec_clem.ec_clem.sequence.SequenceSize;
import plugins.perrine.ec_clem.ec_clem.sequence.VtkAbstractTransformFactory;
import plugins.perrine.ec_clem.ec_clem.sequence.VtkDataSequenceSupplier;
import plugins.perrine.ec_clem.ec_clem.transformation.Transformation;
import vtk.vtkAbstractTransform;
import vtk.vtkDataArray;
import vtk.vtkDataObject;
import vtk.vtkImageData;
import vtk.vtkImageReslice;

public class Stack3DVTKTransformer
extends ProgressTrackableMasterTask
implements Supplier<Sequence> {
    private vtkImageReslice imageReslice;
    private Sequence sequence;
    private Transformation transformation;
    private int extentx;
    private int extenty;
    private int extentz;
    private double spacingx;
    private double spacingy;
    private double spacingz;
    private double InputSpacingz;
    private double InputSpacingx;
    private double InputSpacingy;
    private DataType dataType;
    private int sizeT;
    private int sizeC;
    private VtkAbstractTransformFactory vtkAbstractTransformFactory;

    public Stack3DVTKTransformer(Sequence sequence, SequenceSize sequenceSize, Transformation transformation) {
        DaggerStack3DVTKTransformerComponent.builder().build().inject(this);
        this.setSourceSequence(sequence);
        this.setTargetSize(sequenceSize);
        this.transformation = transformation;
        this.dataType = sequence.getDataType_();
        this.sizeT = sequence.getSizeT();
        this.sizeC = sequence.getSizeC();
        for (int i = 0; i < sequence.getSizeC(); ++i) {
            super.add(new VtkDataSequenceSupplier(sequence, this.dataType, i, this.sizeC, null, this.extentx, this.extenty, this.extentz, this.sizeT, this.spacingx, this.spacingy, this.spacingz));
        }
    }

    @Override
    public Sequence get() {
        vtkAbstractTransform mytransfo = this.vtkAbstractTransformFactory.getFrom(this.transformation);
        this.imageReslice = new vtkImageReslice();
        this.imageReslice.SetOutputDimensionality(3);
        this.imageReslice.SetOutputOrigin(0.0, 0.0, 0.0);
        this.imageReslice.SetOutputSpacing(this.spacingx, this.spacingy, this.spacingz);
        this.imageReslice.SetOutputExtent(0, this.extentx - 1, 0, this.extenty - 1, 0, this.extentz - 1);
        this.imageReslice.SetResliceTransform(mytransfo);
        this.imageReslice.SetInterpolationModeToLinear();
        this.imageReslice.ReleaseDataFlagOn();
        ArrayList<LUT> lutList = new ArrayList<LUT>();
        ArrayList viewers = this.sequence.getViewers();
        for (Viewer viewer : viewers) {
            viewer.refreshCanvasCombo();
            lutList.add(viewer.getLut());
        }
        this.sequence.beginUpdate();
        LinkedList<Sequence> channels = new LinkedList<Sequence>();
        for (int c = 0; c < this.sequence.getSizeC(); ++c) {
            channels.add(SequenceUtil.extractChannel((Sequence)this.sequence, (int)c));
        }
        this.sequence.removeAllImages();
        List<ProgressTrackable> taskList = super.getTaskList();
        for (int c = 0; c < this.sizeC; ++c) {
            vtkImageData vtkImageData2 = this.converttoVtkImageData((Sequence)channels.remove(0));
            this.imageReslice.SetInputData((vtkDataObject)vtkImageData2);
            this.imageReslice.Modified();
            this.imageReslice.Update();
            VtkDataSequenceSupplier progressTrackable = (VtkDataSequenceSupplier)taskList.get(c);
            progressTrackable.setData(VtkUtil.getJavaArray((vtkDataArray)this.imageReslice.GetOutput().GetPointData().GetScalars()));
            progressTrackable.get();
            vtkImageData2.ReleaseData();
            vtkImageData2.Delete();
        }
        this.imageReslice.Delete();
        VtkUtil.vtkGC();
        for (int i = 0; i < viewers.size(); ++i) {
            ((Viewer)viewers.get(i)).setLut((LUT)lutList.get(i));
            this.sequence.setAutoUpdateChannelBounds(true);
        }
        this.sequence.endUpdate();
        return this.sequence;
    }

    private void setSourceSequence(Sequence sequence) {
        this.sequence = sequence;
        this.InputSpacingx = sequence.getPixelSizeX();
        this.InputSpacingy = sequence.getPixelSizeY();
        this.InputSpacingz = sequence.getPixelSizeZ();
    }

    private void setTargetSize(SequenceSize sequenceSize) {
        this.extentx = sequenceSize.get(DimensionId.X).getSize();
        this.extenty = sequenceSize.get(DimensionId.Y).getSize();
        this.extentz = sequenceSize.get(DimensionId.Z).getSize();
        this.spacingx = sequenceSize.get(DimensionId.X).getPixelSizeInMicrometer();
        this.spacingy = sequenceSize.get(DimensionId.Y).getPixelSizeInMicrometer();
        this.spacingz = sequenceSize.get(DimensionId.Z).getPixelSizeInMicrometer();
    }

    private vtkImageData converttoVtkImageData(Sequence singleChannelSequence) {
        vtkImageData newImageData = new vtkImageData();
        newImageData.SetDimensions(singleChannelSequence.getSizeX(), singleChannelSequence.getSizeY(), singleChannelSequence.getSizeZ());
        newImageData.SetSpacing(this.InputSpacingx, this.InputSpacingy, this.InputSpacingz);
        Object dataCopyXYZT = singleChannelSequence.getDataCopyXYZT(0);
        newImageData.GetPointData().SetScalars(VtkUtil.getVtkArray((Object)dataCopyXYZT, (boolean)true));
        return newImageData;
    }

    @Inject
    public void setVtkAbstractTransformFactory(VtkAbstractTransformFactory vtkAbstractTransformFactory) {
        this.vtkAbstractTransformFactory = vtkAbstractTransformFactory;
    }
}

