/*
 * Decompiled with CFR 0.152.
 */
package plugins.perrine.ec_clem.ec_clem.sequence_listener;

import icy.main.Icy;
import icy.roi.ROI;
import icy.sequence.Sequence;
import icy.sequence.SequenceEvent;
import icy.sequence.SequenceListener;
import javax.inject.Inject;
import plugins.kernel.roi.roi2d.plugin.ROI2DPointPlugin;
import plugins.kernel.roi.roi3d.plugin.ROI3DPointPlugin;
import plugins.perrine.ec_clem.ec_clem.roi.PointType;
import plugins.perrine.ec_clem.ec_clem.roi.RoiFactory;

public class NonFiducialRoiListener
implements SequenceListener {
    private static PointType type = PointType.NOT_FIDUCIAL;
    private RoiFactory roiFactory;

    @Inject
    public NonFiducialRoiListener(RoiFactory roiFactory) {
        this.roiFactory = roiFactory;
    }

    public void sequenceChanged(SequenceEvent event) {
        if (event.getSourceType() != SequenceEvent.SequenceEventSourceType.SEQUENCE_ROI || event.getType() != SequenceEvent.SequenceEventType.ADDED) {
            return;
        }
        ROI roi = this.roiFactory.getRoiFrom((ROI)event.getSource(), this.roiFactory.getFrom(event.getSequence(), type).size() + 1, type);
        Icy.getMainInterface().setSelectedTool(this.getSelectedTool(roi).getName());
    }

    public void sequenceClosed(Sequence sequence) {
    }

    private Class<?> getSelectedTool(ROI roi) {
        switch (roi.getDimension()) {
            case 2: {
                return ROI2DPointPlugin.class;
            }
            case 3: {
                return ROI3DPointPlugin.class;
            }
        }
        throw new RuntimeException("Unsupported dimension");
    }
}

