/*
 * Decompiled with CFR 0.152.
 */
package plugins.adufour.vars.gui.swing;

import icy.file.FileUtil;
import icy.gui.main.ActiveSequenceListener;
import icy.gui.main.GlobalSequenceListener;
import icy.main.Icy;
import icy.sequence.Sequence;
import icy.sequence.SequenceEvent;
import icy.util.StringUtil;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.ListCellRenderer;
import javax.swing.event.ListDataListener;
import plugins.adufour.vars.gui.swing.SwingVarEditor;
import plugins.adufour.vars.lang.Var;
import plugins.adufour.vars.lang.VarSequence;

public class SequenceChooser
extends SwingVarEditor<Sequence> {
    private SequenceListener listener;
    private JComboSequenceBoxListener jComboSequenceBoxListener;

    public SequenceChooser(Var<Sequence> variable) {
        super(variable);
    }

    @Override
    public JComponent createEditorComponent() {
        this.jComboSequenceBoxListener = new JComboSequenceBoxListener();
        final JComboBox<Object> jComboSequences = new JComboBox<Object>(new SequenceChooserModel());
        jComboSequences.setRenderer(new ListCellRenderer<Object>(){

            @Override
            public Component getListCellRendererComponent(JList<? extends Object> list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                if (value == null || value.equals("No Sequence")) {
                    return new JLabel("No Sequence");
                }
                if (value.equals("Active Sequence")) {
                    return new JLabel("Active Sequence");
                }
                if (value instanceof Sequence) {
                    String s = FileUtil.getFileName((String)((Sequence)value).getName());
                    JLabel label = new JLabel(StringUtil.limit((String)s, (int)24));
                    return label;
                }
                throw new IllegalArgumentException(value.toString());
            }
        });
        this.listener = new SequenceListener(){

            public void sequenceClosed(Sequence sequence) {
                if (SequenceChooser.this.variable.getReference() != null) {
                    return;
                }
                if (SequenceChooser.this.variable.getValue() == sequence) {
                    jComboSequences.setSelectedIndex(1);
                }
                jComboSequences.repaint();
                jComboSequences.updateUI();
            }

            public void sequenceOpened(Sequence sequence) {
                jComboSequences.repaint();
                jComboSequences.updateUI();
            }

            public void sequenceActivated(Sequence sequence) {
                if (SequenceChooser.this.variable.getReference() != null) {
                    return;
                }
                if (jComboSequences.getSelectedIndex() == 1) {
                    SequenceChooser.this.variable.setValueAsString("Active Sequence");
                }
                jComboSequences.repaint();
                jComboSequences.updateUI();
            }

            public void sequenceDeactivated(Sequence sequence) {
            }

            public void activeSequenceChanged(SequenceEvent event) {
            }
        };
        if (this.variable.getReference() == null) {
            this.variable.setValue(Icy.getMainInterface().getActiveSequence());
        }
        return jComboSequences;
    }

    @Override
    public Dimension getPreferredSize() {
        Dimension dim = super.getPreferredSize();
        dim.height = 20;
        return dim;
    }

    @Override
    public void dispose() {
        super.dispose();
        JComponent jComboSequences = this.getEditorComponent();
        ((JComboBox)jComboSequences).setRenderer(new DefaultListCellRenderer());
        ((JComboBox)jComboSequences).setModel(new DefaultComboBoxModel());
    }

    @Override
    protected void updateInterfaceValue() {
        Var v;
        JComponent editor = this.getEditorComponent();
        Var var = v = this.variable.getReference() != null ? this.variable.getReference() : this.variable;
        if (v instanceof VarSequence && ((VarSequence)v).isActiveSequenceSelected()) {
            ((JComboBox)editor).setSelectedIndex(1);
            editor.repaint();
        } else if (v.getValue() == null) {
            ((JComboBox)editor).setSelectedIndex(0);
            editor.repaint();
        } else {
            ((JComboBox)editor).setSelectedItem(v.getValue());
            editor.repaint();
        }
        this.getEditorComponent().setToolTipText("<html><pre><font size=3>" + this.variable.getValueAsString(true) + "</font></pre></html>");
    }

    @Override
    public JComboBox<Object> getEditorComponent() {
        return (JComboBox)super.getEditorComponent();
    }

    @Override
    protected void activateListeners() {
        Icy.getMainInterface().addGlobalSequenceListener((GlobalSequenceListener)this.listener);
        Icy.getMainInterface().addActiveSequenceListener((ActiveSequenceListener)this.listener);
        ((JComboBox)this.getEditorComponent()).addActionListener(this.jComboSequenceBoxListener);
    }

    @Override
    protected void deactivateListeners() {
        Icy.getMainInterface().removeGlobalSequenceListener((GlobalSequenceListener)this.listener);
        Icy.getMainInterface().removeActiveSequenceListener((ActiveSequenceListener)this.listener);
        ((JComboBox)this.getEditorComponent()).removeActionListener(this.jComboSequenceBoxListener);
    }

    private final class SequenceChooserModel
    extends DefaultComboBoxModel<Object> {
        private static final long serialVersionUID = 1L;

        public SequenceChooserModel() {
            this.setSelectedItem("Active Sequence");
        }

        @Override
        public int getSize() {
            return 2 + Icy.getMainInterface().getSequences().size();
        }

        @Override
        public Object getElementAt(int index) {
            if (index <= 0) {
                return "No Sequence";
            }
            if (index == 1) {
                return "Active Sequence";
            }
            return Icy.getMainInterface().getSequences().get(index - 2);
        }

        @Override
        public void addListDataListener(ListDataListener l) {
        }
    }

    private final class JComboSequenceBoxListener
    implements ActionListener {
        private JComboSequenceBoxListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            JComponent jComboSequences = SequenceChooser.this.getEditorComponent();
            Object o = ((JComboBox)jComboSequences).getSelectedItem();
            if (o == null || o.equals("No Sequence") || o.equals("Active Sequence")) {
                SequenceChooser.this.variable.setValueAsString((String)o);
            } else {
                Sequence newValue = (Sequence)o;
                jComboSequences.setToolTipText(newValue.getName());
                SequenceChooser.this.variable.setValue(newValue);
            }
        }
    }

    private static interface SequenceListener
    extends GlobalSequenceListener,
    ActiveSequenceListener {
    }
}

