/*
 * Decompiled with CFR 0.152.
 */
package plugins.nchenouard.particletracking.MHTracker;

import plugins.nchenouard.particletracking.MHTracker.Association;
import plugins.nchenouard.particletracking.MHTracker.Family;
import plugins.nchenouard.particletracking.MHTracker.HMMMHTracker;
import plugins.nchenouard.particletracking.MHTracker.MHTrack2s;
import plugins.nchenouard.particletracking.VirtualSpot;
import plugins.nchenouard.particletracking.filtering.Predictor;

public class MHTrack3s
extends MHTrack2s {
    public double p20 = 0.45;
    public double p21 = 0.45;
    public double p22 = 0.1;
    public double p12 = 0.05;
    public double p02 = 0.0;
    public double p1;
    public double p2;
    public double p1Pred;
    public double p2Pred;

    MHTrack3s(HMMMHTracker tracker, Predictor predictor, Association association, Family family) {
        super(0.5, tracker, predictor, association, family);
        this.p00 = 1.0;
        this.p01 = 0.0;
        this.p10 = 0.05;
        this.p11 = 0.9;
        this.p1 = this.pObs;
        this.p2 = 0.0;
        this.p1Pred = this.p11 * this.p1 + this.p21 * this.p2 + this.p01 * (1.0 - this.pObs);
        this.p2Pred = this.p22 * this.p2 + this.p12 * this.p1 + this.p02 * (1.0 - this.pObs);
        this.pPredObs = this.p1Pred + this.p2Pred;
    }

    private MHTrack3s() {
    }

    @Override
    public MHTrack2s copy() {
        MHTrack3s mtrack = new MHTrack3s();
        mtrack.predictor = this.predictor.copy();
        mtrack.likelihood = this.likelihood;
        mtrack.associationLikelihood = this.associationLikelihood;
        mtrack.score = this.score;
        mtrack.family = this.family;
        mtrack.association = this.association;
        mtrack.precedingSegment = this.precedingSegment;
        mtrack.tracker = this.tracker;
        mtrack.hypothesis = this.hypothesis;
        mtrack.confirmed = this.confirmed;
        mtrack.terminated = this.terminated;
        mtrack.pObs = this.pObs;
        mtrack.pPredObs = this.pPredObs;
        mtrack.p1 = this.p1;
        mtrack.p1Pred = this.p1Pred;
        mtrack.p2 = this.p2;
        mtrack.p2Pred = this.p2Pred;
        return mtrack;
    }

    @Override
    public void associate(Association a, int t) {
        this.association = a;
        double kL = this.tracker.totalGateLikelihood * this.kineticLikelihood(a.spot, true, this.tracker.gateFactor);
        double faL = this.falseAlarmLikelihood();
        this.associationLikelihood = kL * this.p1Pred + faL * (1.0 - this.pPredObs + this.p2Pred);
        this.likelihood *= this.associationLikelihood;
        this.score += Math.log(this.associationLikelihood);
        this.p1 = kL * this.p1Pred / this.associationLikelihood;
        this.p2 = faL * this.p2Pred / this.associationLikelihood;
        this.pObs = this.p1 + this.p2;
        this.p1Pred = this.p11 * this.p1 + this.p21 * this.p2 + this.p01 * (1.0 - this.pObs);
        this.p2Pred = this.p22 * this.p2 + this.p12 * this.p1 + this.p02 * (1.0 - this.pObs);
        this.pPredObs = this.p1Pred + this.p2Pred;
        if (this.pObs > this.pc) {
            this.confirmed = true;
        } else if (this.pObs < this.pt) {
            this.terminated = true;
        }
    }

    @Override
    public void prolongate(int t) {
        VirtualSpot pred = this.predictor.getCurrentPredictedStateAsSpot();
        this.association = new Association(null, pred, true, t, 0.0);
        double kL = 1.0 - this.tracker.totalGateLikelihood;
        double faL = 1.0;
        this.associationLikelihood = kL * this.p1Pred + faL * (1.0 - this.pPredObs + this.p2Pred);
        this.likelihood *= this.associationLikelihood;
        this.score += Math.log(this.associationLikelihood);
        this.p1 = kL * this.p1Pred / this.associationLikelihood;
        this.p2 = faL * this.p2Pred / this.associationLikelihood;
        this.pObs = this.p1 + this.p2;
        this.p1Pred = this.p11 * this.p1 + this.p21 * this.p2 + this.p01 * (1.0 - this.pObs);
        this.p2Pred = this.p22 * this.p2 + this.p12 * this.p1 + this.p02 * (1.0 - this.pObs);
        this.pPredObs = this.p1Pred + this.p2Pred;
        if (this.pObs > this.pc) {
            this.confirmed = true;
        } else if (this.pObs < this.pt) {
            this.terminated = true;
        }
    }
}

