/*
 * Decompiled with CFR 0.152.
 */
package plugins.nchenouard.particletracking.legacytracker.associationMethod;

import Jama.Matrix;
import java.util.ArrayList;
import plugins.nchenouard.particletracking.filtering.IMM2D;
import plugins.nchenouard.particletracking.filtering.IMM3D;
import plugins.nchenouard.particletracking.filtering.KalmanFilter;
import plugins.nchenouard.particletracking.filtering.LikelihoodMap;
import plugins.nchenouard.particletracking.filtering.Predictor;
import plugins.nchenouard.spot.Spot;

public class Track {
    protected int id = -1;
    protected ArrayList<Association> associations;
    protected int lastConsecutivePredictions = 0;
    protected int realValues = 0;
    protected Predictor predictor = null;
    protected double gateFactor;
    protected int firstIndex = -1;
    protected int lastIndex = -1;

    public Track() {
        this.associations = new ArrayList();
        this.firstIndex = 0;
        this.lastIndex = 0;
        this.gateFactor = 3.0;
    }

    public Track(int id, Predictor predictor, int firstIndex, double gateFactor) {
        this.id = id;
        this.associations = new ArrayList();
        this.predictor = predictor;
        this.firstIndex = firstIndex;
        this.lastIndex = firstIndex;
        this.gateFactor = gateFactor;
    }

    public void add(Spot spot, boolean isPrediction) {
        Matrix measurement = this.predictor.buildMeasurementMatrix(spot);
        this.add(measurement, spot, isPrediction);
    }

    public void add(Matrix state, Spot spot, boolean isPrediction) {
        if (state.getColumnDimension() != 1) {
            throw new IllegalArgumentException("state must be a vector");
        }
        if (isPrediction) {
            ++this.lastConsecutivePredictions;
        } else {
            ++this.realValues;
            this.lastConsecutivePredictions = 0;
        }
        this.associations.add(new Association(state, spot, isPrediction));
        ++this.lastIndex;
    }

    public void associate(Spot spot, int t) {
        this.predictor.update(spot, t);
        this.add(this.getEstimatedState(), spot, false);
    }

    public Matrix getEstimatedState() {
        return this.predictor.getCurrentEstimatedState();
    }

    public int getFirstIndex() {
        return this.firstIndex;
    }

    public int getId() {
        return this.id;
    }

    public int getLastConsecutivePredictions() {
        return this.lastConsecutivePredictions;
    }

    public int getLastIndex() {
        return this.lastIndex;
    }

    public Matrix getPredictedState() {
        return this.predictor.getCurrentPredictedState();
    }

    public Matrix getStateAtFrame(int frameIndex) {
        if (frameIndex < this.firstIndex || frameIndex > this.lastIndex || this.associations.size() <= frameIndex - this.firstIndex || this.associations.get(frameIndex - this.firstIndex) == null) {
            return null;
        }
        return this.associations.get((int)(frameIndex - this.firstIndex)).state;
    }

    public Spot getSpotAtFrame(int frameIndex) {
        if (frameIndex < this.firstIndex || frameIndex > this.lastIndex || this.associations.size() <= frameIndex - this.firstIndex || this.associations.get(frameIndex - this.firstIndex) == null) {
            return null;
        }
        return this.associations.get((int)(frameIndex - this.firstIndex)).spot;
    }

    public Spot getStateAsSpot(Matrix state) {
        return this.predictor.buildSpotFromState(state);
    }

    public double getTotalGateLikelihood() {
        return this.predictor.getTotalGateLikelihood(true, this.gateFactor);
    }

    public boolean isPredictionAtFrame(int frameIndex) {
        if (frameIndex < this.firstIndex || frameIndex > this.lastIndex || this.associations.size() <= frameIndex - this.firstIndex || this.associations.get(frameIndex - this.firstIndex) == null) {
            return true;
        }
        return this.associations.get((int)(frameIndex - this.firstIndex)).isPrediction;
    }

    public void initTrack(Spot firstSpot, int t) {
        this.predictor.initWithFirstElement(firstSpot, t);
        this.add(firstSpot, false);
    }

    public boolean isStillActive(int maxPred) {
        return this.lastConsecutivePredictions < maxPred;
    }

    public double likelihood(Spot s, boolean gated, double gateFactor) {
        return this.predictor.likelihood(s, gated, gateFactor);
    }

    public double loglikelihood(Spot s) {
        return this.predictor.loglikelihood(s);
    }

    public double minLikelihoodInGate() {
        return this.predictor.getCurrentMinLikelihoodInGate(this.gateFactor);
    }

    public double normalizedInnovation(Spot s) {
        return this.predictor.normalizedInnovation(s);
    }

    public void prolongate(int t) {
        this.predictor.update((Spot)null, t);
        this.add(this.getPredictedState(), this.predictor.getCurrentPredictedStateAsSpot(), true);
    }

    public LikelihoodMap getLikelihoodMap(double gateFactor, int t) {
        if (this.predictor instanceof IMM2D) {
            return ((IMM2D)this.predictor).getLikelihoodMap(gateFactor, t);
        }
        if (this.predictor instanceof IMM3D) {
            return ((IMM3D)this.predictor).getLikelihoodMap(gateFactor, t);
        }
        if (this.predictor instanceof KalmanFilter) {
            return ((KalmanFilter)this.predictor).getLikelihoodMap(gateFactor, t);
        }
        return null;
    }

    public LikelihoodMap[] getLikelihoodMapsIMM(double gateFactor, int t) {
        if (this.predictor instanceof IMM2D) {
            return ((IMM2D)this.predictor).getLikelihoodMapsIMM(gateFactor, t);
        }
        if (this.predictor instanceof IMM3D) {
            return ((IMM3D)this.predictor).getLikelihoodMapsIMM(gateFactor, t);
        }
        return null;
    }

    public double[] getIMMWeights() {
        if (this.predictor instanceof IMM2D) {
            return ((IMM2D)this.predictor).getWeights();
        }
        if (this.predictor instanceof IMM3D) {
            return ((IMM3D)this.predictor).getWeights();
        }
        return null;
    }

    class Association {
        Matrix state;
        Spot spot;
        boolean isPrediction;

        Association(Matrix state, Spot spot, boolean isPrediction) {
            this.state = state;
            this.spot = spot;
            this.isPrediction = isPrediction;
        }
    }
}

