/*
 * Decompiled with CFR 0.152.
 */
package plugins.tprovoost.Microscopy.MicroManager.gui;

import icy.plugin.PluginDescriptor;
import icy.plugin.PluginLauncher;
import icy.plugin.PluginLoader;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JPanel;
import javax.swing.JToolBar;
import javax.swing.border.TitledBorder;
import plugins.tprovoost.Microscopy.MicroManager.gui.MMMainFrame;
import plugins.tprovoost.Microscopy.MicroManager.tools.FrameUtils;
import plugins.tprovoost.Microscopy.MicroManagerForIcy.MicroscopePlugin;

public class PluginsToolbar
extends JPanel {
    private static final long serialVersionUID = -8211241234002062845L;
    final MMMainFrame mainFrame;
    JToolBar pluginToolbar;
    List<MicroscopePlugin> pluginList;

    public PluginsToolbar(MMMainFrame mainFrame) {
        this.mainFrame = mainFrame;
        this.pluginList = new ArrayList<MicroscopePlugin>();
        this.initialize(PluginLoader.getPlugins(MicroscopePlugin.class));
    }

    private void initialize(List<PluginDescriptor> plugins) {
        this.pluginToolbar = new JToolBar(0);
        this.pluginToolbar.setRollover(true);
        this.pluginToolbar.setFloatable(false);
        this.pluginToolbar.setToolTipText("Micro Manager plugins for Icy");
        for (final PluginDescriptor plugin : plugins) {
            this.pluginToolbar.add((Component)FrameUtils.createPluginButton(plugin, new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    MicroscopePlugin microscopePlugin = (MicroscopePlugin)PluginLauncher.start((PluginDescriptor)plugin);
                    if (microscopePlugin != null) {
                        PluginsToolbar.this.addPlugin(microscopePlugin);
                        microscopePlugin.start();
                    }
                }
            }));
        }
        this.setLayout(new BorderLayout());
        this.setBorder(new TitledBorder("Plugins"));
        this.add((Component)this.pluginToolbar, "Center");
    }

    public void onExposureChanged(double exposure) {
        for (MicroscopePlugin plugin : this.pluginList) {
            plugin.onExposureChanged(exposure);
        }
    }

    public void onCorePropertyChanged(String deviceName, String propName, String propValue) {
        for (MicroscopePlugin plugin : this.pluginList) {
            plugin.onCorePropertyChanged(deviceName, propName, propValue);
        }
    }

    public void onSystemConfigurationLoaded() {
        for (MicroscopePlugin plugin : this.pluginList) {
            plugin.onSystemConfigurationLoaded();
        }
    }

    public void addPlugin(MicroscopePlugin plugin) {
        if (plugin != null) {
            this.pluginList.add(plugin);
        }
    }

    public void removePlugin(MicroscopePlugin plugin) {
        if (plugin != null) {
            this.pluginList.remove((Object)plugin);
        }
    }

    public List<MicroscopePlugin> getRunningPlugins() {
        return new ArrayList<MicroscopePlugin>(this.pluginList);
    }

    public int getRunningPluginsCount() {
        return this.pluginList.size();
    }

    public void shutdownPlugins() {
        for (MicroscopePlugin plugin : this.getRunningPlugins()) {
            plugin.shutdown();
        }
    }
}

