/*
 * Decompiled with CFR 0.152.
 */
package plugins.danyfel80.roi.coloring;

import danyfel80.roi.coloring.RoiRandomColorizer;
import icy.main.Icy;
import icy.plugin.PluginDescriptor;
import icy.plugin.PluginLauncher;
import icy.plugin.PluginLoader;
import icy.roi.ROI;
import icy.sequence.Sequence;
import icy.system.IcyHandledException;
import plugins.adufour.blocks.lang.Block;
import plugins.adufour.blocks.util.VarList;
import plugins.adufour.ezplug.EzComponent;
import plugins.adufour.ezplug.EzPlug;
import plugins.adufour.ezplug.EzVarBoolean;
import plugins.adufour.ezplug.EzVarSequence;
import plugins.adufour.vars.lang.Var;
import plugins.adufour.vars.lang.VarROIArray;

public class ColorRoisRandomly
extends EzPlug
implements Block {
    private VarROIArray varInRois;
    private VarROIArray varOutRois;
    private EzVarSequence varInSequence;
    private EzVarBoolean varInSelectedRois;
    private ROI[] targetRois;

    public static void main(String[] args) {
        Icy.main((String[])args);
        PluginLauncher.start((PluginDescriptor)PluginLoader.getPlugin((String)ColorRoisRandomly.class.getName()));
    }

    public void declareInput(VarList inputMap) {
        this.varInRois = new VarROIArray("Target ROI(s)");
        inputMap.add("inRois", (Var)this.varInRois);
    }

    public void declareOutput(VarList outputMap) {
        this.varOutRois = new VarROIArray("Colored ROI(s)");
        outputMap.add("outRois", (Var)this.varOutRois);
    }

    protected void initialize() {
        this.varInSequence = new EzVarSequence("Sequence");
        this.varInSelectedRois = new EzVarBoolean("Selected ROIs", true);
        this.addEzComponent((EzComponent)this.varInSequence);
        this.addEzComponent((EzComponent)this.varInSelectedRois);
    }

    protected void execute() {
        try {
            this.retrieveTargetRois();
            this.applyColors();
            this.setOutput();
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new IcyHandledException("Error coloring rois: " + e.getMessage(), (Throwable)e);
        }
        finally {
            this.cleanReferences();
        }
    }

    private void retrieveTargetRois() {
        this.targetRois = !this.isHeadLess() ? (((Boolean)this.varInSelectedRois.getValue()).booleanValue() ? ((Sequence)this.varInSequence.getValue(true)).getSelectedROIs().toArray(new ROI[0]) : ((Sequence)this.varInSequence.getValue(true)).getROIs().toArray(new ROI[0])) : (ROI[])this.varInRois.getValue();
    }

    private void applyColors() {
        RoiRandomColorizer.colorize(this.targetRois);
    }

    private void setOutput() {
        if (this.isHeadLess()) {
            this.varOutRois.setValue((Object)this.targetRois);
        }
    }

    private void cleanReferences() {
        this.targetRois = null;
    }

    public void clean() {
    }
}

