/*
 * Decompiled with CFR 0.152.
 */
package plugins.adufour.activecontours;

import icy.math.ArrayMath;
import java.util.Arrays;

public class SlidingWindow {
    private double[] window;
    private int internalCount = 0;
    private int count = 0;

    public SlidingWindow(int size) {
        this.setSize(size);
    }

    public int getSize() {
        return this.window.length;
    }

    public void setSize(int size) {
        this.window = new double[size];
        this.internalCount = 0;
        this.count = 0;
    }

    public final void push(double value) {
        if ((this.internalCount++ & 1) == 1) {
            return;
        }
        this.window[this.count % this.window.length] = value;
        ++this.count;
    }

    public void clear() {
        Arrays.fill(this.window, 0.0);
        this.count = 0;
    }

    public Double computeCriterion(Operation operation) {
        if (this.count < this.window.length) {
            return null;
        }
        switch (operation) {
            case NONE: {
                return null;
            }
            case MIN: {
                return ArrayMath.min((double[])this.window);
            }
            case MAX: {
                return ArrayMath.max((double[])this.window);
            }
            case MEAN: {
                return ArrayMath.mean((double[])this.window);
            }
            case SUM: {
                return ArrayMath.sum((double[])this.window);
            }
            case VARIANCE: {
                return ArrayMath.var((double[])this.window, (boolean)true);
            }
            case VAR_COEFF: {
                return ArrayMath.std((double[])this.window, (boolean)false) / ArrayMath.mean((double[])this.window);
            }
        }
        throw new UnsupportedOperationException("operation " + operation.toString() + " not supported yet");
    }

    public static enum Operation {
        NONE,
        MIN,
        MAX,
        MEAN,
        SUM,
        VARIANCE,
        VAR_COEFF;

    }
}

