/*
 * Decompiled with CFR 0.152.
 */
package plugins.adufour.activecontours;

import icy.gui.viewer.Viewer;
import icy.image.IcyBufferedImage;
import icy.image.IcyBufferedImageUtil;
import icy.main.Icy;
import icy.math.ArrayMath;
import icy.math.Scaler;
import icy.painter.Overlay;
import icy.roi.BooleanMask2D;
import icy.roi.BooleanMask3D;
import icy.roi.ROI;
import icy.roi.ROI2D;
import icy.roi.ROI3D;
import icy.roi.ROIUtil;
import icy.sequence.DimensionId;
import icy.sequence.Sequence;
import icy.sequence.SequenceUtil;
import icy.swimmingPool.SwimmingObject;
import icy.system.IcyHandledException;
import icy.system.SystemUtil;
import icy.system.thread.Processor;
import icy.system.thread.ThreadUtil;
import icy.type.DataType;
import icy.type.collection.CollectionUtil;
import icy.type.rectangle.Rectangle3D;
import icy.util.OMEUtil;
import icy.util.ShapeUtil;
import icy.util.StringUtil;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.image.BufferedImage;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import javax.vecmath.Point3d;
import javax.vecmath.Tuple3d;
import ome.xml.meta.MetadataRetrieve;
import plugins.adufour.activecontours.ActiveContour;
import plugins.adufour.activecontours.ActiveContoursOverlay;
import plugins.adufour.activecontours.Mesh3D;
import plugins.adufour.activecontours.Polygon2D;
import plugins.adufour.activecontours.ReSampler;
import plugins.adufour.activecontours.SlidingWindow;
import plugins.adufour.activecontours.TopologyException;
import plugins.adufour.blocks.lang.Block;
import plugins.adufour.blocks.util.VarList;
import plugins.adufour.ezplug.EzButton;
import plugins.adufour.ezplug.EzComponent;
import plugins.adufour.ezplug.EzException;
import plugins.adufour.ezplug.EzGroup;
import plugins.adufour.ezplug.EzPlug;
import plugins.adufour.ezplug.EzStoppable;
import plugins.adufour.ezplug.EzVar;
import plugins.adufour.ezplug.EzVarBoolean;
import plugins.adufour.ezplug.EzVarDimensionPicker;
import plugins.adufour.ezplug.EzVarDouble;
import plugins.adufour.ezplug.EzVarEnum;
import plugins.adufour.ezplug.EzVarInteger;
import plugins.adufour.ezplug.EzVarListener;
import plugins.adufour.ezplug.EzVarSequence;
import plugins.adufour.filtering.Convolution1D;
import plugins.adufour.filtering.Kernels1D;
import plugins.adufour.hierarchicalkmeans.HKMeans;
import plugins.adufour.vars.lang.Var;
import plugins.adufour.vars.lang.VarBoolean;
import plugins.adufour.vars.lang.VarROIArray;
import plugins.adufour.vars.lang.VarSequence;
import plugins.adufour.vars.util.VarException;
import plugins.fab.trackmanager.TrackGroup;
import plugins.fab.trackmanager.TrackManager;
import plugins.fab.trackmanager.TrackSegment;
import plugins.kernel.roi.roi2d.ROI2DArea;
import plugins.kernel.roi.roi2d.ROI2DPolygon;
import plugins.kernel.roi.roi2d.ROI2DRectangle;
import plugins.kernel.roi.roi3d.ROI3DStack;
import plugins.nchenouard.spot.Detection;
import vtk.vtkObjectBase;

public class ActiveContours
extends EzPlug
implements EzStoppable,
Block {
    public static final String CONTOUR_BASE_NAME = "Contour #";
    public static final String CONTOUR_ID = "contourId";
    private final double EPSILON = 1.0E-7;
    private final EzVarBoolean showAdvancedOptions = new EzVarBoolean("Show advanced options", false);
    public final EzVarSequence input = new EzVarSequence("Input");
    private Sequence inputData;
    public final EzVarDouble regul_weight = new EzVarDouble("Contour smoothness", 0.05, 0.0, 1.0, 0.01);
    public final EzGroup edge = new EzGroup("Find bright/dark edges", new EzComponent[0]);
    public final EzVarDimensionPicker edge_c = new EzVarDimensionPicker("Find edges in channel", DimensionId.C, this.input);
    public final EzVarDouble edge_weight = new EzVarDouble("Edge weight", 0.0, -1.0, 1.0, 0.1);
    public final EzGroup region = new EzGroup("Find homogeneous intensity areas", new EzComponent[0]);
    public final EzVarDimensionPicker region_c = new EzVarDimensionPicker("Find regions in channel", DimensionId.C, this.input);
    public final EzVarDouble region_weight = new EzVarDouble("Region weight", 1.0, 0.0, 1.0, 0.1);
    public final EzVarDouble region_sensitivity = new EzVarDouble("Region sensitivity", 1.0, 0.2, 5.0, 0.1);
    public final EzVarBoolean region_localise = new EzVarBoolean("Variable background", false);
    public final EzVarDouble balloon_weight = new EzVarDouble("Contour inflation", 0.0, -0.5, 0.5, 0.001);
    public final EzVarDouble axis_weight = new EzVarDouble("Axis constraint", 0.0, 0.0, 1.0, 0.1);
    public final EzVarBoolean coupling_flag = new EzVarBoolean("Multi-contour coupling", true);
    public final EzGroup evolution = new EzGroup("Evolution parameters", new EzComponent[0]);
    public final EzVarSequence evolution_bounds = new EzVarSequence("Bound field to ROI of");
    public final EzVarDouble contour_resolution = new EzVarDouble("Contour sampling", 2.0, 0.1, 10000.0, 0.1);
    public final EzVarDouble contour_timeStep = new EzVarDouble("Evolution time step", 0.1, 0.1, 10.0, 0.01);
    public final EzVarInteger convergence_winSize = new EzVarInteger("Convergence window size", 50, 10, 10000, 10);
    public final EzVarEnum<SlidingWindow.Operation> convergence_operation = new EzVarEnum("Convergence operation", (Enum[])SlidingWindow.Operation.values(), (Enum)SlidingWindow.Operation.VAR_COEFF);
    public final EzVarDouble convergence_criterion = new EzVarDouble("Convergence criterion", 0.001, 0.0, 1.0, 1.0E-4);
    public final EzVarInteger convergence_nbIter = new EzVarInteger("Max. iterations", 100000, 100, 100000, 1000);
    public final EzVarEnum<ExportROI> output_rois = new EzVarEnum("Export ROI", (Enum[])ExportROI.values(), (Enum)ExportROI.NO);
    public final EzVarEnum<ROIType> output_roiType = new EzVarEnum("Type of ROI", (Enum[])ROIType.values(), (Enum)ROIType.AREA);
    private final VarSequence output_labels = new VarSequence("Labels", null);
    public final EzVarBoolean tracking = new EzVarBoolean("Track objects over time", false);
    public final EzVarDouble division_sensitivity = new EzVarDouble("Division sensitivity", 0.0, 0.0, 2.0, 0.1);
    public final EzVarBoolean tracking_newObjects = new EzVarBoolean("Watch entering objects", false);
    private final HashMap<TrackSegment, Double> volumes = new HashMap();
    public final EzVarBoolean volume_constraint = new EzVarBoolean("Volume constraint", false);
    public final EzVarDouble volume_weight = new EzVarDouble("Volume weight", 0.01, 0.0, 1.0, 0.001);
    public final EzButton showTrackManager;
    private Sequence edgeData;
    private Sequence regionData;
    private Sequence regionDataSummed;
    private BooleanMask3D contourMask_buffer;
    HashMap<TrackSegment, Double> region_cin = new HashMap(0);
    HashMap<TrackSegment, Double> region_cout = new HashMap(0);
    public final VarROIArray roiInput = new VarROIArray("input ROI");
    public final VarROIArray roiOutput = new VarROIArray("Regions of interest");
    private boolean globalStop;
    Var<TrackGroup> trackGroup = new Var("Tracks", TrackGroup.class);
    private final HashSet<ActiveContour> allContoursAtTimeT = new HashSet();
    private final HashSet<ActiveContour> evolvingContoursAtTimeT = new HashSet();
    private ActiveContoursOverlay overlay;
    private final Processor multiThreadService = new Processor(SystemUtil.getNumberOfCPUs());
    private long lastVtkGCTime = 0L;

    public ActiveContours() {
        this.multiThreadService.setThreadName("Active Contours");
        this.showTrackManager = new EzButton("Send to track manager", new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ThreadUtil.invokeLater((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        if (ActiveContours.this.trackGroup.getValue() == null) {
                            return;
                        }
                        if (((TrackGroup)ActiveContours.this.trackGroup.getValue()).getTrackSegmentList().isEmpty()) {
                            return;
                        }
                        Icy.getMainInterface().getSwimmingPool().add(new SwimmingObject(ActiveContours.this.trackGroup.getValue()));
                        TrackManager tm = new TrackManager();
                        tm.reOrganize();
                        tm.setDisplaySequence(ActiveContours.this.inputData);
                    }
                });
            }
        });
    }

    public TrackGroup getTrackGroup() {
        return (TrackGroup)this.trackGroup.getValue();
    }

    public void initialize() {
        this.addEzComponent((EzComponent)this.showAdvancedOptions);
        this.addEzComponent((EzComponent)this.input);
        this.edge.setToolTipText("Sets the contour(s) to follow image intensity gradients");
        this.edge_weight.setToolTipText("Negative (resp. positive) weight pushes contours toward decreasing (resp. increasing) intensities");
        this.edge.add(new EzComponent[]{this.edge_c, this.edge_weight});
        this.addEzComponent((EzComponent)this.edge);
        this.region.setToolTipText("Sets the contour(s) to isolate homogeneous intensity regions");
        this.region_weight.setToolTipText("Set to 0 to deactivate this parameter");
        this.region_sensitivity.setToolTipText("Increase this value to be more sensitive to dim objects (default: 1)");
        this.region_localise.setToolTipText("Check this box if the image background is noisy or non-homogeneous");
        this.showAdvancedOptions.addVisibilityTriggerTo((EzComponent)this.region_sensitivity, (Object[])new Boolean[]{true});
        this.showAdvancedOptions.addVisibilityTriggerTo((EzComponent)this.region_localise, (Object[])new Boolean[]{true});
        this.region.add(new EzComponent[]{this.region_c, this.region_weight, this.region_sensitivity});
        this.addEzComponent((EzComponent)this.region);
        this.coupling_flag.setToolTipText("Prevents multiple contours from overlapping");
        this.showAdvancedOptions.addVisibilityTriggerTo((EzComponent)this.coupling_flag, (Object[])new Boolean[]{true});
        this.addEzComponent((EzComponent)this.coupling_flag);
        this.regul_weight.setToolTipText("Higher values result in a smoother contour, but may also slow its growth");
        this.addEzComponent((EzComponent)this.regul_weight);
        this.balloon_weight.setToolTipText("Positive (resp. negative) values will inflate (resp. deflate) the contour");
        this.addEzComponent((EzComponent)this.balloon_weight);
        this.axis_weight.setToolTipText("Higher values restrict the evolution along the principal axis");
        this.addEzComponent((EzComponent)this.axis_weight);
        this.division_sensitivity.setToolTipText("Increase the sensitivity to cell division");
        this.showAdvancedOptions.addVisibilityTriggerTo((EzComponent)this.division_sensitivity, (Object[])new Boolean[]{true});
        this.addEzComponent((EzComponent)this.division_sensitivity);
        this.contour_resolution.setToolTipText("Sets the contour(s) precision as the distance (in pixels) between control points");
        this.contour_timeStep.setToolTipText("Defines the evolution speed (warning: keep a low value to avoid vibration effects)");
        this.convergence_winSize.setToolTipText("Defines over how many iterations the algorithm should check for convergence");
        this.showAdvancedOptions.addVisibilityTriggerTo((EzComponent)this.convergence_winSize, (Object[])new Boolean[]{true});
        this.convergence_operation.setToolTipText("Defines the operation used to detect convergence");
        this.showAdvancedOptions.addVisibilityTriggerTo(this.convergence_operation, (Object[])new Boolean[]{true});
        this.convergence_criterion.setToolTipText("Defines the value of the criterion used to detect convergence");
        this.convergence_nbIter.setToolTipText("Defines the absolute number of iterations to use in case the contour does not converge automatically");
        this.showAdvancedOptions.addVisibilityTriggerTo((EzComponent)this.convergence_nbIter, (Object[])new Boolean[]{true});
        this.evolution_bounds.setNoSequenceSelection();
        this.evolution_bounds.setToolTipText("Bounds the evolution of the contour to all ROI of the given sequence (select \"No sequence\" to deactivate)");
        this.showAdvancedOptions.addVisibilityTriggerTo((EzComponent)this.evolution_bounds, (Object[])new Boolean[]{true});
        this.evolution.add(new EzComponent[]{this.evolution_bounds, this.contour_resolution, this.contour_timeStep, this.convergence_winSize, this.convergence_operation, this.convergence_criterion, this.convergence_nbIter});
        this.addEzComponent((EzComponent)this.evolution);
        this.output_rois.setToolTipText("Select whether and where to export the contours as ROI for further quantification");
        this.addEzComponent((EzComponent)this.output_rois);
        this.output_roiType.setToolTipText("Select the type of ROI to export");
        this.addEzComponent((EzComponent)this.output_roiType);
        this.output_rois.addVisibilityTriggerTo(this.output_roiType, (Object[])new ExportROI[]{ExportROI.ON_INPUT, ExportROI.ON_NEW_IMAGE});
        this.tracking.setToolTipText("Track objects over time");
        this.addEzComponent((EzComponent)this.tracking);
        this.addEzComponent((EzComponent)this.tracking_newObjects);
        this.tracking.addVisibilityTriggerTo((EzComponent)this.tracking_newObjects, (Object[])new Boolean[]{true});
        this.addEzComponent((EzComponent)this.volume_constraint);
        this.tracking.addVisibilityTriggerTo((EzComponent)this.volume_constraint, (Object[])new Boolean[]{true});
        this.addEzComponent((EzComponent)this.volume_weight);
        this.volume_constraint.addVisibilityTriggerTo((EzComponent)this.volume_weight, (Object[])new Boolean[]{true});
        this.addEzComponent((EzComponent)this.showTrackManager);
        this.setTimeDisplay(true);
        this.volume_constraint.setValue((Object)Boolean.FALSE);
    }

    public void loadParameters(File file) {
        super.loadParameters(file);
        this.volume_constraint.setValue((Object)Boolean.FALSE);
    }

    public void execute() {
        ArrayList rois;
        TrackGroup tracks;
        int endT;
        this.output_labels.setValue(null);
        this.volumes.clear();
        this.roiOutput.setValue(null);
        this.inputData = (Sequence)this.input.getValue(true);
        Viewer viewer = this.inputData.getFirstViewer();
        this.globalStop = false;
        int startT = viewer == null ? 0 : viewer.getPositionT();
        int n = endT = (Boolean)this.tracking.getValue() != false ? this.inputData.getSizeT() - 1 : startT;
        if (this.overlay != null) {
            this.overlay.remove();
        }
        if ((tracks = (TrackGroup)this.trackGroup.getValue(false)) != null) {
            tracks.clearAllTrackSegment();
        }
        tracks = new TrackGroup(this.inputData);
        tracks.setDescription("Active contours (" + new Date().toString() + ")");
        this.trackGroup.setValue((Object)tracks);
        Rectangle3D.Integer bounds3d = this.inputData.getBounds5D().toRectangle3D().toInteger();
        Rectangle bounds2d = this.inputData.getBounds2D();
        BooleanMask2D[] maskSlices = new BooleanMask2D[bounds3d.sizeZ];
        for (int z = 0; z < bounds3d.sizeZ; ++z) {
            maskSlices[z] = new BooleanMask2D(bounds2d, new boolean[bounds3d.sizeX * bounds3d.sizeY]);
        }
        this.contourMask_buffer = new BooleanMask3D(bounds3d, maskSlices);
        if (!Icy.getMainInterface().isHeadLess()) {
            for (Overlay existingOverlay : this.inputData.getOverlays()) {
                if (!(existingOverlay instanceof ActiveContoursOverlay)) continue;
                existingOverlay.remove();
            }
            this.overlay = new ActiveContoursOverlay(tracks);
            this.overlay.setPriority(Overlay.OverlayPriority.TOPMOST);
            this.inputData.addOverlay((Overlay)this.overlay);
        }
        if (this.getUI() != null) {
            this.roiInput.setValue((Object)new ROI[0]);
        }
        ROI field = null;
        Sequence boundSource = (Sequence)this.evolution_bounds.getValue();
        if (boundSource != null && (rois = boundSource.getROIs()).size() > 0) {
            try {
                field = ROIUtil.merge((List)rois, (ShapeUtil.BooleanOperator)ShapeUtil.BooleanOperator.OR);
            }
            catch (UnsupportedOperationException e) {
                throw new VarException((Var)this.evolution_bounds.getVariable(), "Cannot compute the evolution bounds: " + e.getMessage() + "\nIf you are not sure how to fix this, change this parameter to \"No Sequence\"");
            }
        }
        if (field == null) {
            if (this.inputData.getSizeZ() == 1) {
                field = new ROI2DRectangle(0.0, 0.0, (double)this.inputData.getWidth(), (double)this.inputData.getHeight());
            } else {
                ROI3DStack field3D = new ROI3DStack(ROI2DRectangle.class);
                for (int z = 0; z < this.inputData.getSizeZ() - 1; ++z) {
                    field3D.setSlice(z, (ROI2D)new ROI2DRectangle(0.0, 0.0, (double)this.inputData.getWidth(), (double)this.inputData.getHeight()));
                }
                field = field3D;
            }
        }
        for (int t = startT; t <= endT && t < this.inputData.getSizeT(); ++t) {
            int iteration;
            if (this.isHeadLess()) {
                System.out.println("Processing frame #" + t);
            }
            if (viewer != null) {
                viewer.setPositionT(t);
            }
            if (this.isHeadLess()) {
                System.out.println("=> preparing image data...");
            }
            this.initData(t);
            if (Thread.currentThread().isInterrupted()) break;
            if (this.isHeadLess()) {
                System.out.println("=> initializing current contours...");
            }
            this.initCurrentContours(t);
            if (this.isHeadLess()) {
                System.out.println("=> evolving current contours...");
            }
            if ((iteration = this.evolveContours(t, field)) > 0) {
                System.out.println("[Active Contours] converged current contours on frame " + t + " in " + iteration + " iterations");
            }
            if (Thread.currentThread().isInterrupted()) break;
            if (this.isHeadLess()) {
                System.out.println("=> adding new contours...");
            }
            this.addNewContours(t);
            if (Thread.currentThread().isInterrupted()) break;
            if (this.isHeadLess()) {
                System.out.println("=> evolving new contours...");
            }
            if (!((iteration = this.evolveContours(t, field)) != -1 || ((Boolean)this.tracking_newObjects.getValue()).booleanValue() && this.inputData.getSizeZ() == 1 || this.hasFutureRois(t))) {
                this.storeResult(t);
                break;
            }
            if (iteration > 0) {
                System.out.println("[Active Contours] converged new contours on frame " + t + " in " + iteration + " iterations");
            }
            this.storeResult(t);
            if (Thread.currentThread().isInterrupted() || this.globalStop) break;
        }
        int maxId = 0;
        for (ROI roi : (ROI[])this.roiOutput.getValue()) {
            try {
                int contourId = Integer.parseInt(roi.getProperty(CONTOUR_ID));
                if (contourId <= maxId) continue;
                maxId = contourId;
            }
            catch (Exception contourId) {
                // empty catch block
            }
        }
        int nbPaddingDigits = (int)Math.floor(Math.log10(maxId));
        for (ROI roi : (ROI[])this.roiOutput.getValue()) {
            try {
                int contourId = Integer.parseInt(roi.getProperty(CONTOUR_ID));
                String roiName = roi.getName();
                if (StringUtil.isEmpty((String)roiName)) {
                    roi.setName(CONTOUR_BASE_NAME + StringUtil.toString((int)contourId, (int)nbPaddingDigits));
                    continue;
                }
                roi.setName(CONTOUR_BASE_NAME + StringUtil.toString((int)contourId, (int)nbPaddingDigits) + " (" + roiName + ")");
            }
            catch (Exception contourId) {
                // empty catch block
            }
        }
        if (this.getUI() != null) {
            Sequence out = this.inputData;
            switch ((ExportROI)((Object)this.output_rois.getValue())) {
                case ON_NEW_IMAGE: {
                    out = SequenceUtil.getCopy((Sequence)this.inputData);
                    out.setName(this.inputData.getName() + " + Active contours");
                }
                case ON_INPUT: {
                    for (ROI roi : (ROI[])this.roiOutput.getValue()) {
                        out.addROI(roi, false);
                    }
                    if (out == this.inputData) break;
                    this.addSequence(out);
                    break;
                }
                case AS_LABELS: {
                    this.addSequence((Sequence)this.output_labels.getValue());
                    break;
                }
            }
        }
        if (this.output_rois.getValue() != ExportROI.NO && this.overlay != null) {
            this.overlay.remove();
        }
        this.multiThreadService.waitAll();
        for (TrackSegment ts : this.region_cin.keySet()) {
            if (ts == null) continue;
            ts.removeId();
        }
        for (TrackSegment ts : this.region_cout.keySet()) {
            if (ts == null) continue;
            ts.removeId();
        }
        this.region_cin.clear();
        this.region_cout.clear();
        this.allContoursAtTimeT.clear();
        this.inputData = null;
        this.edgeData = null;
        this.regionData = null;
        this.regionDataSummed = null;
    }

    boolean executeMultiThread(Collection<Callable<Object>> tasks, String messageOnError) throws Exception {
        try {
            for (Future res : this.multiThreadService.invokeAll(tasks)) {
                res.get();
            }
            return true;
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
        catch (Exception e) {
            if (StringUtil.isEmpty((String)messageOnError)) {
                throw e;
            }
            e.printStackTrace();
            System.err.println("Warning: " + messageOnError + "(reason: " + e.getMessage() + ").");
        }
        return false;
    }

    private void initData(int t) {
        int edgeChannel = (Integer)this.edge_c.getValue();
        int regionChannel = (Integer)this.region_c.getValue();
        if (edgeChannel >= this.inputData.getSizeC()) {
            throw new IcyHandledException("The selected edge channel is invalid.");
        }
        if (regionChannel >= this.inputData.getSizeC()) {
            throw new IcyHandledException("The selected region channel is invalid.");
        }
        Rectangle3D.Integer bounds = new Rectangle3D.Integer();
        bounds.sizeX = this.inputData.getSizeX();
        bounds.sizeY = this.inputData.getSizeY();
        bounds.sizeZ = this.inputData.getSizeZ();
        Sequence currentFrame = SequenceUtil.extractFrame((Sequence)this.inputData, (int)t);
        currentFrame.loadAllData();
        double[] edgeBnds = currentFrame.getChannelBounds(edgeChannel);
        double[] regionBnds = currentFrame.getChannelBounds(regionChannel);
        Scaler edgeScaler = new Scaler(edgeBnds[0], edgeBnds[1], 0.0, 1.0, false);
        Scaler regionScaler = new Scaler(regionBnds[0], regionBnds[1], 0.0, 1.0, false);
        this.edgeData = new Sequence(OMEUtil.createOMEXMLMetadata((MetadataRetrieve)this.inputData.getOMEXMLMetadata()), "edge data");
        this.regionData = new Sequence(OMEUtil.createOMEXMLMetadata((MetadataRetrieve)this.inputData.getOMEXMLMetadata()), "region data");
        for (int z = 0; z < bounds.sizeZ; ++z) {
            IcyBufferedImage img = currentFrame.getImage(0, z, edgeChannel);
            img = IcyBufferedImageUtil.convertType((IcyBufferedImage)img, (DataType)DataType.FLOAT, (Scaler[])new Scaler[]{edgeScaler});
            this.edgeData.setImage(0, z, (BufferedImage)img);
            img = currentFrame.getImage(0, z, regionChannel);
            img = IcyBufferedImageUtil.convertType((IcyBufferedImage)img, (DataType)DataType.FLOAT, (Scaler[])new Scaler[]{regionScaler});
            this.regionData.setImage(0, z, (BufferedImage)img);
        }
        try {
            Sequence gaussian = Kernels1D.CUSTOM_GAUSSIAN.createGaussianKernel1D(1.0).toSequence();
            Convolution1D.convolve((Sequence)this.edgeData, (Sequence)gaussian, (Sequence)gaussian, null);
            Convolution1D.convolve((Sequence)this.regionData, (Sequence)gaussian, (Sequence)gaussian, null);
        }
        catch (Exception e) {
            System.err.println("Warning: error while smoothing the signal: " + e.getMessage());
        }
        this.regionDataSummed = SequenceUtil.getCopy((Sequence)this.regionData);
        for (int z = 0; z < bounds.sizeZ; ++z) {
            float[] regionDataSliceSummed = this.regionDataSummed.getDataXYAsFloat(0, z, 0);
            for (int j = 0; j < bounds.sizeY; ++j) {
                int offset = j * bounds.sizeX + 1;
                int i = 1;
                while (i < bounds.sizeX) {
                    int n = offset;
                    regionDataSliceSummed[n] = regionDataSliceSummed[n] + regionDataSliceSummed[offset - 1];
                    ++i;
                    ++offset;
                }
            }
            this.regionDataSummed.setDataXY(0, z, 0, (Object)regionDataSliceSummed);
        }
    }

    private void initCurrentContours(int t) {
        int convWinSize = (Integer)this.convergence_winSize.getValue() * 2;
        ArrayList<Callable<Object>> tasks = new ArrayList<Callable<Object>>();
        try {
            for (TrackSegment segment : ((TrackGroup)this.trackGroup.getValue()).getTrackSegmentList()) {
                tasks.add(new ContourDuplicator(segment, t, convWinSize));
            }
            this.executeMultiThread(tasks, "couldn't duplicate a contour");
        }
        catch (Exception e) {
            e.printStackTrace();
            System.err.println("Warning:  (reason: " + e.getMessage() + "). Moving on...");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addNewContours(int t) {
        TrackGroup tg = (TrackGroup)this.trackGroup.getValue();
        ArrayList tracks = ((TrackGroup)this.trackGroup.getValue()).getTrackSegmentList();
        int convWinSize = (Integer)this.convergence_winSize.getValue() * 2;
        Viewer viewer = this.inputData.getFirstViewer();
        int currentZ = viewer != null ? viewer.getPositionZ() : 0;
        Point3d pixelSize = new Point3d(this.inputData.getPixelSizeX(), this.inputData.getPixelSizeY(), this.inputData.getPixelSizeZ());
        List<TrackSegment> activeTracks = this.getTracksEndingAt(tracks, t);
        List<TrackSegment> justEndedTracks = this.getTracksEndingAt(tracks, t - 1);
        List<ROI> objects = this.getNewObjectsFor(t);
        ArrayList<ContourInitializer> tasks = new ArrayList<ContourInitializer>();
        ArrayList<TrackSegment> newTracks = new ArrayList<TrackSegment>();
        try {
            for (ROI roi : objects) {
                tasks.add(new ContourInitializer(roi, currentZ, t, (Tuple3d)pixelSize, convWinSize, activeTracks, justEndedTracks));
            }
            for (Future res : this.multiThreadService.invokeAll(tasks)) {
                TrackSegment track = (TrackSegment)res.get();
                if (track == null) continue;
                newTracks.add(track);
            }
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
        catch (Exception e) {
            e.printStackTrace();
            System.err.println("Warning: couldn't initialize a contour (reason: " + e.getMessage() + ").");
        }
        Object object = tg;
        synchronized (object) {
            for (TrackSegment track : newTracks) {
                tg.addTrackSegment(track);
            }
        }
        object = this.region_cin;
        synchronized (object) {
            for (TrackSegment track : newTracks) {
                this.region_cin.put(track, 0.0);
            }
        }
        object = this.region_cout;
        synchronized (object) {
            for (TrackSegment track : newTracks) {
                this.region_cout.put(track, 0.0);
            }
        }
    }

    private List<TrackSegment> getTracksEndingAt(List<TrackSegment> tracks, int t) {
        ArrayList<TrackSegment> result = new ArrayList<TrackSegment>();
        if (t >= 0) {
            for (TrackSegment track : tracks) {
                Detection detection = track.getLastDetection();
                if (detection == null || detection.getT() != t) continue;
                result.add(track);
            }
        }
        return result;
    }

    private boolean hasFutureRois(int t) {
        ArrayList rois = CollectionUtil.asArrayList((Object[])((Object[])this.roiInput.getValue()));
        if (rois.isEmpty()) {
            if (this.isHeadLess()) {
                return false;
            }
            rois = this.inputData.getROIs();
        }
        if (rois.isEmpty()) {
            return false;
        }
        for (ROI roi : rois) {
            if (!(roi instanceof ROI2D ? ((ROI2D)roi).getT() >= t : roi instanceof ROI3D && ((ROI3D)roi).getT() >= t)) continue;
            return true;
        }
        return false;
    }

    private List<ROI> getRoisOf(int t) {
        ArrayList result = CollectionUtil.asArrayList((Object[])((Object[])this.roiInput.getValue()));
        if (result.isEmpty()) {
            if (this.isHeadLess()) {
                throw new VarException((Var)this.roiInput, "Active contours: no input ROI");
            }
            result = this.inputData.getROIs();
        }
        if (result.isEmpty()) {
            throw new VarException((Var)this.input.getVariable(), "Please draw or select a ROI");
        }
        for (int i = result.size() - 1; i >= 0; --i) {
            int rt;
            ROI roi = (ROI)result.get(i);
            if (roi instanceof ROI2D) {
                rt = ((ROI2D)roi).getT();
                if (rt == -1) {
                    if (t <= 0) continue;
                    result.remove(i);
                    continue;
                }
                if (rt == t) continue;
                result.remove(i);
                continue;
            }
            if (roi instanceof ROI3D) {
                rt = ((ROI3D)roi).getT();
                if (rt == -1) {
                    if (t <= 0) continue;
                    result.remove(i);
                    continue;
                }
                if (rt == t) continue;
                result.remove(i);
                continue;
            }
            result.remove(i);
        }
        return result;
    }

    private List<ROI> getWorkRois(ROI roi) {
        int minPoints = (int)((Double)this.contour_resolution.getValue() * 3.0);
        ArrayList<ROI> result = new ArrayList<ROI>();
        if (roi instanceof ROI2DArea) {
            ROI2DArea area = (ROI2DArea)roi;
            BooleanMask2D mask = area.getBooleanMask(true);
            BooleanMask2D[] components = mask.getComponents();
            if (components.length > 1) {
                for (BooleanMask2D comp : components) {
                    if (comp.getNumberOfPoints() < minPoints) continue;
                    ROI2DArea newArea = new ROI2DArea(comp);
                    newArea.setZ(area.getZ());
                    newArea.setT(area.getT());
                    newArea.setC(area.getC());
                    result.add((ROI)newArea);
                }
            } else if (mask.getNumberOfPoints() >= minPoints) {
                result.add(roi.getCopy());
            }
        } else {
            result.add(roi.getCopy());
        }
        return result;
    }

    private List<ROI> getNewObjectsFor(int t) {
        ArrayList<ROI> result = new ArrayList<ROI>();
        for (ROI roi : this.getRoisOf(t)) {
            result.addAll(this.getWorkRois(roi));
        }
        if (((Boolean)this.tracking_newObjects.getValue()).booleanValue() && this.inputData.getSizeZ() == 1) {
            Collection<Double> allVolumes = this.volumes.values();
            double minVol = 0.0;
            double maxVol = 0.0;
            double meanVol = 0.0;
            if (!allVolumes.isEmpty()) {
                for (Double volume : allVolumes) {
                    double v = volume;
                    if (minVol == 0.0 || v < minVol) {
                        minVol = v;
                    }
                    if (maxVol == 0.0 || v > maxVol) {
                        maxVol = v;
                    }
                    meanVol += v;
                }
                meanVol /= (double)allVolumes.size();
            }
            minVol *= 0.3;
            maxVol *= 4.0;
            if (minVol < meanVol / 5.0) {
                minVol = meanVol / 5.0;
            }
            if (maxVol > meanVol * 5.0) {
                maxVol = meanVol * 5.0;
            }
            minVol = Math.round(minVol);
            if ((maxVol = (double)Math.round(maxVol)) > 10.0) {
                for (ROI roi : HKMeans.hKMeans((Sequence)this.regionData, (byte)7, (int)((int)minVol), (int)((int)maxVol), (Double)0.0)) {
                    ((ROI2D)roi).setC(-1);
                    ((ROI2D)roi).setZ(-1);
                    ((ROI2D)roi).setT(t);
                    result.add(roi);
                }
            }
        }
        return result;
    }

    ActiveContour getContourOf(ROI roi, int z, int t, Tuple3d pixelSize, int convWinSize) {
        int depth = this.inputData.getSizeZ();
        ActiveContour result = null;
        try {
            if (roi instanceof ROI2D) {
                ROI2D roi2d = (ROI2D)roi;
                if (roi2d.getZ() == -1) {
                    if (z == -1) {
                        throw new EzException((EzPlug)this, "Please select a 2D slice (using a 2D viewer) where the contour should operate", true);
                    }
                    if (depth > 1) {
                        System.err.println("WARNING: ROI " + roi.getName() + "has a infinite Z dimension, 2D contour will use Z=" + z);
                    }
                    roi2d.setZ(z);
                }
                result = new Polygon2D((Var<Double>)this.contour_resolution.getVariable(), new SlidingWindow(convWinSize), roi2d);
                result.setDivisionSensitivity((Var<Double>)this.division_sensitivity.getVariable());
                result.setT(t);
            } else if (roi instanceof ROI3D) {
                result = new Mesh3D((Var<Double>)this.contour_resolution.getVariable(), (Tuple3d)pixelSize.clone(), (ROI3D)roi, new SlidingWindow(convWinSize));
                result.setT(t);
            } else {
                System.err.println("Warning: couldn't create a contour for ROI '" + roi.getName() + "' (ROI not supported)");
            }
        }
        catch (TopologyException topo) {
            System.err.println("Warning: couldn't create a contour for ROI '" + roi.getName() + "'");
        }
        return result;
    }

    public int evolveContours(int t, ROI boundField) {
        this.allContoursAtTimeT.clear();
        for (TrackSegment segment : ((TrackGroup)this.trackGroup.getValue()).getTrackSegmentList()) {
            Detection det = segment.getDetectionAtTime(t);
            if (det == null) continue;
            this.allContoursAtTimeT.add((ActiveContour)det);
        }
        if (this.allContoursAtTimeT.size() == 0) {
            return -1;
        }
        int iter = 0;
        int nbConvergedContours = 0;
        boolean hasContour3d = false;
        while (!this.globalStop && nbConvergedContours < this.allContoursAtTimeT.size()) {
            nbConvergedContours = 0;
            this.evolvingContoursAtTimeT.clear();
            for (ActiveContour contour : this.allContoursAtTimeT) {
                if (contour.getLastConvergedFrame() == t || contour.hasConverged((SlidingWindow.Operation)((Object)this.convergence_operation.getValue()), (Double)this.convergence_criterion.getValue())) {
                    contour.setLastConvergedFrame(t);
                    ++nbConvergedContours;
                    continue;
                }
                if (contour instanceof Mesh3D) {
                    hasContour3d = true;
                }
                this.evolvingContoursAtTimeT.add(contour);
            }
            if (this.evolvingContoursAtTimeT.size() == 0) break;
            if (this.getUI() != null) {
                if (nbConvergedContours == 0) {
                    this.getUI().setProgressBarValue(Double.NaN);
                } else {
                    this.getUI().setProgressBarValue((double)nbConvergedContours / (double)this.allContoursAtTimeT.size());
                }
            }
            this.resampleContours(t);
            if ((Double)this.region_weight.getValue() > 1.0E-7) {
                boolean updateRegionStatistics = iter % ((Integer)this.convergence_winSize.getValue() / 3) == 0;
                for (ActiveContour contour : this.allContoursAtTimeT) {
                    if (this.region_cout.containsKey(((TrackGroup)this.trackGroup.getValue()).getTrackSegmentWithDetection((Detection)contour))) continue;
                    updateRegionStatistics = true;
                    break;
                }
                if (updateRegionStatistics) {
                    this.updateRegionStatistics();
                }
            }
            this.deformContours(boundField);
            long time = System.currentTimeMillis();
            if (hasContour3d && (iter & 0x1FF) == 0 || time - this.lastVtkGCTime > 10000L) {
                vtkObjectBase.JAVA_OBJECT_MANAGER.gc(false);
                this.lastVtkGCTime = time;
            }
            if (!Icy.getMainInterface().isHeadLess()) {
                this.overlay.painterChanged();
            }
            if (iter >= (Integer)this.convergence_nbIter.getValue()) {
                for (ActiveContour contour : this.evolvingContoursAtTimeT) {
                    contour.setLastConvergedFrame(t);
                }
                break;
            }
            ++iter;
            if (!Thread.currentThread().isInterrupted()) continue;
            this.globalStop = true;
        }
        return iter;
    }

    @Deprecated
    public void deformContours(HashSet<ActiveContour> evolvingContours, HashSet<ActiveContour> allContours, ROI field) {
        this.deformContours(field);
    }

    public void deformContours(final ROI boundField) {
        if (this.evolvingContoursAtTimeT.size() == 1 && this.allContoursAtTimeT.size() == 1) {
            ActiveContour contour = this.evolvingContoursAtTimeT.iterator().next();
            TrackSegment segment = ((TrackGroup)this.trackGroup.getValue()).getTrackSegmentWithDetection((Detection)contour);
            if (Math.abs((Double)this.edge_weight.getValue()) > 1.0E-7) {
                contour.computeEdgeForces(this.edgeData, 0, (Double)this.edge_weight.getValue());
            }
            if ((Double)this.regul_weight.getValue() > 1.0E-7) {
                contour.computeInternalForces((Double)this.regul_weight.getValue());
            }
            if ((Double)this.region_weight.getValue() > 1.0E-7) {
                double cin = this.region_cin.get(segment);
                double cout = this.region_cout.get(segment);
                contour.computeRegionForces(this.regionData, 0, (Double)this.region_weight.getValue(), (Double)this.region_sensitivity.getValue(), cin, cout);
            }
            if ((Double)this.axis_weight.getValue() > 1.0E-7) {
                contour.computeAxisForces((Double)this.axis_weight.getValue());
            }
            if (Math.abs((Double)this.balloon_weight.getValue()) > 1.0E-7) {
                contour.computeBalloonForces((Double)this.balloon_weight.getValue());
            }
            if (((Boolean)this.volume_constraint.getValue()).booleanValue() && this.volumes.containsKey(segment)) {
                contour.computeVolumeConstraint(this.volumes.get(segment), (Double)this.volume_weight.getValue());
            }
            contour.move(boundField, (Double)this.contour_timeStep.getValue());
        } else {
            ArrayList<Callable<Object>> tasks = new ArrayList<Callable<Object>>(this.evolvingContoursAtTimeT.size());
            for (final ActiveContour contour : this.evolvingContoursAtTimeT) {
                final TrackSegment segment = ((TrackGroup)this.trackGroup.getValue()).getTrackSegmentWithDetection((Detection)contour);
                if (!this.region_cin.containsKey(segment) && (Double)this.region_weight.getValue() > 1.0E-7) {
                    this.updateRegionStatistics();
                }
                tasks.add(new Callable<Object>(){

                    @Override
                    public Object call() {
                        if ((Double)ActiveContours.this.regul_weight.getValue() > 1.0E-7) {
                            contour.computeInternalForces((Double)ActiveContours.this.regul_weight.getValue());
                        }
                        if (Math.abs((Double)ActiveContours.this.edge_weight.getValue()) > 1.0E-7) {
                            contour.computeEdgeForces(ActiveContours.this.edgeData, 0, (Double)ActiveContours.this.edge_weight.getValue());
                        }
                        if ((Double)ActiveContours.this.region_weight.getValue() > 1.0E-7) {
                            double cin = ActiveContours.this.region_cin.get(segment);
                            double cout = ActiveContours.this.region_cout.get(segment);
                            contour.computeRegionForces(ActiveContours.this.regionData, 0, (Double)ActiveContours.this.region_weight.getValue(), (Double)ActiveContours.this.region_sensitivity.getValue(), cin, cout);
                        }
                        if ((Double)ActiveContours.this.axis_weight.getValue() > 1.0E-7) {
                            contour.computeAxisForces((Double)ActiveContours.this.axis_weight.getValue());
                        }
                        if (Math.abs((Double)ActiveContours.this.balloon_weight.getValue()) > 1.0E-7) {
                            contour.computeBalloonForces((Double)ActiveContours.this.balloon_weight.getValue());
                        }
                        if (((Boolean)ActiveContours.this.coupling_flag.getValue()).booleanValue()) {
                            for (ActiveContour otherContour : ActiveContours.this.allContoursAtTimeT) {
                                if (otherContour == null || otherContour == contour) continue;
                                contour.computeFeedbackForces(otherContour);
                            }
                            if (((Boolean)ActiveContours.this.volume_constraint.getValue()).booleanValue() && ActiveContours.this.volumes.containsKey(segment)) {
                                contour.computeVolumeConstraint((Double)ActiveContours.this.volumes.get(segment), (Double)ActiveContours.this.volume_weight.getValue());
                            }
                        } else {
                            contour.move(boundField, (Double)ActiveContours.this.contour_timeStep.getValue());
                        }
                        return contour;
                    }
                });
            }
            try {
                this.executeMultiThread(tasks, null);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            if (((Boolean)this.coupling_flag.getValue()).booleanValue()) {
                for (final ActiveContour contour : this.evolvingContoursAtTimeT) {
                    contour.move(boundField, (Double)this.contour_timeStep.getValue());
                }
            }
        }
    }

    private void resampleContours(int t) {
        VarBoolean loop = new VarBoolean("loop", true);
        VarBoolean change = new VarBoolean("change", false);
        int maxIterations = 10000;
        int itCount = 0;
        while (((Boolean)loop.getValue()).booleanValue() && itCount++ <= 10000 && !Thread.currentThread().isInterrupted()) {
            loop.setValue((Object)false);
            if (this.evolvingContoursAtTimeT.size() == 1) {
                for (ActiveContour activeContour : this.evolvingContoursAtTimeT) {
                    if (!new ReSampler((TrackGroup)this.trackGroup.getValue(), activeContour, this.evolvingContoursAtTimeT, this.allContoursAtTimeT).call().booleanValue()) continue;
                    change.setValue((Object)true);
                    loop.setValue((Object)true);
                }
                continue;
            }
            ArrayList<ReSampler> tasks = new ArrayList<ReSampler>(this.evolvingContoursAtTimeT.size());
            for (ActiveContour contour3 : this.evolvingContoursAtTimeT) {
                tasks.add(new ReSampler((TrackGroup)this.trackGroup.getValue(), contour3, this.evolvingContoursAtTimeT, this.allContoursAtTimeT));
            }
            try {
                for (Future resampled : this.multiThreadService.invokeAll(tasks)) {
                    if (!((Boolean)resampled.get()).booleanValue()) continue;
                    change.setValue((Object)true);
                    loop.setValue((Object)true);
                }
            }
            catch (InterruptedException interruptedException) {
                Thread.currentThread().interrupt();
            }
            catch (ExecutionException executionException) {
                executionException.printStackTrace();
                throw new RuntimeException(executionException);
            }
            catch (RuntimeException runtimeException) {
                throw runtimeException;
            }
        }
        if (((Boolean)change.getValue()).booleanValue() && (Double)this.region_weight.getValue() > 1.0E-7) {
            this.updateRegionStatistics();
        }
    }

    private void updateRegionStatistics() {
        this.updateRegionStatistics((Boolean)this.region_localise.getValue());
    }

    private void updateRegionStatistics(boolean locally) {
        int nbContours = this.allContoursAtTimeT.size();
        if (nbContours == 0) {
            return;
        }
        if (!locally) {
            for (BooleanMask2D booleanMask2D : this.contourMask_buffer.mask.values()) {
                Arrays.fill(booleanMask2D.mask, false);
            }
        }
        if (nbContours == 1) {
            for (ActiveContour activeContour : this.allContoursAtTimeT) {
                new LocalRegionStatisticsComputer(activeContour, !locally).call();
            }
        } else {
            ArrayList<Callable<Object>> updaters = new ArrayList<Callable<Object>>(this.allContoursAtTimeT.size());
            for (ActiveContour contour : this.allContoursAtTimeT) {
                updaters.add(new LocalRegionStatisticsComputer(contour, !locally));
            }
            try {
                this.executeMultiThread(updaters, null);
            }
            catch (Exception exception) {
                exception.printStackTrace();
                throw new RuntimeException(exception);
            }
        }
        this.updateBackgroundStatistics(locally);
    }

    private void updateBackgroundStatistics(boolean locally) {
        int nbContours = this.allContoursAtTimeT.size();
        if (nbContours == 0) {
            return;
        }
        if (locally) {
            if (nbContours == 1) {
                new LocalBackgroundStatisticsComputer(this.allContoursAtTimeT.iterator().next()).call();
            } else {
                ArrayList<Callable<Object>> updaters = new ArrayList<Callable<Object>>(this.allContoursAtTimeT.size());
                for (ActiveContour contour : this.allContoursAtTimeT) {
                    updaters.add(new LocalBackgroundStatisticsComputer(contour));
                }
                try {
                    this.executeMultiThread(updaters, null);
                }
                catch (Exception e) {
                    e.printStackTrace();
                    throw new RuntimeException(e);
                }
            }
        } else {
            double[] outs = new double[this.inputData.getSizeZ()];
            for (int z = 0; z < outs.length; ++z) {
                boolean[] _mask = ((BooleanMask2D)this.contourMask_buffer.mask.get((Object)Integer.valueOf((int)z))).mask;
                float[] _data = this.regionData.getDataXYAsFloat(0, z, 0);
                double outSumSlice = 0.0;
                double outCptSlice = 0.0;
                for (int i = 0; i < _mask.length; ++i) {
                    if (_mask[i]) continue;
                    outSumSlice += (double)_data[i];
                    outCptSlice += 1.0;
                }
                outs[z] = outCptSlice == 0.0 ? 0.0 : outSumSlice / outCptSlice;
            }
            for (ActiveContour contour : this.allContoursAtTimeT) {
                double cout;
                TrackSegment segment = ((TrackGroup)this.trackGroup.getValue()).getTrackSegmentWithDetection((Detection)contour);
                if (contour instanceof Polygon2D) {
                    cout = outs[(int)Math.round(contour.getZ())];
                    this.region_cout.put(segment, cout);
                    continue;
                }
                cout = ArrayMath.mean((double[])outs);
                this.region_cout.put(segment, cout);
            }
        }
    }

    private void storeResult(int t) {
        if (this.isHeadLess()) {
            System.out.println("=> Storing result...");
        }
        ArrayList segments = ((TrackGroup)this.trackGroup.getValue()).getTrackSegmentList();
        ArrayList<Object> rois = new ArrayList<Object>(Arrays.asList((Object[])this.roiOutput.getValue()));
        for (int i = 1; i <= segments.size(); ++i) {
            ROI roi;
            TrackSegment segment = (TrackSegment)segments.get(i - 1);
            ActiveContour contour = (ActiveContour)segment.getDetectionAtTime(t);
            if (contour == null) continue;
            if (!this.volumes.containsKey(segment)) {
                this.volumes.put(segment, contour.getDimension(2));
            }
            if ((roi = contour.toROI((ROIType)((Object)this.output_roiType.getValue()), this.inputData)) != null) {
                roi.setProperty(CONTOUR_ID, Integer.toString(i));
                roi.setName(contour.getName());
                roi.setColor(contour.getColor());
                if (roi instanceof ROI2D) {
                    ((ROI2D)roi).setT(t);
                } else if (roi instanceof ROI3D) {
                    ((ROI3D)roi).setT(t);
                }
                rois.add(roi);
            }
            if (!this.output_labels.isReferenced() && this.output_rois.getValue() != ExportROI.AS_LABELS) continue;
            Sequence binSeq = (Sequence)this.output_labels.getValue();
            if (binSeq == null) {
                binSeq = new Sequence();
                this.output_labels.setValue(binSeq);
            }
            if (binSeq.getImage(t, (int)contour.getZ()) == null) {
                binSeq.setImage(t, (int)contour.getZ(), (BufferedImage)new IcyBufferedImage(this.inputData.getWidth(), this.inputData.getHeight(), 1, DataType.USHORT));
            }
            contour.toSequence(binSeq, i);
        }
        if (this.output_labels.getValue() != null) {
            ((Sequence)this.output_labels.getValue()).dataChanged();
        }
        if (rois.size() > 0) {
            this.roiOutput.setValue((Object)rois.toArray(new ROI[rois.size()]));
        }
    }

    public void clean() {
        if (this.inputData != null) {
            this.inputData.removeOverlay((Overlay)this.overlay);
        }
        if (this.trackGroup.getValue() != null) {
            ((TrackGroup)this.trackGroup.getValue()).clearAllTrackSegment();
        }
        this.multiThreadService.shutdownNow();
        this.multiThreadService.waitAll();
        for (TrackSegment ts : this.region_cin.keySet()) {
            if (ts == null) continue;
            ts.removeId();
        }
        for (TrackSegment ts : this.region_cout.keySet()) {
            if (ts == null) continue;
            ts.removeId();
        }
        this.region_cin.clear();
        this.region_cout.clear();
        this.volumes.clear();
        this.evolvingContoursAtTimeT.clear();
        this.allContoursAtTimeT.clear();
        this.inputData = null;
        this.edgeData = null;
        this.regionData = null;
        this.regionDataSummed = null;
    }

    public void declareInput(VarList inputMap) {
        inputMap.add("input sequence", (Var)this.input.getVariable());
        inputMap.add("Input ROI", (Var)this.roiInput);
        inputMap.add("regularization: weight", this.regul_weight.getVariable());
        inputMap.add("edge: weight", this.edge_weight.getVariable());
        this.edge_c.setActive(false);
        this.edge_c.setValues((Number)0, (Comparable)Integer.valueOf(0), (Comparable)Integer.valueOf(16), (Number)1);
        inputMap.add("edge: channel", this.edge_c.getVariable());
        inputMap.add("region: weight", this.region_weight.getVariable());
        inputMap.add("region: sensitivity", this.region_sensitivity.getVariable());
        this.region_c.setActive(false);
        this.region_c.setValues((Number)0, (Comparable)Integer.valueOf(0), (Comparable)Integer.valueOf(16), (Number)1);
        inputMap.add("region: channel", this.region_c.getVariable());
        inputMap.add("balloon: weight", this.balloon_weight.getVariable());
        this.coupling_flag.setValue((Object)true);
        inputMap.add("contour resolution", this.contour_resolution.getVariable());
        this.contour_resolution.addVarChangeListener((EzVarListener)new EzVarListener<Double>(){

            public void variableChanged(EzVar<Double> source, Double newValue) {
                ActiveContours.this.convergence_winSize.setValue((Object)((int)(100.0 / newValue)));
            }
        });
        inputMap.add("region bounds", (Var)this.evolution_bounds.getVariable());
        this.evolution_bounds.getVariable().setValue(null);
        inputMap.add("time step", this.contour_timeStep.getVariable());
        inputMap.add("convergence value", this.convergence_criterion.getVariable());
        inputMap.add("max. iterations", this.convergence_nbIter.getVariable());
        inputMap.add("type of ROI output", this.output_roiType.getVariable());
        inputMap.add("tracking", this.tracking.getVariable());
        inputMap.add("division sensitivity", this.division_sensitivity.getVariable());
        inputMap.add("axis constraint", this.axis_weight.getVariable());
        this.volume_constraint.setValue((Object)true);
        inputMap.add("Volume weight", this.volume_weight.getVariable());
        inputMap.add("watch entering objects", this.tracking_newObjects.getVariable());
    }

    public void declareOutput(VarList outputMap) {
        outputMap.add("Regions of interest", (Var)this.roiOutput);
        outputMap.add("Tracks", this.trackGroup);
        outputMap.add("Labels", (Var)this.output_labels);
    }

    public static enum ROIType {
        AREA(ROI2DArea.class),
        POLYGON(ROI2DPolygon.class);

        final Class<? extends ROI> clazz;

        private ROIType(Class<? extends ROI> clazz) {
            this.clazz = clazz;
        }
    }

    public static enum ExportROI {
        NO,
        ON_INPUT,
        ON_NEW_IMAGE,
        AS_LABELS;

    }

    private class ContourDuplicator
    implements Callable<Object> {
        final TrackSegment segment;
        final int t;
        final int convWinSize;

        public ContourDuplicator(TrackSegment segment, int t, int convWinSize) {
            this.segment = segment;
            this.t = t;
            this.convWinSize = convWinSize;
        }

        @Override
        public Object call() {
            Detection detection = this.segment.getDetectionAtTime(this.t);
            if (detection != null) {
                return detection;
            }
            detection = this.segment.getDetectionAtTime(this.t - 1);
            if (detection == null) {
                return null;
            }
            ActiveContour previousContour = (ActiveContour)detection;
            ActiveContour currentContour = previousContour.clone();
            currentContour.convergence.setSize(this.convWinSize);
            currentContour.setT(this.t);
            this.segment.addDetection((Detection)currentContour);
            return currentContour;
        }
    }

    private class ContourInitializer
    implements Callable<Object> {
        final ROI roi;
        final int z;
        final int t;
        final Tuple3d pixelSize;
        final int convWinSize;
        final List<TrackSegment> activeTracks;
        final List<TrackSegment> endedTracks;

        public ContourInitializer(ROI roi, int z, int t, Tuple3d pixelSize, int convWinSize, List<TrackSegment> activeTracks, List<TrackSegment> justEndedTracks) {
            this.roi = roi;
            this.z = z;
            this.t = t;
            this.pixelSize = pixelSize;
            this.convWinSize = convWinSize;
            this.activeTracks = activeTracks;
            this.endedTracks = justEndedTracks;
        }

        private boolean colliding() {
            for (TrackSegment segment : this.activeTracks) {
                ActiveContour contour = (ActiveContour)segment.getLastDetection();
                ROI contourROI = contour.toROI(ROIType.POLYGON, null);
                if (!this.roi.intersects(contourROI)) continue;
                return true;
            }
            return false;
        }

        @Override
        public Object call() {
            if (this.colliding()) {
                return null;
            }
            ActiveContour contour = ActiveContours.this.getContourOf(this.roi, this.z, this.t, this.pixelSize, this.convWinSize);
            if (contour == null) {
                return null;
            }
            for (TrackSegment track : this.endedTracks) {
                ActiveContour previousContour = (ActiveContour)track.getLastDetection();
                ROI previousContourROI = previousContour.toROI(ROIType.POLYGON, null);
                if (!this.roi.intersects(previousContourROI)) continue;
                System.out.println("Found link at time " + this.t + ", position (" + contour.getX() + ";" + contour.getY() + ")");
                track.addDetection((Detection)contour);
                return null;
            }
            TrackSegment result = new TrackSegment();
            result.addDetection((Detection)contour);
            return result;
        }
    }

    private class LocalBackgroundStatisticsComputer
    implements Callable<Object> {
        final ActiveContour contour;

        public LocalBackgroundStatisticsComputer(ActiveContour contour) {
            this.contour = contour;
        }

        @Override
        public Object call() {
            TrackSegment segment = ((TrackGroup)ActiveContours.this.trackGroup.getValue()).getTrackSegmentWithDetection((Detection)this.contour);
            double cout = this.contour.computeBackgroundIntensity(ActiveContours.this.regionData, ActiveContours.this.contourMask_buffer);
            ActiveContours.this.region_cout.put(segment, cout);
            return null;
        }
    }

    private class LocalRegionStatisticsComputer
    implements Callable<Object> {
        final ActiveContour contour;
        final boolean maskBased;

        public LocalRegionStatisticsComputer(ActiveContour contour, boolean maskBased) {
            this.contour = contour;
            this.maskBased = maskBased;
        }

        @Override
        public Object call() {
            try {
                double cin = this.contour.computeAverageIntensity(this.contour instanceof Mesh3D ? ActiveContours.this.regionData : ActiveContours.this.regionDataSummed, this.maskBased ? ActiveContours.this.contourMask_buffer : null);
                ActiveContours.this.region_cin.put(((TrackGroup)ActiveContours.this.trackGroup.getValue()).getTrackSegmentWithDetection((Detection)this.contour), cin);
            }
            catch (TopologyException topo) {
                System.err.println("Removing a contour. Reason: " + topo.getMessage());
                ActiveContours.this.allContoursAtTimeT.remove(this.contour);
                ActiveContours.this.evolvingContoursAtTimeT.remove(this.contour);
            }
            return null;
        }
    }
}

