/*
 * Decompiled with CFR 0.152.
 */
package plugins.adufour.hcs;

import icy.math.MathUtil;
import icy.roi.BooleanMask2D;
import icy.roi.ROI;
import icy.roi.ROI2D;
import icy.roi.ROIUtil;
import icy.sequence.Sequence;
import icy.type.collection.CollectionUtil;
import icy.type.point.Point5D;
import icy.util.ShapeUtil;
import java.awt.Color;
import java.util.Arrays;
import java.util.List;
import org.apache.poi.ss.usermodel.Workbook;
import plugins.adufour.activecontours.ActiveContours;
import plugins.adufour.blocks.tools.roi.DilateROI;
import plugins.adufour.ezplug.EzComponent;
import plugins.adufour.ezplug.EzGroup;
import plugins.adufour.ezplug.EzPlug;
import plugins.adufour.ezplug.EzStatus;
import plugins.adufour.ezplug.EzStoppable;
import plugins.adufour.ezplug.EzVarChannel;
import plugins.adufour.ezplug.EzVarDouble;
import plugins.adufour.ezplug.EzVarInteger;
import plugins.adufour.ezplug.EzVarSequence;
import plugins.adufour.hierarchicalkmeans.HKMeans;
import plugins.adufour.thresholder.KMeans;
import plugins.adufour.thresholder.Thresholder;
import plugins.adufour.vars.lang.Var;
import plugins.adufour.workbooks.IcySpreadSheet;
import plugins.adufour.workbooks.Workbooks;
import plugins.kernel.roi.descriptor.measure.ROIMassCenterDescriptorsPlugin;

public class Cytokinesis
extends EzPlug
implements EzStoppable {
    EzVarSequence ezSeq = new EzVarSequence("Input");
    EzVarChannel dapi_channel = new EzVarChannel("Channel", (Var)this.ezSeq.getVariable(), false);
    EzVarInteger dapi_minSize = new EzVarInteger("Min size", 400, 0, 5000, 50);
    EzVarInteger dapi_maxSize = new EzVarInteger("Max size", 2000, 0, 5000, 50);
    EzVarDouble dapi_minIntensity = new EzVarDouble("Min intensity", 400.0, 0.0, 65000.0, 100.0);
    EzVarChannel tub_channel = new EzVarChannel("Channel", (Var)this.ezSeq.getVariable(), false);
    EzVarInteger tub_classes = new EzVarInteger("Intensity classes", 2, 2, 100, 1);
    EzVarChannel mklp1_channel = new EzVarChannel("Channel", (Var)this.ezSeq.getVariable(), false);
    EzVarInteger mklp1_minSize = new EzVarInteger("Min size", 30, 0, 1000, 10);
    EzVarInteger mklp1_maxSize = new EzVarInteger("Max size", 100, 0, 1000, 10);
    EzVarDouble mklp1_minIntensity = new EzVarDouble("Min intensity", 2000.0, 0.0, 65000.0, 100.0);
    EzVarInteger ring_inflation = new EzVarInteger("Ring inflation", 2, 2, 100, 1);

    public void clean() {
    }

    protected void initialize() {
        this.addEzComponent((EzComponent)this.ezSeq);
        this.addEzComponent((EzComponent)new EzGroup("DAPI", new EzComponent[]{this.dapi_channel, this.dapi_minSize, this.dapi_maxSize, this.dapi_minIntensity}));
        this.addEzComponent((EzComponent)new EzGroup("Tubulin", new EzComponent[]{this.tub_channel, this.tub_classes}));
        this.addEzComponent((EzComponent)new EzGroup("MKLP1", new EzComponent[]{this.mklp1_channel, this.mklp1_minSize, this.mklp1_maxSize, this.mklp1_minIntensity, this.ring_inflation}));
    }

    protected void execute() {
        Sequence seq = (Sequence)this.ezSeq.getValue(true);
        seq.removeAllROI();
        Workbook wb = Workbooks.createEmptyWorkbook();
        IcySpreadSheet Summary = Workbooks.getSheet((Workbook)wb, (String)"Summary");
        IcySpreadSheet FOVs = Workbooks.getSheet((Workbook)wb, (String)"FOVs");
        IcySpreadSheet Details = Workbooks.getSheet((Workbook)wb, (String)"Details");
        Summary.setRow(0, new Object[]{"Well", "Nb. nuclei", "Nb. midbodies", "Nb. cytokinesis"});
        FOVs.setRow(0, new Object[]{"Well", "Field", "Nb nuclei", "Nb. midbodies", "Nb. cytokinesis"});
        Details.setRow(0, new Object[]{"Well", "Field", "X (dot)", "Y (dot)", "Nb. intersections", "Type"});
        int line = 1;
        int row = 1;
        int totalNuclei = 0;
        int totalMidbodies = 0;
        int totalCytokinesis = 0;
        try {
            int field = 0;
            while (field < seq.getSizeT()) {
                Sequence currentField = new Sequence(seq.getImage(field, 0));
                currentField.loadAllData();
                currentField.updateChannelsBounds(true);
                this.getStatus().setCompletion((double)field / (double)seq.getSizeT());
                String prefix = "Frame " + field + ": ";
                if (!Thread.currentThread().isInterrupted()) {
                    int nucleusNumber = 0;
                    int midbodyNumber = 0;
                    int cytokinesisNumber = 0;
                    if (currentField.getChannelMax(((Integer)this.dapi_channel.getValue()).intValue()) < (Double)this.dapi_minIntensity.getValue()) {
                        System.out.println(String.valueOf(prefix) + "Empty image; intensity in channel " + this.dapi_channel.getValue() + " < " + this.dapi_minIntensity.getValue());
                    } else {
                        List dapi_roi = HKMeans.hKMeans((Sequence)currentField, (int)0, (int)((Integer)this.dapi_channel.getValue()), (double)1.0, (byte)10, (int)((Integer)this.dapi_minSize.getValue()), (int)((Integer)this.dapi_maxSize.getValue()), (Double)((Double)this.dapi_minIntensity.getValue()), (EzStatus)this.getStatus());
                        if (dapi_roi.isEmpty()) {
                            System.out.println(String.valueOf(prefix) + "no nucleus");
                        } else {
                            ActiveContours ac = new ActiveContours();
                            ac.input.setValue(currentField);
                            ac.roiInput.add((Object[])dapi_roi.toArray(new ROI[0]));
                            ac.edge_c.setValue((Object)((Integer)this.dapi_channel.getValue()));
                            ac.edge_weight.setValue((Object)0.2);
                            ac.region_c.setValue((Object)((Integer)this.dapi_channel.getValue()));
                            ac.region_weight.setValue((Object)1.0);
                            ac.regul_weight.setValue((Object)0.02);
                            ac.division_sensitivity.setValue((Object)0.01);
                            ac.evolution_bounds.setNoSequenceSelection();
                            ac.contour_resolution.setValue((Object)3.0);
                            ac.contour_timeStep.setValue((Object)1.0);
                            ac.convergence_criterion.setValue((Object)0.3);
                            ac.convergence_nbIter.setValue((Object)1000);
                            ac.output_roiType.setValue((Object)ActiveContours.ROIType.POLYGON);
                            ac.execute();
                            ROI[] rOIArray = (ROI[])ac.roiOutput.getValue();
                            int n = rOIArray.length;
                            int n2 = 0;
                            while (n2 < n) {
                                ROI roi = rOIArray[n2];
                                ++totalNuclei;
                                ++nucleusNumber;
                                ((ROI2D)roi).setZ(0);
                                ((ROI2D)roi).setT(field);
                                ((ROI2D)roi).setC(((Integer)this.tub_channel.getValue()).intValue());
                                ((ROI2D)roi).setColor(Color.blue);
                                seq.addROI(roi);
                                ++n2;
                            }
                            List mklp1_roi = HKMeans.hKMeans((Sequence)currentField, (int)0, (int)((Integer)this.mklp1_channel.getValue()), (double)0.0, (byte)5, (int)((Integer)this.mklp1_minSize.getValue()), (int)((Integer)this.mklp1_maxSize.getValue()), (Double)((Double)this.mklp1_minIntensity.getValue()), (EzStatus)this.getStatus());
                            if (mklp1_roi.isEmpty()) {
                                System.out.println(String.valueOf(prefix) + "no midbody");
                            } else {
                                totalMidbodies += mklp1_roi.size();
                                midbodyNumber = mklp1_roi.size();
                                double[] v = KMeans.computeKMeansThresholds((Sequence)currentField, (int)((Integer)this.tub_channel.getValue()), (int)((Integer)this.tub_classes.getValue()), (int)256);
                                ROI2D tub_stain = (ROI2D)Thresholder.threshold((Sequence)currentField, (int)((Integer)this.tub_channel.getValue()), (double[])new double[]{v[0]})[0];
                                tub_stain.setZ(0);
                                tub_stain.setT(field);
                                tub_stain.setC(((Integer)this.tub_channel.getValue()).intValue());
                                tub_stain.setColor(Color.green);
                                seq.addROI((ROI)tub_stain);
                                ROI2D mergeNuclei = (ROI2D)ROIUtil.merge((List)CollectionUtil.asList((Object[])((ROI[])ac.roiOutput.getValue())), (ShapeUtil.BooleanOperator)ShapeUtil.BooleanOperator.OR);
                                int i = 0;
                                while (i < mklp1_roi.size()) {
                                    ROI2D intersection_dapi;
                                    ROI2D intersection_tub;
                                    ROI2D mklp1 = (ROI2D)mklp1_roi.get(i);
                                    Point5D center = ROIMassCenterDescriptorsPlugin.computeMassCenter((ROI)mklp1);
                                    double xC = MathUtil.round((double)center.getX(), (int)1);
                                    double yC = MathUtil.round((double)center.getY(), (int)1);
                                    Details.setRow(row, new Object[]{seq.getName(), field, xC, yC});
                                    ROI2D mklp1_outer_discus = (ROI2D)DilateROI.dilateROI((ROI)mklp1, (int)((Integer)this.ring_inflation.getValue()), (int)((Integer)this.ring_inflation.getValue()), (int)0);
                                    ROI2D mklp1_inner_discus = (ROI2D)DilateROI.dilateROI((ROI)mklp1, (int)((Integer)this.ring_inflation.getValue() - 2), (int)((Integer)this.ring_inflation.getValue() - 2), (int)0);
                                    ROI2D mklp1_ring = (ROI2D)ROIUtil.subtract((ROI)mklp1_outer_discus, (ROI)mklp1_inner_discus);
                                    mklp1_ring.setZ(0);
                                    mklp1_ring.setT(field);
                                    mklp1_ring.setC(((Integer)this.tub_channel.getValue()).intValue());
                                    mklp1_ring.setColor(Color.red);
                                    seq.addROI((ROI)mklp1_ring);
                                    int nbCrossings = 0;
                                    if (!tub_stain.isEmpty() && !mklp1_ring.isEmpty() && mklp1_ring.intersects((ROI)tub_stain) && !(intersection_tub = (ROI2D)ROIUtil.getIntersection(Arrays.asList(mklp1_ring, tub_stain))).isEmpty()) {
                                        BooleanMask2D[] possibleBridge = intersection_tub.getBooleanMask(true).getComponents();
                                        nbCrossings = possibleBridge.length;
                                    }
                                    if (!(intersection_dapi = (ROI2D)ROIUtil.getIntersection(Arrays.asList(mklp1_ring, mergeNuclei))).isEmpty()) {
                                        nbCrossings = 1;
                                    }
                                    Details.setValue(row, 4, (Object)nbCrossings);
                                    switch (nbCrossings) {
                                        case 0: {
                                            Details.setValue(row, 5, (Object)"REMNANT");
                                            break;
                                        }
                                        case 1: {
                                            Details.setValue(row, 5, (Object)"REMNANT");
                                            break;
                                        }
                                        default: {
                                            Details.setValue(row, 5, (Object)"BRIDGE");
                                            ++totalCytokinesis;
                                            ++cytokinesisNumber;
                                        }
                                    }
                                    ++row;
                                    ++i;
                                }
                                FOVs.setRow(line, new Object[]{seq.getName(), field, nucleusNumber, midbodyNumber, cytokinesisNumber});
                                ++line;
                            }
                        }
                    }
                    ++field;
                    continue;
                }
                break;
            }
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        Summary.setRow(1, new Object[]{seq.getName(), totalNuclei, totalMidbodies, totalCytokinesis});
        Workbooks.show((Workbook)wb, (String)"Cytokinesis");
    }
}

