/*
 * Decompiled with CFR 0.152.
 */
package plugins.tprovoost.Microscopy.MicroManager.tools;

import icy.gui.component.button.IcyButton;
import icy.gui.frame.IcyFrame;
import icy.gui.util.GuiUtil;
import icy.plugin.PluginDescriptor;
import icy.resource.icon.IcyIcon;
import java.awt.Component;
import java.awt.Container;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;

public class FrameUtils {
    public static IcyFrame addMMWindowToDesktopPane(Window window) {
        IcyFrame frame = GuiUtil.createIcyFrameFromWindow((Window)window);
        frame.addToDesktopPane();
        frame.setVisible(true);
        return frame;
    }

    public static JButton findButtonComponents(Container container, String label) {
        for (Component c : container.getComponents()) {
            JButton button;
            if (!(c instanceof JButton) || !(button = (JButton)c).getText().equalsIgnoreCase(label)) continue;
            return button;
        }
        return null;
    }

    public static IcyButton createUIButton(String buttonText, String iconPath, final Runnable action) {
        IcyButton theButton = iconPath != null && !iconPath.isEmpty() ? new IcyButton(buttonText, new IcyIcon(iconPath, 20)) : new IcyButton(buttonText);
        theButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                action.run();
            }
        });
        return theButton;
    }

    public static IcyButton createPluginButton(PluginDescriptor plugin, ActionListener action) {
        IcyButton result = new IcyButton(new IcyIcon(plugin.getIconAsImage(), 32, false));
        result.setToolTipText(plugin.getName());
        if (action != null) {
            result.addActionListener(action);
        }
        return result;
    }
}

