/*
 * Decompiled with CFR 0.152.
 */
package plugins.fab.spotDetector.input;

import icy.gui.main.MainAdapter;
import icy.gui.main.MainEvent;
import icy.gui.main.MainListener;
import icy.gui.util.GuiUtil;
import icy.main.Icy;
import icy.sequence.Sequence;
import icy.util.XLSUtil;
import java.awt.Color;
import java.awt.Component;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JLabel;
import javax.swing.border.TitledBorder;
import jxl.write.WritableSheet;
import plugins.fab.spotDetector.GlobalDetectionToken;
import plugins.fab.spotDetector.input.InputDetectionAbstract;

public class currentSequenceInputDetection
extends InputDetectionAbstract {
    JLabel currentSequenceNameLabel = new JLabel();
    Color labelDefaultColor = this.currentSequenceNameLabel.getForeground();

    public currentSequenceInputDetection() {
        this.getPanel().setLayout(new BoxLayout(this.getPanel(), 3));
        this.getPanel().setBorder(new TitledBorder("Select channel to use to create ROI"));
        this.getPanel().add(GuiUtil.createLineBoxPanel((Component[])new Component[]{Box.createVerticalGlue()}));
        this.getPanel().add(GuiUtil.createLineBoxPanel((Component[])new Component[]{new JLabel("Current sequence input:")}));
        this.getPanel().add(GuiUtil.createLineBoxPanel((Component[])new Component[]{Box.createVerticalStrut(10)}));
        this.getPanel().add(GuiUtil.createLineBoxPanel((Component[])new Component[]{this.currentSequenceNameLabel}));
        this.getPanel().add(GuiUtil.createLineBoxPanel((Component[])new Component[]{Box.createVerticalStrut(50)}));
        this.getPanel().add(GuiUtil.createLineBoxPanel((Component[])new Component[]{Box.createVerticalGlue()}));
        this.refreshCurrentSequenceLabel();
        Icy.getMainInterface().addListener((MainListener)new MainAdapter(){

            public void sequenceFocused(MainEvent event) {
                currentSequenceInputDetection.this.refreshCurrentSequenceLabel();
            }
        });
    }

    private void refreshCurrentSequenceLabel() {
        Sequence sequence = this.getFocusedSequence();
        if (sequence == null) {
            this.currentSequenceNameLabel.setForeground(Color.red);
            this.currentSequenceNameLabel.setText("No sequence loaded");
        } else {
            this.currentSequenceNameLabel.setForeground(this.labelDefaultColor);
            this.currentSequenceNameLabel.setText(sequence.getName());
        }
    }

    @Override
    public void process(GlobalDetectionToken gdt) {
        gdt.inputSequence = this.getActiveSequence();
    }

    @Override
    public void saveXLS(WritableSheet page, GlobalDetectionToken gdt) {
        int row = page.getRows();
        XLSUtil.setCellString((WritableSheet)page, (int)0, (int)row, (String)"Input Module:");
        XLSUtil.setCellString((WritableSheet)page, (int)1, (int)row, (String)"Current Sequence Input");
        XLSUtil.setCellString((WritableSheet)page, (int)0, (int)(++row), (String)"File name:");
        XLSUtil.setCellString((WritableSheet)page, (int)1, (int)row, (String)gdt.inputSequence.getFilename());
    }
}

