/*
 * Decompiled with CFR 0.152.
 */
package plugins.kernel.roi.descriptor.measure;

import icy.roi.ROI;
import icy.roi.ROIDescriptor;
import icy.sequence.Sequence;
import plugins.kernel.roi.descriptor.measure.ROIBasicMeasureDescriptorsPlugin;

public class ROIInteriorDescriptor
extends ROIDescriptor {
    public static final String ID = "Interior";

    public ROIInteriorDescriptor() {
        super(ID, ID, Double.class);
    }

    @Override
    public String getUnit(Sequence sequence) {
        return "px";
    }

    @Override
    public String getDescription() {
        return "Number of points for the interior";
    }

    @Override
    public Object compute(ROI roi, Sequence sequence) throws UnsupportedOperationException {
        return ROIInteriorDescriptor.computeInterior(roi);
    }

    public static double computeInterior(ROI roi) {
        return roi.getNumberOfPoints();
    }

    public static double computeInterior(double interiorPoints, ROI roi, Sequence sequence, int dim) throws UnsupportedOperationException {
        double mul = ROIBasicMeasureDescriptorsPlugin.getMultiplierFactor(sequence, roi, dim);
        if (mul == 0.0) {
            throw new UnsupportedOperationException("Can't process 'Interior' calculation for dimension " + dim + " on the ROI: " + roi.getName());
        }
        return sequence.calculateSizeBestUnit(interiorPoints * mul, dim, dim);
    }
}

