/*
 * Decompiled with CFR 0.152.
 */
package plugins.kernel.roi.roi4d;

import icy.roi.BooleanMask3D;
import icy.roi.BooleanMask4D;
import icy.roi.ROI;
import icy.roi.ROI3D;
import icy.type.point.Point4D;
import icy.type.point.Point5D;
import icy.type.rectangle.Rectangle4D;
import java.awt.geom.Point2D;
import java.util.Map;
import plugins.kernel.roi.roi3d.ROI3DArea;
import plugins.kernel.roi.roi4d.ROI4DStack;

public class ROI4DArea
extends ROI4DStack<ROI3DArea> {
    public ROI4DArea() {
        super(ROI3DArea.class);
    }

    public ROI4DArea(Point4D pt) {
        this();
        this.addBrush(pt.toPoint2D(), (int)pt.getZ(), (int)pt.getT());
    }

    public ROI4DArea(Point5D pt) {
        this(pt.toPoint4D());
    }

    public ROI4DArea(BooleanMask4D mask) {
        this();
        this.setAsBooleanMask(mask);
    }

    public ROI4DArea(ROI4DArea area) {
        this();
        for (Map.Entry entry : area.slices.entrySet()) {
            this.slices.put((Integer)entry.getKey(), new ROI3DArea((ROI3DArea)entry.getValue()));
        }
        this.roiChanged(true);
    }

    @Override
    public String getDefaultName() {
        return "Area4D";
    }

    public void addPoint(int x, int y, int z, int t) {
        this.setPoint(x, y, z, t, true);
    }

    public void removePoint(int x, int y, int z, int t) {
        this.setPoint(x, y, z, t, false);
    }

    public void setPoint(int x, int y, int z, int t, boolean value) {
        ROI3DArea slice = (ROI3DArea)this.getSlice(t, value);
        if (slice != null) {
            slice.setPoint(x, y, z, value);
        }
    }

    public void addBrush(Point2D pos, int z, int t) {
        ((ROI3DArea)this.getSlice(t, true)).addBrush(pos, z);
    }

    public void removeBrush(Point2D pos, int z, int t) {
        ROI3DArea slice = (ROI3DArea)this.getSlice(t, false);
        if (slice != null) {
            slice.removeBrush(pos, z);
        }
    }

    public void setSlice(int t, ROI3D roiSlice, boolean merge) {
        ROI newSlice;
        if (roiSlice == null) {
            throw new IllegalArgumentException("Cannot add an empty slice in a 4D ROI");
        }
        ROI3DArea currentSlice = (ROI3DArea)this.getSlice(t);
        if (currentSlice != null && merge) {
            roiSlice.setT(t);
            roiSlice.setC(this.getC());
            newSlice = currentSlice.getUnion(roiSlice);
        } else {
            newSlice = roiSlice;
        }
        if (newSlice instanceof ROI3DArea) {
            this.setSlice(t, (ROI3DArea)newSlice);
        } else if (newSlice instanceof ROI3D) {
            this.setSlice(t, new ROI3DArea(((ROI3D)newSlice).getBooleanMask(true)));
        } else {
            throw new IllegalArgumentException("Can't add the result of the merge operation on 3D slice " + t + ": " + newSlice.getClassName());
        }
    }

    @Override
    public boolean isEmpty() {
        for (ROI3DArea area : this.slices.values()) {
            if (area.isEmpty()) continue;
            return false;
        }
        return true;
    }

    public void setAsBooleanMask(BooleanMask4D mask) {
        if (mask == null || mask.isEmpty()) {
            this.clear();
        } else {
            Rectangle4D.Integer bounds4d = mask.bounds;
            int startT = bounds4d.t;
            int sizeT = bounds4d.sizeT;
            BooleanMask3D[] masks3d = new BooleanMask3D[sizeT];
            for (int t = 0; t < sizeT; ++t) {
                masks3d[t] = mask.getMask3D(startT + t);
            }
            this.setAsBooleanMask(bounds4d, masks3d);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setAsBooleanMask(Rectangle4D.Integer rect, BooleanMask3D[] mask) {
        if (rect.isInfiniteT()) {
            throw new IllegalArgumentException("Cannot set infinite T dimension on the 4D Area ROI.");
        }
        this.beginUpdate();
        try {
            this.clear();
            for (int t = 0; t < rect.sizeT; ++t) {
                this.setSlice(t + rect.t, new ROI3DArea(mask[t]));
            }
        }
        finally {
            this.endUpdate();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void optimizeBounds() {
        Rectangle4D.Integer bounds = this.getBounds();
        this.beginUpdate();
        try {
            for (int t = bounds.t; t < bounds.t + bounds.sizeT; ++t) {
                ROI3DArea roi = (ROI3DArea)this.getSlice(t);
                if (roi == null) continue;
                if (roi.isEmpty()) {
                    this.removeSlice(t);
                    continue;
                }
                roi.optimizeBounds();
            }
        }
        finally {
            this.endUpdate();
        }
    }
}

