/*
 * Decompiled with CFR 0.152.
 */
package plugins.kernel.roi.tool;

import icy.image.IcyBufferedImage;
import icy.roi.BooleanMask2D;
import icy.roi.ROI2D;
import icy.roi.ROI3D;
import icy.sequence.Sequence;
import icy.type.DataType;
import icy.type.collection.array.Array1DUtil;
import java.awt.Rectangle;
import plugins.kernel.roi.roi2d.ROI2DArea;

public class MagicWand {
    private static final int UNKNOWN = 0;
    private static final int OUTSIDE = 1;
    private static final int INSIDE = -1;

    public static ROI2D doWand2D(Sequence sequence, int xStart, int yStart, int z, int t, int channel, double valueTolerance, double colorSensitivity, double gradientTolerance) {
        if (sequence == null) {
            return null;
        }
        MagicWandSetting mws = new MagicWandSetting();
        mws.valueTolerance = valueTolerance;
        mws.colorSensitivity = colorSensitivity;
        mws.gradientTolerance = gradientTolerance;
        return MagicWand.doWand2D(sequence, xStart, yStart, z, t, channel, mws);
    }

    public static ROI2D doWand2D(Sequence sequence, int xStart, int yStart, int z, int t, int channel, MagicWandSetting mws) {
        IcyBufferedImage img = sequence.getImage(t, z);
        int width = img.getWidth();
        int height = img.getHeight();
        int sizeC = img.getSizeC();
        DataType dataType = img.getDataType_();
        Object[] pixels = new Object[sizeC];
        for (int c = 0; c < sizeC; ++c) {
            pixels[c] = img.getDataXY(c);
        }
        Object grayPixels = pixels[channel != -1 && channel < sizeC ? channel : 0];
        byte[] maskPixels = new byte[width * height];
        int[] dirXoffset = new int[]{0, 1, 1, 1, 0, -1, -1, -1};
        int[] dirYoffset = new int[]{-1, -1, 0, 1, 1, 1, 0, -1};
        int[] dirOffset = new int[]{-width, -width + 1, 1, width + 1, width, width - 1, -1, -width - 1};
        int pixelPointerMask = 15;
        int[] pixelPointers = new int[pixelPointerMask + 1];
        double grayRef = MagicWand.getPixel(grayPixels, dataType, xStart, yStart, width);
        double lowLimit = grayRef - mws.valueTolerance;
        double highLimit = grayRef + mws.valueTolerance;
        boolean colorMode = mws.colorSensitivity > -100.0 && sizeC == 3 && channel == -1;
        int[] rgb = new int[3];
        int[] rgb0 = new int[3];
        double[] rgbWeights = new double[3];
        if (colorMode) {
            MagicWand.getRGBPixel(pixels, dataType, xStart, yStart, width, rgb0);
            if (mws.colorSensitivity < 0.0) {
                rgbWeights[0] = 0.299;
                rgbWeights[1] = 0.587;
                rgbWeights[2] = 0.114;
            }
        }
        boolean useGradient = mws.gradientTolerance > 0.0 && mws.gradientTolerance < mws.valueTolerance;
        double toleranceGrayGradTmp = mws.gradientTolerance;
        double toleranceGrayGrad2 = MagicWand.sqr(toleranceGrayGradTmp);
        int ymin = height;
        int lastCoord = 0;
        int offset0 = MagicWand.getOffset(xStart, yStart, width);
        maskPixels[offset0] = -1;
        pixelPointers[0] = offset0;
        for (int iCoord = 0; iCoord <= lastCoord; ++iCoord) {
            int offset = pixelPointers[iCoord & pixelPointerMask];
            int x = offset % width;
            int y = offset / width;
            boolean isInner = x != 0 && y != 0 && x != width - 1 && y != height - 1;
            double v = MagicWand.getPixel(grayPixels, dataType, x, y, width);
            boolean largeGradient = false;
            double xGradient = 0.0;
            double yGradient = 0.0;
            if (useGradient) {
                if (isInner) {
                    double vmm = MagicWand.getPixel(grayPixels, dataType, x - 1, y - 1, width);
                    double v_m = MagicWand.getPixel(grayPixels, dataType, x, y - 1, width);
                    double vpm = MagicWand.getPixel(grayPixels, dataType, x + 1, y - 1, width);
                    double vm_ = MagicWand.getPixel(grayPixels, dataType, x - 1, y, width);
                    double vp_ = MagicWand.getPixel(grayPixels, dataType, x + 1, y, width);
                    double vmp = MagicWand.getPixel(grayPixels, dataType, x - 1, y + 1, width);
                    double v_p = MagicWand.getPixel(grayPixels, dataType, x, y + 1, width);
                    double vpp = MagicWand.getPixel(grayPixels, dataType, x + 1, y + 1, width);
                    xGradient = 0.125 * (2.0 * (vp_ - vm_) + (vpp - vmm) + (vpm - vmp));
                    yGradient = 0.125 * (2.0 * (v_p - v_m) + (vpp - vmm) - (vpm - vmp));
                } else {
                    int xCount = 0;
                    int yCount = 0;
                    for (int d = 0; d < 8; ++d) {
                        if (!MagicWand.isWithin(width, height, x, y, d)) continue;
                        int x2 = x + dirXoffset[d];
                        int y2 = y + dirYoffset[d];
                        double v2 = MagicWand.getPixel(grayPixels, dataType, x2, y2, width);
                        int weight = 2 - (d & 1);
                        xGradient += (double)dirXoffset[d] * (v2 - v) * (double)weight;
                        xCount += weight * (dirXoffset[d] != 0 ? 1 : 0);
                        yGradient += (double)dirYoffset[d] * (v2 - v) * (double)weight;
                        yCount += weight * (dirYoffset[d] != 0 ? 1 : 0);
                    }
                    xGradient /= (double)xCount;
                    yGradient /= (double)yCount;
                }
                largeGradient = MagicWand.sqr(xGradient) + MagicWand.sqr(yGradient) > toleranceGrayGrad2;
            }
            for (int d = 0; d < 8; d += mws.connectivity == MagicWandConnectivity.CONNECT4 ? 2 : 1) {
                boolean valueOK;
                int offset2 = offset + dirOffset[d];
                if (!isInner && !MagicWand.isWithin(width, height, x, y, d) || maskPixels[offset2] != 0) continue;
                int x2 = x + dirXoffset[d];
                int y2 = y + dirYoffset[d];
                double v2 = 0.0;
                if (largeGradient || !colorMode) {
                    v2 = MagicWand.getPixel(grayPixels, dataType, x2, y2, width);
                }
                if (colorMode) {
                    MagicWand.getRGBPixel(pixels, dataType, offset2, rgb);
                    valueOK = MagicWand.checkColor(rgb, rgb0, rgbWeights, mws);
                } else {
                    boolean bl = valueOK = v2 >= lowLimit && v2 <= highLimit;
                }
                if (!valueOK) {
                    maskPixels[offset2] = 1;
                    continue;
                }
                if (largeGradient && !((v2 - v) * (xGradient * (double)dirXoffset[d] + yGradient * (double)dirYoffset[d]) <= 0.0)) continue;
                maskPixels[offset2] = -1;
                if (ymin > y2) {
                    ymin = y2;
                }
                if (lastCoord - iCoord > pixelPointerMask) {
                    int newSize = 2 * (pixelPointerMask + 1);
                    int newMask = newSize - 1;
                    int[] newPixelPointers = new int[newSize];
                    System.arraycopy(pixelPointers, 0, newPixelPointers, 0, pixelPointerMask + 1);
                    System.arraycopy(pixelPointers, 0, newPixelPointers, pixelPointerMask + 1, pixelPointerMask + 1);
                    pixelPointers = newPixelPointers;
                    pixelPointerMask = newMask;
                }
                pixelPointers[++lastCoord & pixelPointerMask] = offset2;
            }
            if ((iCoord & 0xFFF) != 1 || !Thread.currentThread().isInterrupted()) continue;
            return null;
        }
        boolean[] boolMask = new boolean[width * height];
        for (int i = 0; i < boolMask.length; ++i) {
            boolMask[i] = maskPixels[i] == -1;
        }
        ROI2DArea result = new ROI2DArea(new BooleanMask2D(new Rectangle(0, 0, width, height), boolMask));
        result.optimizeBounds();
        if (sequence.getSizeT() > 1) {
            result.setT(t);
        }
        if (sequence.getSizeZ() > 1) {
            result.setZ(z);
        }
        return result;
    }

    public static ROI3D doWand3D(Sequence sequence, int xStart, int yStart, int zStart, int t, int channel, double valueTolerance, double colorSensitivity, double gradientTolerance) {
        if (sequence == null) {
            return null;
        }
        MagicWandSetting mws = new MagicWandSetting();
        mws.valueTolerance = valueTolerance;
        mws.colorSensitivity = colorSensitivity;
        mws.gradientTolerance = gradientTolerance;
        return MagicWand.doWand3D(sequence, t, xStart, yStart, zStart, channel, mws);
    }

    public static ROI3D doWand3D(Sequence sequence, int x, int y, int z, int t, int channel, MagicWandSetting mws) {
        return null;
    }

    private static int getOffset(int x, int y, int w) {
        return y * w + x;
    }

    private static double getPixel(Object pixels, DataType dataType, int offset) {
        return Array1DUtil.getValue(pixels, offset, dataType);
    }

    private static double getPixel(Object pixels, DataType dataType, int x, int y, int w) {
        return MagicWand.getPixel(pixels, dataType, MagicWand.getOffset(x, y, w));
    }

    private static void getRGBPixel(Object[] pixels, DataType dataType, int offset, int[] dest) {
        dest[0] = (int)Array1DUtil.getValue(pixels[0], offset, dataType);
        dest[1] = (int)Array1DUtil.getValue(pixels[1], offset, dataType);
        dest[2] = (int)Array1DUtil.getValue(pixels[2], offset, dataType);
    }

    private static void getRGBPixel(Object[] pixels, DataType dataType, int x, int y, int w, int[] dest) {
        MagicWand.getRGBPixel(pixels, dataType, MagicWand.getOffset(x, y, w), dest);
    }

    private static boolean checkColor(int[] rgb, int[] rgb0, double[] rgbWeights, MagicWandSetting mws) {
        int r = rgb[0];
        int g = rgb[1];
        int b = rgb[2];
        int r0 = rgb0[0];
        int g0 = rgb0[1];
        int b0 = rgb0[2];
        int deltaR = r - r0;
        int deltaG = g - g0;
        int deltaB = b - b0;
        double deltaSqr = MagicWand.sqr(deltaR) + MagicWand.sqr(deltaG) + MagicWand.sqr(deltaB);
        if (mws.colorSensitivity == 0.0 || r0 == 0 && g0 == 0 && b0 == 0) {
            return deltaSqr <= 3.0 * MagicWand.sqr(mws.valueTolerance);
        }
        if (mws.colorSensitivity < 0.0) {
            double deltaGray = (double)deltaR * rgbWeights[0] + (double)deltaG * rgbWeights[1] + (double)deltaB * rgbWeights[2];
            return deltaSqr * (0.3333333333333333 + 0.0033333333333333335 * mws.colorSensitivity) - 0.01 * mws.colorSensitivity * MagicWand.sqr(deltaGray) <= MagicWand.sqr(mws.valueTolerance);
        }
        double rgb0Sqr = MagicWand.sqr(r0) + MagicWand.sqr(g0) + MagicWand.sqr(b0);
        double deltaParSqr = MagicWand.sqr(deltaR * r0 + deltaG * g0 + deltaB * b0) / rgb0Sqr;
        double deltaPerpSqr = 0.0;
        double deltaPerpSqrFactor = 0.0;
        if (r == 0 && g == 0 && b == 0) {
            double eps = 1.0E-6;
            double cosine = (double)(r0 + g0 + b0) / (Math.sqrt(3.0) * Math.sqrt(rgb0Sqr));
            deltaParSqr = MagicWand.sqr(Math.sqrt(deltaSqr - cosine * 1.0E-6));
            deltaPerpSqr = (1.0 - MagicWand.sqr(cosine)) * MagicWand.sqr(1.0E-6);
            deltaPerpSqrFactor = (1.0 - 0.01 * mws.colorSensitivity + 0.01 * mws.colorSensitivity * rgb0Sqr) / MagicWand.sqr(1.0E-6);
        } else {
            deltaPerpSqr = deltaSqr - deltaParSqr;
            deltaPerpSqrFactor = (1.0 - 0.01 * mws.colorSensitivity + 0.01 * mws.colorSensitivity * rgb0Sqr) / (MagicWand.sqr(r) + MagicWand.sqr(g) + MagicWand.sqr(b));
        }
        return deltaParSqr * (1.0 - 0.01 * mws.colorSensitivity) + deltaPerpSqr * deltaPerpSqrFactor <= 3.0 * MagicWand.sqr(mws.valueTolerance);
    }

    private static boolean isWithin(int w, int h, int x, int y, int direction) {
        int xmax = w - 1;
        int ymax = h - 1;
        switch (direction) {
            default: {
                return false;
            }
            case 0: {
                return y > 0;
            }
            case 1: {
                return x < xmax && y > 0;
            }
            case 2: {
                return x < xmax;
            }
            case 3: {
                return x < xmax && y < ymax;
            }
            case 4: {
                return y < ymax;
            }
            case 5: {
                return x > 0 && y < ymax;
            }
            case 6: {
                return x > 0;
            }
            case 7: 
        }
        return x > 0 && y > 0;
    }

    private static double sqr(double x) {
        return x * x;
    }

    public static class MagicWandSetting {
        public double valueTolerance = 0.0;
        public double gradientTolerance = 0.0;
        public double colorSensitivity = 0.0;
        public MagicWandConnectivity connectivity = MagicWandConnectivity.CONNECT8;
    }

    public static enum MagicWandConnectivity {
        CONNECT8,
        CONNECT4;


        public String toString() {
            switch (this) {
                default: {
                    return "4 ways";
                }
                case CONNECT8: 
            }
            return "8 ways";
        }
    }

    public static enum MagicWandGradientToleranceMode {
        DISABLED,
        FIXED,
        P50,
        P40,
        P33,
        P25,
        P20,
        P15,
        P10,
        P05;


        public String toString() {
            switch (this) {
                default: {
                    return "Disabled";
                }
                case FIXED: {
                    return "Fixed value";
                }
                case P50: {
                    return "50% of value tolerance";
                }
                case P40: {
                    return "40% of value tolerance";
                }
                case P33: {
                    return "33% of value tolerance";
                }
                case P25: {
                    return "25% of value tolerance";
                }
                case P20: {
                    return "20% of value tolerance";
                }
                case P15: {
                    return "15% of value tolerance";
                }
                case P10: {
                    return "10% of value tolerance";
                }
                case P05: 
            }
            return "5% of value tolerance";
        }
    }
}

