/*
 * Decompiled with CFR 0.152.
 */
package icy.gui.lut;

import icy.gui.component.math.HistogramPanel;
import icy.gui.dialog.MessageDialog;
import icy.gui.lut.LUTViewer;
import icy.gui.lut.ScalerBoundsSettingDialog;
import icy.gui.viewer.Viewer;
import icy.gui.viewer.ViewerEvent;
import icy.gui.viewer.ViewerListener;
import icy.image.lut.LUT;
import icy.math.Histogram;
import icy.math.MathUtil;
import icy.math.Scaler;
import icy.sequence.Sequence;
import icy.sequence.SequenceEvent;
import icy.sequence.SequenceListener;
import icy.system.thread.ThreadUtil;
import icy.type.DataType;
import icy.type.collection.array.Array1DUtil;
import icy.util.ColorUtil;
import icy.util.EventUtil;
import icy.util.GraphicsUtil;
import icy.util.StringUtil;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.awt.geom.Point2D;
import java.lang.reflect.Array;
import java.util.EventListener;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.event.EventListenerList;

public class ScalerViewer
extends JPanel
implements SequenceListener,
LUT.LUTChannelListener,
ViewerListener {
    private static final long serialVersionUID = -1236985071716650592L;
    private static final int ISOVER_DEFAULT_MARGIN = 3;
    Viewer viewer;
    LUT.LUTChannel lutChannel;
    private ScalerHistogramPanel histogram;
    private boolean histoNeedRefresh;
    private final EventListenerList scalerMapPositionListeners;
    private final Runnable histoUpdater;
    String message;
    private int retry;

    public ScalerViewer(Viewer viewer, LUT.LUTChannel lutChannel) {
        this.viewer = viewer;
        this.lutChannel = lutChannel;
        this.message = "";
        this.retry = 0;
        this.scalerMapPositionListeners = new EventListenerList();
        this.histoUpdater = new Runnable(){

            @Override
            public void run() {
                try {
                    ScalerViewer.this.refreshHistoDataInternal();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        };
        this.histogram = new ScalerHistogramPanel(lutChannel.getScaler());
        this.histogram.addListener(new HistogramPanel.HistogramPanelListener(){

            @Override
            public void histogramNeedRefresh(HistogramPanel source) {
                ScalerViewer.this.internalRequestHistoDataRefresh();
            }
        });
        this.histoNeedRefresh = false;
        this.setLayout(new BorderLayout());
        this.add((Component)this.histogram, "Center");
        this.validate();
        this.internalRequestHistoDataRefresh();
        Sequence sequence = viewer.getSequence();
        if (sequence != null) {
            sequence.addListener(this);
        }
        viewer.addListener(this);
        lutChannel.addListener(this);
    }

    public void requestHistoDataRefresh() {
        this.internalRequestHistoDataRefresh();
    }

    private boolean isHistoVisible() {
        if (!this.isValid()) {
            return false;
        }
        return this.getVisibleRect().intersects(this.histogram.getBounds());
    }

    void internalRequestHistoDataRefresh() {
        if (this.isHistoVisible()) {
            this.refreshHistoData();
        } else {
            this.histoNeedRefresh = true;
        }
    }

    void updateHisto() {
        if (this.histoNeedRefresh) {
            this.refreshHistoData();
            this.histoNeedRefresh = false;
        }
    }

    private void refreshHistoData() {
        ThreadUtil.bgRunSingle(this.histoUpdater);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void refreshHistoDataInternal() {
        Histogram histo = this.histogram.getHistogram();
        Sequence seq = this.viewer.getSequence();
        this.histogram.reset();
        try {
            if (seq != null) {
                int maxZ;
                int maxT;
                int t = this.viewer.getPositionT();
                int z = this.viewer.getPositionZ();
                if (t != -1) {
                    maxT = t;
                } else {
                    t = 0;
                    maxT = seq.getSizeT() - 1;
                }
                if (z != -1) {
                    maxZ = z;
                } else {
                    z = 0;
                    maxZ = seq.getSizeZ() - 1;
                }
                int c = this.lutChannel.getChannel();
                while (t <= maxT) {
                    while (z <= maxZ) {
                        Object data = seq.getDataXY(t, z, c);
                        if (data != null) {
                            DataType dataType = seq.getDataType_();
                            int len = Array.getLength(data);
                            for (int i = 0; i < len; ++i) {
                                if ((i & 0xFFF) == 0 && ThreadUtil.hasWaitingBgSingleTask(this.histoUpdater)) {
                                    return;
                                }
                                histo.addValue(Array1DUtil.getValue(data, i, dataType));
                            }
                        }
                        ++z;
                    }
                    ++t;
                }
            }
            this.retry = 0;
        }
        catch (Exception e) {
            if (this.retry++ < 3) {
                this.refreshHistoData();
            }
        }
        finally {
            this.histogram.done();
            if (histo != this.histogram.getHistogram()) {
                this.refreshHistoData();
            }
        }
    }

    public HistogramPanel getHistogram() {
        return this.histogram;
    }

    public double[] getHistoData() {
        return this.histogram.getHistogramData();
    }

    public Scaler getScaler() {
        return this.lutChannel.getScaler();
    }

    public double getLowBound() {
        return this.lutChannel.getMin();
    }

    public double getHighBound() {
        return this.lutChannel.getMax();
    }

    void setLowBound(double value) {
        this.lutChannel.setMin(value);
    }

    void setHighBound(double value) {
        this.lutChannel.setMax(value);
    }

    public void onScalerChanged() {
        Scaler s = this.getScaler();
        this.histogram.setMinMaxIntValues(s.getAbsLeftIn(), s.getAbsRightIn(), s.isIntegerData());
        this.repaint();
    }

    void onSequenceDataChanged() {
        LUTViewer lutViewer = this.viewer.getLutViewer();
        if (lutViewer != null && lutViewer.getAutoRefreshHistogram()) {
            this.requestHistoDataRefresh();
        }
    }

    private void onPositionChanged() {
        LUTViewer lutViewer = this.viewer.getLutViewer();
        if (lutViewer != null && lutViewer.getAutoRefreshHistogram()) {
            this.requestHistoDataRefresh();
        }
    }

    public String getMessage() {
        return this.message;
    }

    public void setMessage(String value) {
        if (!StringUtil.equals(this.message, value)) {
            this.message = value;
            this.repaint();
        }
    }

    public void scaleTypeChanged(boolean log) {
        if (log) {
            this.histogram.setLogScaling(true);
        } else {
            this.histogram.setLogScaling(false);
        }
    }

    protected void showSettingPopup(Point pos) {
        JPopupMenu menu = new JPopupMenu("Actions");
        JMenuItem refreshItem = new JMenuItem("Refresh now");
        refreshItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ScalerViewer.this.requestHistoDataRefresh();
            }
        });
        JMenuItem setBoundsItem = new JMenuItem("Set range");
        setBoundsItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ScalerViewer.this.showRangeSettingDialog();
            }
        });
        JMenuItem exportItem = new JMenuItem("Export to excel");
        exportItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    ScalerViewer.this.getHistogram().getHistogram().doXLSExport();
                }
                catch (Exception e1) {
                    MessageDialog.showDialog("Error", e1.getMessage(), 0);
                }
            }
        });
        menu.add(refreshItem);
        menu.add(setBoundsItem);
        menu.add(exportItem);
        menu.pack();
        menu.validate();
        menu.show(this, pos.x, pos.y);
    }

    void showRangeSettingDialog() {
        ScalerBoundsSettingDialog boundsSettingDialog = new ScalerBoundsSettingDialog(this.lutChannel);
        boundsSettingDialog.pack();
        boundsSettingDialog.setLocationRelativeTo(this);
        boundsSettingDialog.setVisible(true);
    }

    public void addScalerPositionListener(ScalerPositionListener listener) {
        this.scalerMapPositionListeners.add(ScalerPositionListener.class, listener);
    }

    public void removeScalerPositionListener(ScalerPositionListener listener) {
        this.scalerMapPositionListeners.remove(ScalerPositionListener.class, listener);
    }

    public void scalerPositionChanged(double index, int value, double normalizedValue) {
        for (ScalerPositionListener listener : (ScalerPositionListener[])this.scalerMapPositionListeners.getListeners(ScalerPositionListener.class)) {
            listener.positionChanged(index, value, normalizedValue);
        }
    }

    @Override
    public void lutChannelChanged(LUT.LUTChannelEvent event) {
        if (event.getType() == LUT.LUTChannelEvent.LUTChannelEventType.SCALER_CHANGED) {
            this.onScalerChanged();
        }
    }

    @Override
    public void viewerChanged(ViewerEvent event) {
        if (event.getType() == ViewerEvent.ViewerEventType.POSITION_CHANGED) {
            this.onPositionChanged();
        }
    }

    @Override
    public void viewerClosed(Viewer viewer) {
        viewer.removeListener(this);
    }

    @Override
    public void sequenceChanged(SequenceEvent sequenceEvent) {
        if (sequenceEvent.getSourceType() == SequenceEvent.SequenceEventSourceType.SEQUENCE_DATA) {
            this.onSequenceDataChanged();
        }
    }

    @Override
    public void sequenceClosed(Sequence sequence) {
        sequence.removeListener(this);
    }

    public class ScalerHistogramPanel
    extends HistogramPanel
    implements MouseListener,
    MouseMotionListener,
    MouseWheelListener {
        private static final long serialVersionUID = -7020904979961676368L;
        private actionType action;
        private final Point2D positionInfo;
        private boolean mouseOnLeft;

        public ScalerHistogramPanel(Scaler s) {
            super(s.getAbsLeftIn(), s.getAbsRightIn(), s.isIntegerData());
            this.action = actionType.NULL;
            this.positionInfo = new Point2D.Double();
            this.mouseOnLeft = false;
            this.setMinimumSize(new Dimension(100, 100));
            this.setPreferredSize(new Dimension(240, 100));
            this.addMouseListener(this);
            this.addMouseMotionListener(this);
            this.addMouseWheelListener(this);
        }

        private void updateCursor(Point pos) {
            int cursor = this.action != actionType.NULL ? 10 : (this.isOverX(pos, this.getLowBoundPos()) || this.isOverX(pos, this.getHighBoundPos()) || this.isOverX(pos, this.getMiddlePos()) ? 12 : 0);
            if (this.getCursor().getType() != cursor) {
                this.setCursor(Cursor.getPredefinedCursor(cursor));
            }
        }

        private void setPositionInfo(double index, int value, double normalizedValue) {
            if (this.positionInfo.getX() != index || this.positionInfo.getY() != (double)value) {
                this.positionInfo.setLocation(index, normalizedValue);
                ScalerViewer.this.scalerPositionChanged(index, value, normalizedValue);
                this.repaint();
            }
        }

        private boolean isOverX(Point p, int u) {
            return this.isOver(p.x, p.y, u, -1, 3);
        }

        private boolean isOver(int x, int y, int u, int v, int margin) {
            boolean x_ok = u == -1 || x >= u - margin && x <= u + margin;
            boolean y_ok = v == -1 || y >= v - margin && y <= v + margin;
            return x_ok && y_ok;
        }

        public int getLowBoundPos() {
            return this.dataToPixel(ScalerViewer.this.getLowBound());
        }

        public int getHighBoundPos() {
            return this.dataToPixel(ScalerViewer.this.getHighBound());
        }

        public int getMiddlePos() {
            return (this.getHighBoundPos() + this.getLowBoundPos()) / 2;
        }

        private void setLowBoundPos(int pos) {
            ScalerViewer.this.setLowBound(this.pixelToData(pos));
        }

        private void setHighBoundPos(int pos) {
            ScalerViewer.this.setHighBound(this.pixelToData(pos));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected void paintComponent(Graphics g) {
            ScalerViewer.this.updateHisto();
            super.paintComponent(g);
            Graphics2D g2 = (Graphics2D)g.create();
            try {
                if (this.positionInfo.getX() != -1.0) {
                    int x = this.dataToPixel(this.positionInfo.getX());
                    int hRange = this.getClientHeight() - 1;
                    int bottom = hRange + this.getClientY();
                    int y = bottom - (int)(this.positionInfo.getY() * (double)hRange);
                    g2.setColor(ColorUtil.xor(this.getForeground()));
                    g2.drawLine(x, bottom, x, y);
                }
                this.paintBounds(g2);
                if (!StringUtil.isEmpty(ScalerViewer.this.message)) {
                    g2.setFont(new Font("SansSerif", 1, 12));
                    Rectangle hintBounds = GraphicsUtil.getHintBounds(g2, ScalerViewer.this.message, 10, 4);
                    if (this.mouseOnLeft) {
                        GraphicsUtil.drawHint(g2, ScalerViewer.this.message, this.getWidth() - (10 + hintBounds.width), 4, this.getForeground(), this.getBackground());
                    } else {
                        GraphicsUtil.drawHint(g2, ScalerViewer.this.message, 10, 4, this.getForeground(), this.getBackground());
                    }
                }
            }
            finally {
                g2.dispose();
            }
        }

        private void paintBounds(Graphics2D g) {
            int h = this.getClientHeight() - 1;
            int y = this.getClientY();
            int lowBound = this.getLowBoundPos();
            int highBound = this.getHighBoundPos();
            int middle = this.getMiddlePos();
            g.setColor(ColorUtil.mix(Color.blue, Color.white, false));
            g.drawRect(lowBound - 2, y, 2, h);
            g.setColor(Color.blue);
            g.fillRect(lowBound - 1, y + 1, 1, h - 1);
            g.setColor(ColorUtil.mix(Color.red, Color.white, false));
            g.drawRect(highBound - 1, y, 2, h);
            g.setColor(Color.red);
            g.fillRect(highBound, y + 1, 1, h - 1);
            g.setColor(ColorUtil.mix(Color.green, Color.white, false));
            g.drawRect(middle - 1, y + 10, 1, h - 10);
            g.setColor(Color.green);
            g.fillRect(middle, y + 11, 0, h - 11);
        }

        private void updateMessage(MouseEvent e) {
            String text;
            Point pos = e.getPoint();
            boolean shift = EventUtil.isShiftDown(e);
            boolean left = EventUtil.isLeftMouseButton(e);
            if (this.getBinNumber() > 0) {
                int bin = this.pixelToBin(pos.x);
                double index = this.pixelToData(pos.x);
                int value = this.getBinSize(bin);
                if (this.isIntegerType()) {
                    index = Math.floor(index);
                }
                String valueText = "value : " + MathUtil.roundSignificant(index, 5, true);
                String pixelText = "pixel number : " + value;
                text = valueText + "\n" + pixelText;
                this.setPositionInfo(index, value, this.getAdjustedBinSize(bin));
            } else {
                text = "";
            }
            if (this.action != actionType.NULL) {
                if (!StringUtil.isEmpty(text)) {
                    text = text + "\n";
                }
                text = shift ? text + "GLOBAL MOVE" : text + "Maintain 'Shift' for global move";
            }
            ScalerViewer.this.setMessage(text);
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            if (e.isConsumed()) {
                return;
            }
            if (e.getClickCount() == 2) {
                ScalerViewer.this.showRangeSettingDialog();
                e.consume();
            }
        }

        @Override
        public void mouseEntered(MouseEvent e) {
            this.updateCursor(e.getPoint());
            this.updateMessage(e);
        }

        @Override
        public void mouseExited(MouseEvent e) {
            if (this.getCursor().getType() != Cursor.getDefaultCursor().getType()) {
                this.setCursor(Cursor.getDefaultCursor());
            }
            ScalerViewer.this.setMessage("");
            this.setPositionInfo(-1.0, -1, -1.0);
        }

        @Override
        public void mousePressed(MouseEvent e) {
            if (e.isConsumed()) {
                return;
            }
            Point pos = e.getPoint();
            if (EventUtil.isLeftMouseButton(e)) {
                if (this.isOverX(pos, this.getLowBoundPos())) {
                    this.action = actionType.MODIFY_LOWBOUND;
                } else if (this.isOverX(pos, this.getHighBoundPos())) {
                    this.action = actionType.MODIFY_HIGHBOUND;
                } else if (this.isOverX(pos, this.getMiddlePos())) {
                    this.action = actionType.MODIFY_MIDDLE;
                }
                this.updateCursor(e.getPoint());
                e.consume();
            } else if (EventUtil.isRightMouseButton(e)) {
                ScalerViewer.this.showSettingPopup(pos);
                e.consume();
            }
            this.updateMessage(e);
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            if (EventUtil.isLeftMouseButton(e)) {
                this.action = actionType.NULL;
                this.updateCursor(e.getPoint());
            }
            this.updateMessage(e);
        }

        @Override
        public void mouseDragged(MouseEvent e) {
            if (e.isConsumed()) {
                return;
            }
            Point pos = e.getPoint();
            boolean shift = EventUtil.isShiftDown(e);
            this.mouseOnLeft = pos.x < this.getWidth() / 2;
            switch (this.action) {
                case MODIFY_LOWBOUND: {
                    this.setLowBoundPos(pos.x);
                    if (shift) {
                        double newLowBound = ScalerViewer.this.getLowBound();
                        for (LUT.LUTChannel lc : ScalerViewer.this.lutChannel.getLut().getLutChannels()) {
                            lc.setMin(newLowBound);
                        }
                    }
                    e.consume();
                    break;
                }
                case MODIFY_HIGHBOUND: {
                    this.setHighBoundPos(pos.x);
                    if (shift) {
                        double newHighBound = ScalerViewer.this.getHighBound();
                        for (LUT.LUTChannel lc : ScalerViewer.this.lutChannel.getLut().getLutChannels()) {
                            lc.setMax(newHighBound);
                        }
                    }
                    e.consume();
                    break;
                }
                case MODIFY_MIDDLE: {
                    double width = (ScalerViewer.this.getHighBound() - ScalerViewer.this.getLowBound()) / 2.0;
                    double value = this.pixelToData(pos.x);
                    double min = value - width;
                    double max = value + width;
                    if (shift) {
                        for (LUT.LUTChannel lc : ScalerViewer.this.lutChannel.getLut().getLutChannels()) {
                            if (!(min >= lc.getMinBound()) || !(max <= lc.getMaxBound())) continue;
                            lc.setMin(min);
                            lc.setMax(max);
                        }
                    } else if (min >= ScalerViewer.this.lutChannel.getMinBound() && max <= ScalerViewer.this.lutChannel.getMaxBound()) {
                        ScalerViewer.this.setLowBound(min);
                        ScalerViewer.this.setHighBound(max);
                    }
                    e.consume();
                }
            }
            this.updateMessage(e);
        }

        @Override
        public void mouseMoved(MouseEvent e) {
            Point pos = e.getPoint();
            this.mouseOnLeft = pos.x < this.getWidth() / 2;
            this.updateCursor(e.getPoint());
            this.updateMessage(e);
        }

        @Override
        public void mouseWheelMoved(MouseWheelEvent e) {
        }
    }

    public static interface ScalerPositionListener
    extends EventListener {
        public void positionChanged(double var1, int var3, double var4);
    }

    protected static enum actionType {
        NULL,
        MODIFY_LOWBOUND,
        MODIFY_HIGHBOUND,
        MODIFY_MIDDLE;

    }
}

