/*
 * Decompiled with CFR 0.152.
 */
package loci.formats.in;

import java.io.IOException;
import loci.common.RandomAccessInputStream;
import loci.formats.CoreMetadata;
import loci.formats.FormatException;
import loci.formats.FormatReader;
import loci.formats.FormatTools;
import loci.formats.MetadataTools;
import loci.formats.meta.MetadataStore;

public class KhorosReader
extends FormatReader {
    public static final int KHOROS_MAGIC_BYTES = 43777;
    private byte[][] lut;
    private long offset;

    public KhorosReader() {
        super("Khoros XV", "xv");
        this.domains = new String[]{"Graphics"};
    }

    @Override
    public boolean isThisType(RandomAccessInputStream stream) throws IOException {
        int blockLen = 2;
        if (!FormatTools.validStream(stream, 2, false)) {
            return false;
        }
        return stream.readShort() == 43777;
    }

    @Override
    public byte[][] get8BitLookupTable() throws FormatException, IOException {
        FormatTools.assertId(this.currentId, true, 1);
        return this.lut;
    }

    @Override
    public byte[] openBytes(int no, byte[] buf, int x, int y, int w, int h2) throws FormatException, IOException {
        FormatTools.checkPlaneParameters(this, no, buf.length, x, y, w, h2);
        int bufSize = FormatTools.getPlaneSize(this);
        this.in.seek(this.offset + (long)(no * bufSize));
        this.readPlane(this.in, x, y, w, h2, buf);
        return buf;
    }

    @Override
    public void close(boolean fileOnly) throws IOException {
        super.close(fileOnly);
        if (!fileOnly) {
            this.lut = null;
            this.offset = 0L;
        }
    }

    @Override
    protected void initFile(String id) throws FormatException, IOException {
        super.initFile(id);
        this.in = new RandomAccessInputStream(id);
        this.in.skipBytes(4);
        this.in.order(true);
        int dependency = this.in.readInt();
        this.addGlobalMeta("Comment", this.in.readString(512));
        this.in.order(dependency == 4 || dependency == 8);
        CoreMetadata m3 = (CoreMetadata)this.core.get(0);
        m3.sizeX = this.in.readInt();
        m3.sizeY = this.in.readInt();
        this.in.skipBytes(28);
        m3.imageCount = this.in.readInt();
        if (this.getImageCount() == 0) {
            m3.imageCount = 1;
        }
        m3.sizeC = this.in.readInt();
        int type = this.in.readInt();
        switch (type) {
            case 0: {
                m3.pixelType = 0;
                break;
            }
            case 1: {
                m3.pixelType = 1;
                break;
            }
            case 2: {
                m3.pixelType = 3;
                break;
            }
            case 4: {
                m3.pixelType = 4;
                break;
            }
            case 5: {
                m3.pixelType = 6;
                break;
            }
            case 9: {
                m3.pixelType = 7;
                break;
            }
            default: {
                throw new FormatException("Unsupported pixel type : " + type);
            }
        }
        this.in.skipBytes(12);
        int c = this.in.readInt();
        if (c > 1) {
            m3.sizeC = c;
            int n = this.in.readInt();
            this.lut = new byte[c][n];
            this.in.skipBytes(436);
            for (int i = 0; i < this.lut.length; ++i) {
                for (int j = 0; j < this.lut[0].length; ++j) {
                    this.lut[i][j] = this.in.readByte();
                }
            }
        } else {
            this.in.skipBytes(440);
        }
        this.offset = this.in.getFilePointer();
        m3.sizeZ = this.getImageCount();
        m3.sizeT = 1;
        m3.rgb = this.getSizeC() > 1;
        m3.interleaved = false;
        m3.littleEndian = dependency == 4 || dependency == 8;
        m3.dimensionOrder = "XYCZT";
        m3.indexed = this.lut != null;
        m3.falseColor = false;
        m3.metadataComplete = true;
        if (this.isIndexed()) {
            m3.sizeC = 1;
            m3.rgb = false;
        }
        MetadataStore store = this.makeFilterMetadata();
        MetadataTools.populatePixels(store, this);
    }
}

