/*
 * Decompiled with CFR 0.152.
 */
package plugins.nchenouard.particletracking.legacytracker.gui;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import javax.swing.JLabel;
import plugins.nchenouard.particletracking.filtering.KF2dRandomWalk;
import plugins.nchenouard.particletracking.filtering.KF3dRandomWalk;
import plugins.nchenouard.particletracking.filtering.KalmanFilter;
import plugins.nchenouard.particletracking.filtering.Predictor;
import plugins.nchenouard.particletracking.legacytracker.gui.FilterCovariancesPanel;
import plugins.nchenouard.particletracking.legacytracker.gui.PredictorPanel;

public class RandomWalkPanel
extends PredictorPanel {
    private static final long serialVersionUID = 2396842098905570570L;
    public static final String name = "Brownian motion";
    private FilterCovariancesPanel covPanel = new FilterCovariancesPanel();

    public RandomWalkPanel() {
        GridBagLayout mainLayout = new GridBagLayout();
        this.setLayout(mainLayout);
        GridBagConstraints constraints = new GridBagConstraints();
        constraints.gridheight = 1;
        constraints.gridwidth = 1;
        constraints.gridx = 0;
        constraints.gridy = 0;
        constraints.fill = 2;
        this.add((Component)new JLabel("Motion covariance"), constraints);
        ++constraints.gridy;
        this.add((Component)this.covPanel, constraints);
    }

    @Override
    public Predictor buildPredictor(int dim) {
        return this.buildPredictor(dim, true);
    }

    @Override
    public Predictor buildPredictor(int dim, boolean covUpdate) {
        KalmanFilter predictor = null;
        if (dim == 2) {
            predictor = new KF2dRandomWalk();
            predictor.setTrackingCovariances(new double[]{this.covPanel.getTrackingCovX(), this.covPanel.getTrackingCovY()});
            ((KF2dRandomWalk)predictor).setUpdateCovariances(covUpdate);
        } else {
            predictor = new KF3dRandomWalk();
            predictor.setTrackingCovariances(new double[]{this.covPanel.getTrackingCovX(), this.covPanel.getTrackingCovY(), this.covPanel.getTrackingCovZ()});
            ((KF3dRandomWalk)predictor).setUpdateCovariances(covUpdate);
        }
        return predictor;
    }

    @Override
    public String getName() {
        return name;
    }

    @Override
    public void setDefaultValues() {
        this.covPanel.setDefaultValues();
    }
}

