/*
 * Decompiled with CFR 0.152.
 */
package plugins.adufour.protocols.gui.block;

import icy.file.FileUtil;
import icy.file.Loader;
import icy.file.SequenceFileImporter;
import icy.gui.dialog.ConfirmDialog;
import icy.system.thread.ThreadUtil;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.geom.Rectangle2D;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JLayeredPane;
import javax.swing.JPopupMenu;
import javax.swing.TransferHandler;
import plugins.adufour.blocks.lang.Block;
import plugins.adufour.blocks.lang.BlockDescriptor;
import plugins.adufour.blocks.lang.Link;
import plugins.adufour.blocks.lang.WorkFlow;
import plugins.adufour.blocks.util.BlocksFinder;
import plugins.adufour.blocks.util.LinkCutException;
import plugins.adufour.blocks.util.VarList;
import plugins.adufour.blocks.util.WorkFlowListener;
import plugins.adufour.protocols.Protocols;
import plugins.adufour.protocols.gui.MainFrame;
import plugins.adufour.protocols.gui.block.BlockPanel;
import plugins.adufour.protocols.gui.block.LoopPanel;
import plugins.adufour.protocols.gui.block.WorkFlowPanel;
import plugins.adufour.protocols.gui.link.Line;
import plugins.adufour.protocols.gui.link.RoundedSquareLine;
import plugins.adufour.vars.lang.Var;

public class WorkFlowContainer
extends JLayeredPane
implements WorkFlowListener,
DropTargetListener,
KeyListener {
    private static final long serialVersionUID = 1L;
    private final WorkFlow workFlow;
    private final HashMap<BlockDescriptor, BlockPanel> blockPanels = new HashMap();
    private final HashMap<Link<?>, Line> linkLines = new HashMap();
    private final boolean editable;
    private final BlockSelector blockSelector = new BlockSelector();
    private final JPopupMenu popupMenu;
    private WorkFlowPanel parentPanel = null;
    private Rectangle graphicSelectionHint = new Rectangle();
    private static final int TRANSPARENCY = 25;
    public static final Color TRANSPARENT_BLUE = new Color(Color.BLUE.getRed(), Color.BLUE.getGreen(), Color.BLUE.getBlue(), 25);

    @Override
    public void paint(Graphics g) {
        super.paint(g);
        g.setColor(TRANSPARENT_BLUE);
        g.drawRect(this.graphicSelectionHint.x, this.graphicSelectionHint.y, this.graphicSelectionHint.width, this.graphicSelectionHint.height);
    }

    public WorkFlowContainer(WorkFlow workFlow, boolean editable) {
        new DropTarget(this, this);
        this.setTransferHandler(new MenuItemTransferHandler());
        this.editable = editable;
        this.popupMenu = new JPopupMenu("Insert a new block...");
        if (editable) {
            this.addMouseListener(this.blockSelector);
            this.addMouseMotionListener(this.blockSelector);
        }
        this.addKeyListener(this);
        this.setFocusable(true);
        this.requestFocus();
        this.workFlow = workFlow;
        for (BlockDescriptor blockDescriptor : workFlow) {
            this.blockAdded(workFlow, blockDescriptor);
        }
        for (Link link : workFlow.getLinksIterator()) {
            this.linkAdded(workFlow, link);
        }
        this.workFlow.addListener(this);
    }

    private <T> void addGraphicalLink(final Link<T> link) {
        ThreadUtil.invokeLater((Runnable)new Runnable(){

            @Override
            public void run() {
                BlockPanel srcBlockPanel = WorkFlowContainer.this.getBlockPanel(link.srcBlock);
                BlockPanel dstBlockPanel = WorkFlowContainer.this.getBlockPanel(link.dstBlock);
                if (srcBlockPanel == null || dstBlockPanel == null) {
                    System.err.println("Warning: cannot recover link between " + link.srcBlock.getDefinedName() + " and " + link.dstBlock.getDefinedName() + " !");
                } else {
                    WorkFlowContainer.this.linkLines.put(link, new RoundedSquareLine(srcBlockPanel, dstBlockPanel, link));
                    if (dstBlockPanel instanceof WorkFlowPanel) {
                        WorkFlowContainer innerFlow = ((WorkFlowPanel)dstBlockPanel).innerFlowPane;
                        BlockDescriptor targetInnerlBlock = innerFlow.workFlow.getInputOwner(link.dstVar);
                        innerFlow.getBlockPanel(targetInnerlBlock).refreshNow();
                    } else {
                        dstBlockPanel.refreshNow();
                    }
                    WorkFlowContainer.this.repaint();
                }
            }
        }, (boolean)true);
    }

    @Override
    public void blockAdded(WorkFlow targetWorkFlow, final BlockDescriptor blockDesc) {
        if (targetWorkFlow != this.workFlow) {
            return;
        }
        ThreadUtil.invokeNow((Runnable)new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                BlockPanel panel = blockDesc.isLoop() ? new LoopPanel(WorkFlowContainer.this, blockDesc) : (blockDesc.isWorkFlow() ? new WorkFlowPanel(WorkFlowContainer.this, blockDesc) : new BlockPanel(WorkFlowContainer.this, blockDesc));
                ((BlockPanel)panel).drawPanel();
                WorkFlowContainer.this.blockPanels.put(blockDesc, panel);
                WorkFlowContainer.this.add(panel);
                if (blockDesc.isWorkFlow()) {
                    VarList varList = blockDesc.inputVars;
                    synchronized (varList) {
                        for (Var<?> var : blockDesc.inputVars) {
                            ((WorkFlowPanel)panel).updateExposedLink(var, blockDesc.inputVars.isVisible(var));
                        }
                    }
                    varList = blockDesc.outputVars;
                    synchronized (varList) {
                        for (Var<?> var : blockDesc.outputVars) {
                            ((WorkFlowPanel)panel).updateExposedLink(var, blockDesc.outputVars.isVisible(var));
                        }
                    }
                }
                WorkFlowContainer.this.setLayer(panel, blockDesc.isWorkFlow() ? 1 : 0, 0);
                WorkFlowContainer.this.updatePreferredSize();
                WorkFlowContainer.this.repaint();
            }
        });
    }

    @Override
    public void blockCollapsed(WorkFlow source, BlockDescriptor block, boolean collapsed) {
    }

    @Override
    public void blockDimensionChanged(WorkFlow source, BlockDescriptor block, int newWidth, int newHeight) {
        if (source != this.workFlow) {
            return;
        }
        this.updatePreferredSize();
        this.repaint();
    }

    @Override
    public void blockLocationChanged(WorkFlow source, BlockDescriptor block, int newX, int newY) {
        if (source != this.workFlow) {
            return;
        }
        this.updatePreferredSize();
        this.repaint();
    }

    @Override
    public void blockRemoved(WorkFlow targetWorkFlow, BlockDescriptor blockInfo) {
        if (targetWorkFlow != this.workFlow) {
            return;
        }
        final BlockPanel panel = this.blockPanels.remove(blockInfo);
        targetWorkFlow.unselectBlock(blockInfo);
        for (Link<?> l : this.linkLines.keySet()) {
            if (!l.dstBlock.equals(blockInfo) && !l.srcBlock.equals(blockInfo)) continue;
            targetWorkFlow.unselectLink(l);
        }
        if (panel == null) {
            return;
        }
        ThreadUtil.invokeLater((Runnable)new Runnable(){

            @Override
            public void run() {
                panel.dispose();
                WorkFlowContainer.this.remove(panel);
                WorkFlowContainer.this.updatePreferredSize();
                WorkFlowContainer.this.repaint();
            }
        });
    }

    @Override
    public void blockStatusChanged(WorkFlow source, BlockDescriptor block, BlockDescriptor.BlockStatus status) {
    }

    @Override
    public void blockVariableAdded(WorkFlow source, BlockDescriptor block, Var<?> variable) {
    }

    @Override
    public <T> void blockVariableChanged(WorkFlow source, BlockDescriptor block, Var<T> variable, T newValue) {
    }

    public void dispose() {
        this.workFlow.removeListener(this);
        this.removeMouseListener(this.blockSelector);
        this.removeMouseMotionListener(this.blockSelector);
        this.removeKeyListener(this);
        for (BlockPanel panel : this.blockPanels.values()) {
            panel.dispose();
        }
        this.blockPanels.clear();
        for (Line line : this.linkLines.values()) {
            line.dispose();
        }
        this.linkLines.clear();
    }

    public void embedWorkFlow(Class<? extends WorkFlow> embedType) throws InstantiationException, IllegalAccessException {
        if (this.workFlow.size() == 0) {
            return;
        }
        try {
            MainFrame.copySelection(this.workFlow, true);
            this.doEmbedWorkflow(embedType);
        }
        catch (LinkCutException e) {
            if (ConfirmDialog.confirm((String)"Warning", (String)e.getMessage(), (int)2)) {
                this.doEmbedWorkflow(embedType);
            }
            this.requestFocus();
        }
    }

    private void doEmbedWorkflow(Class<? extends WorkFlow> embedType) throws InstantiationException, IllegalAccessException {
        WorkFlow embed = embedType.newInstance();
        if (!this.workFlow.getBlockSelection().isEmpty()) {
            for (Link<?> l : this.workFlow.getLinkSelection()) {
                this.workFlow.removeLink(l.dstVar);
            }
            while (!this.workFlow.getBlockSelection().isEmpty()) {
                BlockDescriptor tmp = this.workFlow.getBlockSelection().get(0);
                if (tmp.getBlock() instanceof WorkFlow) {
                    ((WorkFlow)tmp.getBlock()).newSelection();
                }
                this.workFlow.removeBlock(tmp, true);
            }
        } else {
            ArrayList tmp = new ArrayList();
            for (Link<Object> l : this.workFlow.getLinksIterator()) {
                tmp.add(l);
            }
            for (Link<Object> l : tmp) {
                this.workFlow.removeLink(l.dstVar);
            }
            int i = 0;
            while (i < this.workFlow.size()) {
                this.workFlow.removeBlock(this.workFlow.getBlock(i), true);
            }
        }
        MainFrame.pasteSelection(embed, true);
        this.workFlow.addBlock(embed.getBlockDescriptor());
    }

    public Rectangle getContentsBoundingBox() {
        if (this.blockPanels.size() == 0) {
            return new Rectangle(0, 0, this.getWidth(), this.getHeight());
        }
        Rectangle bounds = null;
        for (BlockPanel panel : this.blockPanels.values()) {
            bounds = bounds == null ? new Rectangle(panel.getBounds()) : bounds.union(panel.getBounds());
        }
        int border = 20;
        bounds.x -= border;
        bounds.y -= border;
        bounds.width += border * 2;
        bounds.height += border * 2;
        return bounds;
    }

    public BlockPanel getBlockPanel(BlockDescriptor blockInfo) {
        if (blockInfo == null) {
            return null;
        }
        if (blockInfo.getBlock() == this.workFlow) {
            return this.getParentPanel();
        }
        return this.blockPanels.get(blockInfo);
    }

    WorkFlowPanel getParentPanel() {
        return this.parentPanel;
    }

    public WorkFlow getWorkFlow() {
        return this.workFlow;
    }

    public boolean isEditable() {
        return this.editable;
    }

    @Override
    public void linkAdded(WorkFlow targetWorkFlow, Link<?> link) {
        if (targetWorkFlow != this.workFlow) {
            return;
        }
        this.addGraphicalLink(link);
    }

    @Override
    public void linkRemoved(WorkFlow targetWorkFlow, final Link<?> link) {
        if (targetWorkFlow != this.workFlow) {
            return;
        }
        ThreadUtil.invokeLater((Runnable)new Runnable(){

            @Override
            public void run() {
                WorkFlowContainer.this.removeGraphicalLink(link);
            }
        });
    }

    @Override
    public void paintChildren(Graphics g) {
        Graphics2D g2 = (Graphics2D)g.create();
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        if (this.workFlow.size() == 0) {
            String s = "Right-click to insert a block...";
            g2.setColor(Color.gray);
            g2.setFont(g2.getFont().deriveFont(2));
            Rectangle2D r = g2.getFontMetrics().getStringBounds(s, g);
            g2.drawString(s, (float)((double)(this.getWidth() / 2) - r.getWidth() / 2.0), (float)((double)(this.getHeight() / 2) + r.getHeight() / 2.0));
        }
        for (Line line : this.linkLines.values()) {
            line.update();
            line.paint(g2);
        }
        g2.dispose();
        super.paintChildren(g);
    }

    private void removeGraphicalLink(Link<?> link) {
        Line line = this.linkLines.remove(link);
        if (line == null) {
            System.err.println("Warning: missing link, cannot be removed properly");
        } else {
            line.dispose();
        }
        BlockPanel dstBlockPanel = this.getBlockPanel(link.dstBlock);
        if (dstBlockPanel != null) {
            if (dstBlockPanel instanceof WorkFlowPanel) {
                WorkFlowContainer innerFlow = ((WorkFlowPanel)dstBlockPanel).innerFlowPane;
                BlockDescriptor targetInnerlBlock = innerFlow.workFlow.getInputOwner(link.dstVar);
                innerFlow.getBlockPanel(targetInnerlBlock).refreshNow();
            } else {
                dstBlockPanel.refreshNow();
            }
        }
        this.repaint();
    }

    public void selectAllBlocks() {
        this.blockSelector.selectBlocks(this.getBounds());
        this.blockSelector.validateSelection();
    }

    @Override
    public void repaint() {
        super.repaint();
        if (this.parentPanel != null) {
            this.parentPanel.repaint();
        }
    }

    void setParentPanel(WorkFlowPanel panel) {
        this.parentPanel = panel;
    }

    @Override
    public void statusChanged(WorkFlow source, String message) {
    }

    protected void updatePreferredSize() {
        Rectangle r = new Rectangle();
        int minx = 0;
        int miny = 0;
        for (Component component : this.getComponents()) {
            component.getBounds(r);
            if (r.x < minx) {
                minx = r.x;
            }
            if (r.y >= miny) continue;
            miny = r.y;
        }
        Dimension dim = new Dimension();
        for (Component component : this.getComponents()) {
            component.getBounds(r);
            if (minx < 0) {
                r.x -= minx;
            }
            if (miny < 0) {
                r.y -= miny;
            }
            if (!r.getLocation().equals(component.getLocation())) {
                component.setLocation(r.getLocation());
            }
            dim.width = Math.max(Math.max(dim.width, dim.width - r.x), r.x + r.width);
            dim.height = Math.max(dim.height, r.y + r.height);
        }
        this.setPreferredSize(dim);
        this.revalidate();
    }

    @Override
    public void workFlowReordered(WorkFlow source) {
        for (BlockPanel panel : this.blockPanels.values()) {
            panel.refresh();
        }
    }

    @Override
    public void keyPressed(KeyEvent key) {
        if (key.getKeyCode() == 127 || key.getKeyCode() == 8) {
            ArrayList<BlockDescriptor> tmp = new ArrayList<BlockDescriptor>(this.workFlow.getBlockSelection());
            for (BlockDescriptor bd : tmp) {
                this.workFlow.removeBlock(bd, true);
            }
        } else {
            Protocols.dispatchEvent(key);
        }
    }

    @Override
    public void keyTyped(KeyEvent key) {
    }

    @Override
    public void keyReleased(KeyEvent key) {
    }

    @Override
    public void dragEnter(DropTargetDragEvent dtde) {
    }

    @Override
    public void dragExit(DropTargetEvent dte) {
    }

    @Override
    public void dragOver(DropTargetDragEvent dtde) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void drop(DropTargetDropEvent dtde) {
        try {
            Transferable t = dtde.getTransferable();
            DataFlavor[] d = t.getTransferDataFlavors();
            Point mouseLocation = dtde.getLocation();
            MenuItemTransferHandler menuItemTransferHandler = (MenuItemTransferHandler)this.getTransferHandler();
            dtde.acceptDrop(3);
            if (t.getTransferData(d[0]) instanceof BlocksFinder.DND_MenuItem) {
                BlocksFinder.DND_MenuItem menuItem = (BlocksFinder.DND_MenuItem)t.getTransferData(d[0]);
                if (menuItemTransferHandler.canImport(this, d)) {
                    menuItemTransferHandler.importData(this, menuItem, mouseLocation);
                }
            } else if (t.isDataFlavorSupported(DataFlavor.javaFileListFlavor)) {
                List files = (List)t.getTransferData(DataFlavor.javaFileListFlavor);
                ArrayList<String> xmlFiles = new ArrayList<String>();
                ArrayList<String> otherFiles = new ArrayList<String>();
                for (File file : files) {
                    String path = file.getPath();
                    if (FileUtil.getFileExtension((String)path, (boolean)false).equalsIgnoreCase("xml") || FileUtil.getFileExtension((String)path, (boolean)false).equalsIgnoreCase("protocol")) {
                        xmlFiles.add(path);
                        continue;
                    }
                    otherFiles.add(path);
                }
                for (String path : xmlFiles) {
                    Protocols.loadWorkFlow(new File(path));
                }
                for (String path : otherFiles) {
                    SequenceFileImporter importer = Loader.getSequenceFileImporter((String)path, (boolean)true);
                    if (importer == null) continue;
                    Loader.load((String)path, (boolean)true);
                }
            }
        }
        catch (UnsupportedFlavorException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            dtde.dropComplete(true);
        }
    }

    @Override
    public void dropActionChanged(DropTargetDragEvent dtde) {
    }

    protected class BlockSelector
    extends MouseAdapter {
        int pressedX;
        int pressedY;
        ArrayList<Link<?>> currentlySelectedLinks = new ArrayList();
        ArrayList<BlockDescriptor> currentlySelectedBlocks = new ArrayList();

        protected BlockSelector() {
        }

        @Override
        public void mousePressed(MouseEvent e) {
            if (e.getButton() == 1) {
                if ((e.getModifiers() & Protocols.MENU_SHORTCUT_KEY) != Protocols.MENU_SHORTCUT_KEY) {
                    WorkFlowContainer.this.workFlow.newSelection();
                    for (BlockPanel bp : WorkFlowContainer.this.blockPanels.values()) {
                        bp.setSelected(false);
                    }
                    for (Line l : WorkFlowContainer.this.linkLines.values()) {
                        l.setSelected(false);
                    }
                }
                if (e.getComponent() instanceof BlockPanel) {
                    BlockDescriptor bd = ((BlockPanel)e.getComponent()).blockDesc;
                    if (!this.currentlySelectedBlocks.contains(bd) && !WorkFlowContainer.this.workFlow.isBlockSelected(bd)) {
                        this.currentlySelectedBlocks.add(bd);
                        ((BlockPanel)WorkFlowContainer.this.blockPanels.get(bd)).setSelected(true);
                    } else {
                        this.currentlySelectedBlocks.remove(bd);
                        WorkFlowContainer.this.workFlow.unselectBlock(bd);
                        ((BlockPanel)WorkFlowContainer.this.blockPanels.get(bd)).setSelected(false);
                    }
                    this.selectLinks();
                } else {
                    this.currentlySelectedBlocks = new ArrayList();
                    this.currentlySelectedLinks = new ArrayList();
                    WorkFlowContainer.this.graphicSelectionHint = new Rectangle();
                }
                this.pressedX = e.getX();
                this.pressedY = e.getY();
            }
        }

        @Override
        public void mouseDragged(MouseEvent e) {
            if (e.getButton() == 1) {
                Rectangle selection = new Rectangle(Math.min(e.getX(), this.pressedX), Math.min(e.getY(), this.pressedY), Math.abs(this.pressedX - e.getX()), Math.abs(this.pressedY - e.getY()));
                this.selectBlocks(selection);
                WorkFlowContainer.this.graphicSelectionHint = selection;
                WorkFlowContainer.this.revalidate();
                WorkFlowContainer.this.repaint();
            }
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            if (e.getButton() == 1) {
                this.validateSelection();
                WorkFlowContainer.this.requestFocus();
                WorkFlowContainer.this.revalidate();
                WorkFlowContainer.this.repaint();
            }
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            if (e.getButton() == 2 || e.isMetaDown()) {
                WorkFlowContainer.this.popupMenu.removeAll();
                new BlocksFinder().createJMenu(WorkFlowContainer.this.popupMenu, WorkFlowContainer.this, e.getPoint());
                WorkFlowContainer.this.popupMenu.show(WorkFlowContainer.this, e.getX(), e.getY());
            } else {
                for (Link link : WorkFlowContainer.this.linkLines.keySet()) {
                    if (!((Line)WorkFlowContainer.this.linkLines.get(link)).isOverCloseButton(e.getPoint())) continue;
                    WorkFlowContainer.this.workFlow.removeLink(link.dstVar);
                    break;
                }
            }
        }

        @Override
        public void mouseMoved(MouseEvent e) {
            for (Line l : WorkFlowContainer.this.linkLines.values()) {
                l.setCustomColor(l.contains(e.getX(), e.getY()));
            }
        }

        private void selectBlocks(Rectangle rectangle) {
            for (BlockDescriptor bd : WorkFlowContainer.this.blockPanels.keySet()) {
                boolean containsBlock = rectangle.intersects(((BlockPanel)WorkFlowContainer.this.blockPanels.get(bd)).getBounds());
                if (!this.currentlySelectedBlocks.contains(bd)) {
                    if (!containsBlock) continue;
                    this.currentlySelectedBlocks.add(bd);
                    ((BlockPanel)WorkFlowContainer.this.blockPanels.get(bd)).setSelected(true);
                    continue;
                }
                if (containsBlock) continue;
                this.currentlySelectedBlocks.remove(bd);
                if (WorkFlowContainer.this.workFlow.isBlockSelected(bd)) continue;
                ((BlockPanel)WorkFlowContainer.this.blockPanels.get(bd)).setSelected(false);
            }
            this.selectLinks();
        }

        private void selectLinks() {
            for (Link l : WorkFlowContainer.this.linkLines.keySet()) {
                boolean containsLink;
                boolean bl = containsLink = !(!this.currentlySelectedBlocks.contains(l.srcBlock) && !WorkFlowContainer.this.workFlow.isBlockSelected(l.srcBlock) || !this.currentlySelectedBlocks.contains(l.dstBlock) && !WorkFlowContainer.this.workFlow.isBlockSelected(l.dstBlock));
                if (!this.currentlySelectedLinks.contains(l)) {
                    if (!containsLink) continue;
                    this.currentlySelectedLinks.add(l);
                    ((Line)WorkFlowContainer.this.linkLines.get(l)).setSelected(true);
                    continue;
                }
                if (containsLink) continue;
                this.currentlySelectedLinks.remove(l);
                ((Line)WorkFlowContainer.this.linkLines.get(l)).setSelected(false);
                WorkFlowContainer.this.workFlow.unselectLink(l);
            }
        }

        private void validateSelection() {
            for (BlockDescriptor blockDescriptor : this.currentlySelectedBlocks) {
                WorkFlowContainer.this.workFlow.selectBlock(blockDescriptor);
            }
            for (Link link : this.currentlySelectedLinks) {
                WorkFlowContainer.this.workFlow.selectLink(link);
            }
            WorkFlowContainer.this.graphicSelectionHint = new Rectangle();
        }
    }

    private class MenuItemTransferHandler
    extends TransferHandler {
        private MenuItemTransferHandler() {
        }

        @Override
        public boolean canImport(JComponent c, DataFlavor[] f) {
            try {
                DataFlavor tmp = new DataFlavor("application/x-java-jvm-local-objectref;class=java.util.ArrayList");
                for (DataFlavor d : f) {
                    if (!d.equals(tmp)) continue;
                    return true;
                }
            }
            catch (ClassNotFoundException e) {
                e.printStackTrace();
            }
            return false;
        }

        public void importData(WorkFlowContainer workFlowContainer, Transferable t, Point p) {
            try {
                BlocksFinder.DND_MenuItem item = (BlocksFinder.DND_MenuItem)t.getTransferData(new DataFlavor(BlocksFinder.DND_MenuItem.class, "MenuItem"));
                Class<Block> blockClass = item.getDescriptor().getPluginClass().asSubclass(Block.class);
                Block block = blockClass.newInstance();
                BlockDescriptor blockDesc = block instanceof WorkFlow ? ((WorkFlow)block).getBlockDescriptor() : new BlockDescriptor(-1, block);
                blockDesc.setLocation(p.x, p.y);
                workFlowContainer.getWorkFlow().addBlock(blockDesc);
                WorkFlowContainer.this.requestFocus();
            }
            catch (UnsupportedFlavorException e) {
                e.printStackTrace();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            catch (InstantiationException e) {
                e.printStackTrace();
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
        }
    }
}

